/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.collector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import zipkin2.Callback;
import zipkin2.Span;
import zipkin2.SpanBytesDecoderDetector;
import zipkin2.codec.BytesDecoder;
import zipkin2.collector.CollectorMetrics;
import zipkin2.collector.CollectorSampler;
import zipkin2.storage.StorageComponent;

public class Collector {
    final Logger logger;
    final CollectorMetrics metrics;
    final CollectorSampler sampler;
    final StorageComponent storage;

    public static Builder newBuilder(Class<?> loggingClass) {
        if (loggingClass == null) {
            throw new NullPointerException("loggingClass == null");
        }
        return new Builder(Logger.getLogger(loggingClass.getName()));
    }

    Collector(Builder builder) {
        if (builder.logger == null) {
            throw new NullPointerException("logger == null");
        }
        this.logger = builder.logger;
        CollectorMetrics collectorMetrics = this.metrics = builder.metrics == null ? CollectorMetrics.NOOP_METRICS : builder.metrics;
        if (builder.storage == null) {
            throw new NullPointerException("storage == null");
        }
        this.storage = builder.storage;
        this.sampler = builder.sampler == null ? CollectorSampler.ALWAYS_SAMPLE : builder.sampler;
    }

    public void accept(List<Span> spans, Callback<Void> callback) {
        if (spans.isEmpty()) {
            callback.onSuccess(null);
            return;
        }
        this.metrics.incrementSpans(spans.size());
        List<Span> sampled = this.sample(spans);
        if (sampled.isEmpty()) {
            callback.onSuccess(null);
            return;
        }
        try {
            this.record(sampled, this.acceptSpansCallback(sampled));
            callback.onSuccess(null);
        }
        catch (RuntimeException e) {
            callback.onError((Throwable)this.errorStoringSpans(sampled, e));
            return;
        }
    }

    public void acceptSpans(byte[] serialized, Callback<Void> callback) {
        BytesDecoder decoder;
        try {
            decoder = SpanBytesDecoderDetector.decoderForListMessage((byte[])serialized);
        }
        catch (RuntimeException e) {
            this.metrics.incrementBytes(serialized.length);
            callback.onError((Throwable)this.errorReading(e));
            return;
        }
        this.acceptSpans(serialized, (BytesDecoder<Span>)decoder, callback);
    }

    public void acceptSpans(byte[] serializedSpans, BytesDecoder<Span> decoder, Callback<Void> callback) {
        List<Span> spans;
        this.metrics.incrementBytes(serializedSpans.length);
        try {
            spans = this.decodeList(decoder, serializedSpans);
        }
        catch (RuntimeException e) {
            callback.onError((Throwable)this.errorReading(e));
            return;
        }
        this.accept(spans, callback);
    }

    List<Span> decodeList(BytesDecoder<Span> decoder, byte[] serialized) {
        ArrayList<Span> out = new ArrayList<Span>();
        if (!decoder.decodeList(serialized, out)) {
            return Collections.emptyList();
        }
        return out;
    }

    void record(List<Span> sampled, Callback<Void> callback) {
        this.storage.spanConsumer().accept(sampled).enqueue(callback);
    }

    String idString(Span span) {
        return span.traceId() + "/" + span.id();
    }

    boolean shouldWarn() {
        return this.logger.isLoggable(Level.FINE);
    }

    void warn(String message, Throwable e) {
        this.logger.log(Level.FINE, message, e);
    }

    List<Span> sample(List<Span> input) {
        ArrayList<Span> sampled = new ArrayList<Span>(input.size());
        int length = input.size();
        for (int i = 0; i < length; ++i) {
            Span s = input.get(i);
            if (!this.sampler.isSampled(s.traceId(), Boolean.TRUE.equals(s.debug()))) continue;
            sampled.add(s);
        }
        int dropped = input.size() - sampled.size();
        if (dropped > 0) {
            this.metrics.incrementSpansDropped(dropped);
        }
        return sampled;
    }

    Callback<Void> acceptSpansCallback(final List<Span> spans) {
        return new Callback<Void>(){

            public void onSuccess(Void value) {
            }

            public void onError(Throwable t) {
                Collector.this.errorStoringSpans(spans, t);
            }

            public String toString() {
                return Collector.this.appendSpanIds(spans, new StringBuilder("AcceptSpans(")).append(")").toString();
            }
        };
    }

    RuntimeException errorReading(Throwable e) {
        return this.errorReading("Cannot decode spans", e);
    }

    RuntimeException errorReading(String message, Throwable e) {
        this.metrics.incrementMessagesDropped();
        return this.doError(message, e);
    }

    RuntimeException errorStoringSpans(List<Span> spans, Throwable e) {
        this.metrics.incrementSpansDropped(spans.size());
        StringBuilder msg = this.appendSpanIds(spans, new StringBuilder("Cannot store spans "));
        return this.doError(msg.toString(), e);
    }

    RuntimeException doError(String message, Throwable e) {
        String error;
        String string = error = e.getMessage() != null ? e.getMessage() : "";
        if (e instanceof RuntimeException && (error.startsWith("Malformed") || error.startsWith("Truncated"))) {
            if (this.shouldWarn()) {
                this.warn(error, e);
            }
            return (RuntimeException)e;
        }
        if (this.shouldWarn()) {
            message = String.format("%s due to %s(%s)", message, e.getClass().getSimpleName(), error);
            this.warn(message, e);
        }
        return new RuntimeException(message, e);
    }

    StringBuilder appendSpanIds(List<Span> spans, StringBuilder message) {
        message.append("[");
        int i = 0;
        Iterator<Span> iterator = spans.iterator();
        while (iterator.hasNext() && i++ < 3) {
            message.append(this.idString(iterator.next()));
            if (!iterator.hasNext()) continue;
            message.append(", ");
        }
        if (iterator.hasNext()) {
            message.append("...");
        }
        return message.append("]");
    }

    public static final class Builder {
        final Logger logger;
        StorageComponent storage = null;
        CollectorSampler sampler = null;
        CollectorMetrics metrics = null;

        Builder(Logger logger) {
            this.logger = logger;
        }

        public Builder storage(StorageComponent storage) {
            if (storage == null) {
                throw new NullPointerException("storage == null");
            }
            this.storage = storage;
            return this;
        }

        public Builder metrics(CollectorMetrics metrics) {
            if (metrics == null) {
                throw new NullPointerException("metrics == null");
            }
            this.metrics = metrics;
            return this;
        }

        public Builder sampler(CollectorSampler sampler) {
            if (sampler == null) {
                throw new NullPointerException("sampler == null");
            }
            this.sampler = sampler;
            return this;
        }

        public Collector build() {
            return new Collector(this);
        }
    }
}

