/*
 * Decompiled with CFR 0.152.
 */
package me.ihxq.projects.pna.algorithm;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Optional;
import me.ihxq.projects.pna.Attribution;
import me.ihxq.projects.pna.ISP;
import me.ihxq.projects.pna.PhoneNumberInfo;
import me.ihxq.projects.pna.algorithm.LookupAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnotherBinarySearchAlgorithmImpl
implements LookupAlgorithm {
    private static final Logger log = LoggerFactory.getLogger(AnotherBinarySearchAlgorithmImpl.class);
    private ByteBuffer originalByteBuffer;
    private int indicesStartOffset;
    private int indicesEndOffset;

    @Override
    public void loadData(byte[] data) {
        this.originalByteBuffer = ByteBuffer.wrap(data).asReadOnlyBuffer();
        this.originalByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int dataVersion = this.originalByteBuffer.getInt();
        this.indicesStartOffset = this.originalByteBuffer.getInt(4);
        this.indicesEndOffset = this.originalByteBuffer.limit();
    }

    private int alignPosition(int pos) {
        int remain = (pos - this.indicesStartOffset) % 9;
        if (pos - this.indicesStartOffset < 9) {
            return pos - remain;
        }
        if (remain != 0) {
            return pos + 9 - remain;
        }
        return pos;
    }

    @Override
    public Optional<PhoneNumberInfo> lookup(String phoneNo) {
        byte b;
        int attributionIdentity;
        log.trace("try to resolve attribution of: {}", (Object)phoneNo);
        ByteBuffer byteBuffer = this.originalByteBuffer.asReadOnlyBuffer().order(ByteOrder.LITTLE_ENDIAN);
        if (phoneNo == null) {
            log.debug("phoneNo is null");
            return Optional.empty();
        }
        int phoneNoLength = phoneNo.length();
        if (phoneNoLength < 7 || phoneNoLength > 11) {
            log.debug("phoneNo {} is not acceptable, length invalid, length should range 7 to 11, actual: {}", (Object)phoneNo, (Object)phoneNoLength);
            return Optional.empty();
        }
        try {
            attributionIdentity = Integer.parseInt(phoneNo.substring(0, 7));
        }
        catch (NumberFormatException e) {
            log.debug("phoneNo {} is invalid, is it numeric?", (Object)phoneNo);
            return Optional.empty();
        }
        int left = this.indicesStartOffset;
        int right = this.indicesEndOffset;
        int mid = (left + right) / 2;
        mid = this.alignPosition(mid);
        while (mid >= left && mid <= right) {
            int remain;
            int tempMid;
            if (mid == right) {
                return Optional.empty();
            }
            int compare = this.compare(mid, attributionIdentity, byteBuffer);
            if (compare == 0) break;
            if (mid == left) {
                return Optional.empty();
            }
            if (compare > 0) {
                tempMid = (mid + left) / 2;
                tempMid = this.alignPosition(tempMid);
                right = mid;
                remain = (tempMid - this.indicesStartOffset) % 9;
                if (tempMid - this.indicesStartOffset < 9) {
                    mid = tempMid - remain;
                    continue;
                }
                if (remain != 0) {
                    mid = tempMid + 9 - remain;
                    continue;
                }
                mid = tempMid;
                continue;
            }
            tempMid = (mid + right) / 2;
            tempMid = this.alignPosition(tempMid);
            left = mid;
            remain = (tempMid - this.indicesStartOffset) % 9;
            if (tempMid - this.indicesStartOffset < 9) {
                mid = tempMid - remain;
                continue;
            }
            if (remain != 0) {
                mid = tempMid + 9 - remain;
                continue;
            }
            mid = tempMid;
        }
        byteBuffer.position(mid);
        int prefix = byteBuffer.getInt();
        int infoStartIndex = byteBuffer.getInt();
        byte ispMark = byteBuffer.get();
        Optional<ISP> isp = ISP.of(ispMark);
        byteBuffer.position(infoStartIndex);
        int resultBufferSize = 200;
        int increase = 100;
        byte[] bytes = new byte[resultBufferSize];
        int i = 0;
        while ((b = byteBuffer.get()) != 0) {
            bytes[i] = b;
            if (i == resultBufferSize - 1) {
                bytes = Arrays.copyOf(bytes, resultBufferSize += increase);
            }
            ++i;
        }
        String oriString = new String(bytes, 0, i);
        String[] split = oriString.split("\\|");
        Attribution build = Attribution.builder().province(split[0]).city(split[1]).zipCode(split[2]).areaCode(split[3]).build();
        return Optional.of(new PhoneNumberInfo(phoneNo, build, isp.orElse(ISP.UNKNOWN)));
    }

    private int compare(int position, int key, ByteBuffer byteBuffer) {
        int phonePrefix;
        byteBuffer.position(position);
        try {
            phonePrefix = byteBuffer.getInt();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return Integer.compare(phonePrefix, key);
    }
}

