/*
 * Decompiled with CFR 0.152.
 */
package me.ihxq.projects.pna.algorithm;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Optional;
import me.ihxq.projects.pna.Attribution;
import me.ihxq.projects.pna.ISP;
import me.ihxq.projects.pna.PhoneNumberInfo;
import me.ihxq.projects.pna.algorithm.LookupAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceLookupAlgorithmImpl
implements LookupAlgorithm {
    private static final Logger log = LoggerFactory.getLogger(SequenceLookupAlgorithmImpl.class);
    private ByteBuffer originalByteBuffer;
    private int indicesOffset;

    @Override
    public void loadData(byte[] data) {
        this.originalByteBuffer = ByteBuffer.wrap(data).asReadOnlyBuffer();
        this.originalByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int dataVersion = this.originalByteBuffer.getInt();
        this.indicesOffset = this.originalByteBuffer.getInt(4);
    }

    @Override
    public Optional<PhoneNumberInfo> lookup(String phoneNo) {
        int attributionIdentity;
        ByteBuffer byteBuffer = this.originalByteBuffer.asReadOnlyBuffer().order(ByteOrder.LITTLE_ENDIAN);
        log.trace("try resolve attribution of: {}", (Object)phoneNo);
        if (phoneNo == null) {
            log.debug("phoneNo is null");
            return Optional.empty();
        }
        int phoneNoLength = phoneNo.length();
        if (phoneNoLength < 7 || phoneNoLength > 11) {
            log.debug("phoneNo {} is not acceptable, length invalid, length should range 7 to 11, actual: {}", (Object)phoneNo, (Object)phoneNoLength);
            return Optional.empty();
        }
        try {
            attributionIdentity = Integer.parseInt(phoneNo.substring(0, 7));
        }
        catch (NumberFormatException e) {
            log.debug("phoneNo {} is invalid, is it numeric?", (Object)phoneNo);
            return Optional.empty();
        }
        int i = this.indicesOffset;
        while (i < byteBuffer.limit()) {
            byteBuffer.position(i);
            int phonePrefix = byteBuffer.getInt();
            int infoStart = byteBuffer.getInt();
            byte ispMark = byteBuffer.get();
            if (phonePrefix == attributionIdentity) {
                ISP isp = ISP.of(ispMark).orElse(ISP.UNKNOWN);
                byteBuffer.position(infoStart);
                while (byteBuffer.get() != 0) {
                }
                int infoEnd = byteBuffer.position() - 1;
                byteBuffer.position(infoStart);
                int length = infoEnd - infoStart;
                byte[] bytes = new byte[length];
                byteBuffer.get(bytes, 0, length);
                String oriString = new String(bytes);
                String[] split = oriString.split("\\|");
                Attribution build = Attribution.builder().province(split[0]).city(split[1]).zipCode(split[2]).areaCode(split[3]).build();
                return Optional.of(new PhoneNumberInfo(phoneNo, build, isp));
            }
            i = i + 8 + 1;
        }
        return Optional.empty();
    }
}

