/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import com.alibaba.fastjson.JSONObject;
import com.xkcoding.http.support.HttpHeader;
import java.util.HashMap;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthDefaultSource;
import me.zhyd.oauth.enums.AuthResponseStatus;
import me.zhyd.oauth.enums.AuthUserGender;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthDefaultRequest;
import me.zhyd.oauth.utils.HttpUtils;

public class AuthTeambitionRequest
extends AuthDefaultRequest {
    public AuthTeambitionRequest(AuthConfig config) {
        super(config, AuthDefaultSource.TEAMBITION);
    }

    public AuthTeambitionRequest(AuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthDefaultSource.TEAMBITION, authStateCache);
    }

    @Override
    protected AuthToken getAccessToken(AuthCallback authCallback) {
        HashMap<String, String> form = new HashMap<String, String>(7);
        form.put("client_id", this.config.getClientId());
        form.put("client_secret", this.config.getClientSecret());
        form.put("code", authCallback.getCode());
        form.put("grant_type", "code");
        String response = new HttpUtils(this.config.getHttpConfig()).post(this.source.accessToken(), form, false);
        JSONObject accessTokenObject = JSONObject.parseObject((String)response);
        this.checkResponse(accessTokenObject);
        return AuthToken.builder().accessToken(accessTokenObject.getString("access_token")).refreshToken(accessTokenObject.getString("refresh_token")).build();
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        String accessToken = authToken.getAccessToken();
        HttpHeader httpHeader = new HttpHeader();
        httpHeader.add("Authorization", "OAuth2 " + accessToken);
        String response = new HttpUtils(this.config.getHttpConfig()).get(this.source.userInfo(), null, httpHeader, false);
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        authToken.setUid(object.getString("_id"));
        return AuthUser.builder().rawUserInfo(object).uuid(object.getString("_id")).username(object.getString("name")).nickname(object.getString("name")).avatar(object.getString("avatarUrl")).blog(object.getString("website")).location(object.getString("location")).email(object.getString("email")).gender(AuthUserGender.UNKNOWN).token(authToken).source(this.source.toString()).build();
    }

    @Override
    public AuthResponse refresh(AuthToken oldToken) {
        String uid = oldToken.getUid();
        String refreshToken = oldToken.getRefreshToken();
        HashMap<String, String> form = new HashMap<String, String>(4);
        form.put("_userId", uid);
        form.put("refresh_token", refreshToken);
        String response = new HttpUtils(this.config.getHttpConfig()).post(this.source.refresh(), form, false);
        JSONObject refreshTokenObject = JSONObject.parseObject((String)response);
        this.checkResponse(refreshTokenObject);
        return AuthResponse.builder().code(AuthResponseStatus.SUCCESS.getCode()).data(AuthToken.builder().accessToken(refreshTokenObject.getString("access_token")).refreshToken(refreshTokenObject.getString("refresh_token")).build()).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"message") && object.containsKey((Object)"name")) {
            throw new AuthException(object.getString("name") + ", " + object.getString("message"));
        }
    }
}

