/*
 * Decompiled with CFR 0.152.
 */
package scala_maven;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import scala_maven.ScalaMojoSupport;
import scala_maven.VersionNumber;
import scala_maven_executions.JavaMainCallerInProcess;
import scala_maven_executions.MainHelper;

public class ScalaConsoleMojo
extends ScalaMojoSupport {
    protected String mainConsole;
    protected boolean useTestClasspath;
    protected boolean useRuntimeClasspath;
    protected File javaRebelPath;

    @Override
    protected void doExecute() throws Exception {
        VersionNumber scalaVersion = this.findScalaVersion();
        LinkedHashSet<String> classpath = new LinkedHashSet<String>();
        this.addCompilerToClasspath(classpath);
        this.addLibraryToClasspath(classpath);
        if (new VersionNumber("2.9.0").compareTo(scalaVersion) <= 0) {
            this.addToClasspath("org.scala-lang", "jline", scalaVersion.toString(), classpath);
        } else {
            this.addToClasspath("jline", "jline", "0.9.94", classpath);
        }
        classpath.addAll(this.project.getCompileClasspathElements());
        if (this.useTestClasspath) {
            classpath.addAll(this.project.getTestClasspathElements());
        }
        if (this.useRuntimeClasspath) {
            classpath.addAll(this.project.getRuntimeClasspathElements());
        }
        String classpathStr = MainHelper.toMultiPath(classpath.toArray(new String[classpath.size()]));
        JavaMainCallerInProcess jcmd = null;
        ArrayList<String> list = new ArrayList<String>(this.args != null ? this.args.length + 3 : 3);
        if (this.args != null) {
            for (String arg : this.args) {
                list.add(arg);
            }
        }
        list.add("-cp");
        list.add(classpathStr);
        if (this.fork) {
            this.getLog().warn((CharSequence)"scala-maven-plugin cannot fork scala console!!  Running in process");
        }
        jcmd = new JavaMainCallerInProcess(this, this.mainConsole, classpathStr, this.jvmArgs, list.toArray(new String[list.size()]));
        this.addCompilerPluginOptions(jcmd);
        if (this.javaRebelPath != null) {
            if (!this.javaRebelPath.exists()) {
                this.getLog().warn((CharSequence)("javaRevelPath '" + this.javaRebelPath.getCanonicalPath() + "' not found"));
            } else {
                jcmd.addJvmArgs("-noverify", "-javaagent:" + this.javaRebelPath.getCanonicalPath());
            }
        }
        jcmd.run(this.displayCmd);
    }
}

