/*
 * Decompiled with CFR 0.152.
 */
package scala_maven;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;
import scala_maven.ScalaDocMojo;

public class ScalaDocJarMojo
extends ScalaDocMojo {
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    private static final String[] DEFAULT_EXCLUDES = new String[0];
    private JarArchiver jarArchiver;
    private MavenProjectHelper projectHelper;
    private String finalName;
    private boolean attach;
    private boolean skip;
    private String jarOutputDirectory;
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    private File defaultManifestFile;
    private boolean useDefaultManifestFile;
    protected boolean failOnError;

    @Override
    public void doExecute() throws Exception {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping javadoc generation");
            return;
        }
        try {
            this.generate(null, Locale.getDefault());
            if (this.reportOutputDirectory.exists()) {
                File outputFile = this.generateArchive(this.reportOutputDirectory, this.finalName + "-" + this.getClassifier() + ".jar");
                if (!this.attach) {
                    this.getLog().info((CharSequence)"NOT adding javadoc to attached artifacts list.");
                } else {
                    this.projectHelper.attachArtifact(this.project, "javadoc", this.getClassifier(), outputFile);
                }
            }
        }
        catch (ArchiverException e) {
            this.failOnError("ArchiverException: Error while creating archive", (Exception)((Object)e));
        }
        catch (IOException e) {
            this.failOnError("IOException: Error while creating archive", e);
        }
        catch (MavenReportException e) {
            this.failOnError("MavenReportException: Error while creating archive", (Exception)((Object)e));
        }
        catch (RuntimeException e) {
            this.failOnError("RuntimeException: Error while creating archive", e);
        }
    }

    private File generateArchive(File javadocFiles, String jarFileName) throws ArchiverException, IOException {
        File javadocJar = new File(this.jarOutputDirectory, jarFileName);
        if (javadocJar.exists()) {
            javadocJar.delete();
        }
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(javadocJar);
        File contentDirectory = javadocFiles;
        if (!contentDirectory.exists()) {
            this.getLog().warn((CharSequence)"JAR will be empty - no content was marked for inclusion!");
        } else {
            archiver.getArchiver().addDirectory(contentDirectory, DEFAULT_INCLUDES, DEFAULT_EXCLUDES);
        }
        List resources = this.project.getBuild().getResources();
        for (Resource r : resources) {
            if (!r.getDirectory().endsWith("maven-shared-archive-resources")) continue;
            archiver.getArchiver().addDirectory(new File(r.getDirectory()));
        }
        if (this.useDefaultManifestFile && this.defaultManifestFile.exists() && this.archive.getManifestFile() == null) {
            this.getLog().info((CharSequence)("Adding existing MANIFEST to archive. Found under: " + this.defaultManifestFile.getPath()));
            this.archive.setManifestFile(this.defaultManifestFile);
        }
        try {
            this.archive.setAddMavenDescriptor(false);
            archiver.createArchive(this.project, this.archive);
        }
        catch (ManifestException e) {
            throw new ArchiverException("ManifestException: " + e.getMessage(), (Throwable)e);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new ArchiverException("DependencyResolutionRequiredException: " + e.getMessage(), (Throwable)e);
        }
        return javadocJar;
    }

    protected String getClassifier() {
        return "javadoc";
    }

    protected void failOnError(String prefix, Exception e) throws MojoExecutionException {
        if (this.failOnError) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new MojoExecutionException(prefix + ": " + e.getMessage(), e);
        }
        this.getLog().error((CharSequence)(prefix + ": " + e.getMessage()), (Throwable)e);
    }
}

