/*
 *  Copyright © 2005-2019 Amichai Rothman
 *
 *  This file is part of JCharset - the Java Charset package.
 *
 *  JCharset is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  JCharset is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with JCharset.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  For additional info see http://www.freeutils.net/source/jcharset/
 */

package net.freeutils.charset.iso646;

import net.freeutils.charset.ByteLookupCharset;

/**
 * The <b>ISO646CUCharset</b> class handles the encoding and decoding of the
 * ISO646-CU national variant of the ISO/IEC 646 charset.
 *
 * @author Amichai Rothman
 * @since  2015-08-18
 */
public class ISO646CUCharset extends ByteLookupCharset {

    static final String NAME = "ISO646-CU";

    static final String[] ALIASES = { "ISO-IR-151" };

    static final int[] BYTE_TO_CHAR = mutate(ISO646USCharset.BYTE_TO_CHAR,
        new int[] { 0x24, 0x5B, 0x5C, 0x5E, 0x7B, 0x7C, 0x7D, 0x7E },
        new int[] { 0xA4, 0xA1, 0xD1, 0xBF, 0xB4, 0xF1, 0x5B, 0xA8 });

    static final int[][] CHAR_TO_BYTE = createInverseLookupTable(BYTE_TO_CHAR);

    /**
     * Constructs an instance of the ISO646CUCharset.
     */
    public ISO646CUCharset() {
        super(NAME, ALIASES, BYTE_TO_CHAR, CHAR_TO_BYTE);
    }

}
