/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.opentype;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fontbox.encoding.Encoding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlyphMapReader {
    private static Logger log = LoggerFactory.getLogger(GlyphMapReader.class);
    private static Map<String, String> symbolCharToWord = new HashMap<String, String>();

    public static List<GlyphMapping> readGlyphsToNames(Map<Integer, String> idToNames, Encoding encoding) {
        ArrayList<GlyphMapping> glyphMappings = new ArrayList<GlyphMapping>();
        HashMap<Integer, Integer> usedCodes = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, String> nameSetOn : idToNames.entrySet()) {
            String name = nameSetOn.getValue();
            if (symbolCharToWord.containsKey(name)) {
                name = symbolCharToWord.get(name);
            }
            int charCode = GlyphMapReader.nameToCode(name, encoding, usedCodes);
            int glyphId = nameSetOn.getKey();
            if (charCode != 0) {
                glyphMappings.add(new GlyphMapping(glyphId, charCode, name));
                continue;
            }
            if (name.equals(".notdef")) continue;
            log.warn("Could not find character code for glyph name. Name:'{}' GlyphID:'{}'", (Object)nameSetOn.getValue(), (Object)nameSetOn.getKey());
        }
        return glyphMappings;
    }

    public static List<GlyphMapping> readCharCodesToGlyphs(Map<Integer, Integer> charCodeToGlyphIds, Encoding encoding) {
        ArrayList<GlyphMapping> glyphMappings = new ArrayList<GlyphMapping>();
        for (Map.Entry<Integer, Integer> entryOn : charCodeToGlyphIds.entrySet()) {
            Integer charCode = entryOn.getKey();
            Integer glyphId = entryOn.getValue();
            String name = encoding.getName(charCode.intValue());
            glyphMappings.add(new GlyphMapping(glyphId, charCode, name));
        }
        return glyphMappings;
    }

    private static int nameToCode(String name, Encoding encoding, Map<Integer, Integer> usedCodes) {
        if (symbolCharToWord.containsKey(name)) {
            name = symbolCharToWord.get(name);
        }
        int code = 0;
        for (Map.Entry entryOn : encoding.getCodeToNameMap().entrySet()) {
            int codeOn = (Integer)entryOn.getKey();
            if (!((String)entryOn.getValue()).equals(name) || usedCodes.containsKey(codeOn)) continue;
            code = (Integer)entryOn.getKey();
        }
        usedCodes.put(code, 0);
        return code;
    }

    static {
        symbolCharToWord.put(" ", "space");
        symbolCharToWord.put("!", "exclam");
        symbolCharToWord.put("#", "numbersign");
        symbolCharToWord.put("$", "dollar");
        symbolCharToWord.put("%", "percent");
        symbolCharToWord.put("&", "ampersand");
        symbolCharToWord.put("(", "parenleft");
        symbolCharToWord.put(")", "parenright");
        symbolCharToWord.put("*", "asterisk");
        symbolCharToWord.put("+", "plus");
        symbolCharToWord.put(",", "comma");
        symbolCharToWord.put("-", "hyphen");
        symbolCharToWord.put(".", "period");
        symbolCharToWord.put("/", "slash");
        symbolCharToWord.put("0", "zero");
        symbolCharToWord.put("1", "one");
        symbolCharToWord.put("2", "two");
        symbolCharToWord.put("3", "three");
        symbolCharToWord.put("4", "four");
        symbolCharToWord.put("5", "five");
        symbolCharToWord.put("6", "six");
        symbolCharToWord.put("7", "seven");
        symbolCharToWord.put("8", "eight");
        symbolCharToWord.put("9", "nine");
        symbolCharToWord.put(":", "colon");
        symbolCharToWord.put(";", "semicolon");
        symbolCharToWord.put("<", "less");
        symbolCharToWord.put("=", "equal");
        symbolCharToWord.put(">", "greater");
        symbolCharToWord.put("?", "question");
        symbolCharToWord.put("@", "at");
        symbolCharToWord.put("[", "bracketleft");
        symbolCharToWord.put("\\", "backslash");
        symbolCharToWord.put("]", "bracketright");
        symbolCharToWord.put("_", "underscore");
        symbolCharToWord.put("{", "braceleft");
        symbolCharToWord.put("}", "braceright");
        symbolCharToWord.put("\u00c1", "Aacute");
    }

    public static class GlyphMapping {
        public final Integer glyphId;
        public Integer charCode;
        public final String name;

        public GlyphMapping(Integer glyphId, Integer charCode, String name) {
            this.glyphId = glyphId;
            this.charCode = charCode;
            this.name = name;
        }
    }
}

