/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.File;
import java.io.IOException;
import java.util.List;
import proguard.util.ListUtil;

public class ClassPathEntry {
    private File file;
    private boolean output;
    private List filter;
    private List apkFilter;
    private List jarFilter;
    private List aarFilter;
    private List warFilter;
    private List earFilter;
    private List zipFilter;
    private String cachedName;

    public ClassPathEntry(File file, boolean isOutput) {
        this.file = file;
        this.output = isOutput;
    }

    public String getName() {
        if (this.cachedName == null) {
            this.cachedName = this.getUncachedName();
        }
        return this.cachedName;
    }

    private String getUncachedName() {
        try {
            return this.file.getCanonicalPath();
        }
        catch (IOException ex) {
            return this.file.getPath();
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
        this.cachedName = null;
    }

    public boolean isOutput() {
        return this.output;
    }

    public void setOutput(boolean output) {
        this.output = output;
    }

    public boolean isDex() {
        return this.hasExtension(".dex");
    }

    public boolean isApk() {
        return this.hasExtension(".apk") || this.hasExtension(".ap_");
    }

    public boolean isJar() {
        return this.hasExtension(".jar");
    }

    public boolean isAar() {
        return this.hasExtension(".aar");
    }

    public boolean isWar() {
        return this.hasExtension(".war");
    }

    public boolean isEar() {
        return this.hasExtension(".ear");
    }

    public boolean isZip() {
        return this.hasExtension(".zip");
    }

    private boolean hasExtension(String extension) {
        return ClassPathEntry.endsWithIgnoreCase(this.file.getPath(), extension);
    }

    private static boolean endsWithIgnoreCase(String string, String suffix) {
        int stringLength = string.length();
        int suffixLength = suffix.length();
        return string.regionMatches(true, stringLength - suffixLength, suffix, 0, suffixLength);
    }

    public boolean isFiltered() {
        return this.filter != null || this.apkFilter != null || this.jarFilter != null || this.aarFilter != null || this.warFilter != null || this.earFilter != null || this.zipFilter != null;
    }

    public List getFilter() {
        return this.filter;
    }

    public void setFilter(List filter) {
        this.filter = filter == null || filter.size() == 0 ? null : filter;
    }

    public List getApkFilter() {
        return this.apkFilter;
    }

    public void setApkFilter(List filter) {
        this.apkFilter = filter == null || filter.size() == 0 ? null : filter;
    }

    public List getJarFilter() {
        return this.jarFilter;
    }

    public void setJarFilter(List filter) {
        this.jarFilter = filter == null || filter.size() == 0 ? null : filter;
    }

    public List getAarFilter() {
        return this.aarFilter;
    }

    public void setAarFilter(List filter) {
        this.aarFilter = filter == null || filter.size() == 0 ? null : filter;
    }

    public List getWarFilter() {
        return this.warFilter;
    }

    public void setWarFilter(List filter) {
        this.warFilter = filter == null || filter.size() == 0 ? null : filter;
    }

    public List getEarFilter() {
        return this.earFilter;
    }

    public void setEarFilter(List filter) {
        this.earFilter = filter == null || filter.size() == 0 ? null : filter;
    }

    public List getZipFilter() {
        return this.zipFilter;
    }

    public void setZipFilter(List filter) {
        this.zipFilter = filter == null || filter.size() == 0 ? null : filter;
    }

    public String toString() {
        String string = this.getName();
        if (this.filter != null || this.jarFilter != null || this.aarFilter != null || this.warFilter != null || this.earFilter != null || this.zipFilter != null) {
            string = string + "(" + (this.aarFilter != null ? ListUtil.commaSeparatedString(this.aarFilter, true) : "") + ";" + (this.apkFilter != null ? ListUtil.commaSeparatedString(this.apkFilter, true) : "") + ";" + (this.zipFilter != null ? ListUtil.commaSeparatedString(this.zipFilter, true) : "") + ";" + (this.earFilter != null ? ListUtil.commaSeparatedString(this.earFilter, true) : "") + ";" + (this.warFilter != null ? ListUtil.commaSeparatedString(this.warFilter, true) : "") + ";" + (this.jarFilter != null ? ListUtil.commaSeparatedString(this.jarFilter, true) : "") + ";" + (this.filter != null ? ListUtil.commaSeparatedString(this.filter, true) : "") + ")";
        }
        return string;
    }
}

