/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.info.MethodOptimizationInfo;
import proguard.optimize.info.NoSideEffectMethodMarker;
import proguard.optimize.info.SideEffectInstructionChecker;

public class SideEffectMethodMarker
extends SimplifiedVisitor
implements ClassPoolVisitor,
ClassVisitor,
MemberVisitor,
AttributeVisitor {
    private final SideEffectInstructionChecker sideEffectInstructionChecker = new SideEffectInstructionChecker(false, true);
    private final SideEffectInstructionChecker initializerSideEffectInstructionChecker = new SideEffectInstructionChecker(false, false);
    private int newSideEffectCount;
    private boolean hasSideEffects;

    public void visitClassPool(ClassPool classPool) {
        do {
            this.newSideEffectCount = 0;
            classPool.classesAccept(this);
        } while (this.newSideEffectCount > 0);
    }

    public void visitProgramClass(ProgramClass programClass) {
        programClass.methodsAccept(this);
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        if (!SideEffectMethodMarker.hasSideEffects(programMethod) && !NoSideEffectMethodMarker.hasNoSideEffects(programMethod)) {
            boolean bl = this.hasSideEffects = (programMethod.getAccessFlags() & 0x120) != 0;
            if (!this.hasSideEffects) {
                programMethod.attributesAccept(programClass, this);
            }
            if (this.hasSideEffects) {
                SideEffectMethodMarker.markSideEffects(programMethod);
                ++this.newSideEffectCount;
            }
        }
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.hasSideEffects = this.hasSideEffects(clazz, method, codeAttribute);
    }

    private boolean hasSideEffects(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        Instruction instruction;
        byte[] code = codeAttribute.code;
        int length = codeAttribute.u4codeLength;
        SideEffectInstructionChecker checker = method.getName(clazz).equals("<clinit>") ? this.initializerSideEffectInstructionChecker : this.sideEffectInstructionChecker;
        int offset = 0;
        do {
            if (!checker.hasSideEffects(clazz, method, codeAttribute, offset, instruction = InstructionFactory.create(code, offset))) continue;
            return true;
        } while ((offset += instruction.length(offset)) < length);
        return false;
    }

    private static void markSideEffects(Method method) {
        MethodOptimizationInfo info = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        if (info != null) {
            info.setSideEffects();
        }
    }

    public static boolean hasSideEffects(Method method) {
        MethodOptimizationInfo info = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        return info == null || info.hasSideEffects();
    }
}

