/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.cyberneko;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import net.sourceforge.htmlunit.cyberneko.SecuritySupport;

class ObjectFactory {
    private static final String DEFAULT_PROPERTIES_FILENAME = "xerces.properties";
    private static final boolean DEBUG = false;
    private static final int DEFAULT_LINE_LENGTH = 80;
    private static Properties fXercesProperties = null;
    private static long fLastModified = -1L;

    ObjectFactory() {
    }

    static Object createObject(String factoryId, String fallbackClassName) throws ConfigurationError {
        return ObjectFactory.createObject(factoryId, null, fallbackClassName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object createObject(String factoryId, String propertiesFilename, String fallbackClassName) throws ConfigurationError {
        SecuritySupport ss = SecuritySupport.getInstance();
        ClassLoader cl = ObjectFactory.findClassLoader();
        try {
            String systemProp = ss.getSystemProperty(factoryId);
            if (systemProp != null) {
                return ObjectFactory.newInstance(systemProp, cl, true);
            }
        }
        catch (SecurityException systemProp) {
            // empty catch block
        }
        String factoryClassName = null;
        if (propertiesFilename == null) {
            File propertiesFile = null;
            boolean propertiesFileExists = false;
            try {
                String javah = ss.getSystemProperty("java.home");
                propertiesFilename = javah + File.separator + "lib" + File.separator + DEFAULT_PROPERTIES_FILENAME;
                propertiesFile = new File(propertiesFilename);
                propertiesFileExists = ss.getFileExists(propertiesFile);
            }
            catch (SecurityException e) {
                fLastModified = -1L;
                fXercesProperties = null;
            }
            Class<ObjectFactory> clazz = ObjectFactory.class;
            synchronized (ObjectFactory.class) {
                block48: {
                    boolean loadProperties = false;
                    try {
                        if (fLastModified >= 0L) {
                            if (propertiesFileExists && fLastModified < (fLastModified = ss.getLastModified(propertiesFile))) {
                                loadProperties = true;
                            } else if (!propertiesFileExists) {
                                fLastModified = -1L;
                                fXercesProperties = null;
                            }
                        } else if (propertiesFileExists) {
                            loadProperties = true;
                            fLastModified = ss.getLastModified(propertiesFile);
                        }
                        if (!loadProperties) break block48;
                        fXercesProperties = new Properties();
                        try (FileInputStream fis = ss.getFileInputStream(propertiesFile);){
                            fXercesProperties.load(fis);
                        }
                    }
                    catch (Exception x) {
                        fXercesProperties = null;
                        fLastModified = -1L;
                    }
                }
                // ** MonitorExit[var8_11] (shouldn't be in output)
                if (fXercesProperties != null) {
                    factoryClassName = fXercesProperties.getProperty(factoryId);
                }
            }
        } else {
            try {
                Properties props = new Properties();
                try (FileInputStream fis = ss.getFileInputStream(new File(propertiesFilename));){
                    props.load(fis);
                }
                factoryClassName = props.getProperty(factoryId);
            }
            catch (Exception props) {
                // empty catch block
            }
        }
        {
            if (factoryClassName != null) {
                return ObjectFactory.newInstance(factoryClassName, cl, true);
            }
            Object provider = ObjectFactory.findJarServiceProvider(factoryId);
            if (provider != null) {
                return provider;
            }
            if (fallbackClassName == null) {
                throw new ConfigurationError("Provider for " + factoryId + " cannot be found", null);
            }
            return ObjectFactory.newInstance(fallbackClassName, cl, true);
        }
    }

    private static void debugPrintln(String msg) {
    }

    static ClassLoader findClassLoader() throws ConfigurationError {
        ClassLoader system;
        SecuritySupport ss = SecuritySupport.getInstance();
        ClassLoader context = ss.getContextClassLoader();
        ClassLoader chain = system = ss.getSystemClassLoader();
        while (true) {
            if (context == chain) {
                ClassLoader current = ObjectFactory.class.getClassLoader();
                chain = system;
                while (true) {
                    if (current == chain) {
                        return system;
                    }
                    if (chain == null) break;
                    chain = ss.getParentClassLoader(chain);
                }
                return current;
            }
            if (chain == null) break;
            chain = ss.getParentClassLoader(chain);
        }
        return context;
    }

    static Object newInstance(String className, ClassLoader cl, boolean doFallback) throws ConfigurationError {
        try {
            Class<?> providerClass = ObjectFactory.findProviderClass(className, cl, doFallback);
            Object instance = providerClass.newInstance();
            return instance;
        }
        catch (ClassNotFoundException x) {
            throw new ConfigurationError("Provider " + className + " not found", x);
        }
        catch (Exception x) {
            throw new ConfigurationError("Provider " + className + " could not be instantiated: " + x, x);
        }
    }

    static Class<?> findProviderClass(String className, ClassLoader cl, boolean doFallback) throws ClassNotFoundException, ConfigurationError {
        Class<?> providerClass;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            int lastDot = className.lastIndexOf(".");
            String packageName = className;
            if (lastDot != -1) {
                packageName = className.substring(0, lastDot);
            }
            security.checkPackageAccess(packageName);
        }
        if (cl == null) {
            providerClass = Class.forName(className);
        } else {
            try {
                providerClass = cl.loadClass(className);
            }
            catch (ClassNotFoundException x) {
                if (doFallback) {
                    ClassLoader current = ObjectFactory.class.getClassLoader();
                    if (current == null) {
                        providerClass = Class.forName(className);
                    }
                    if (cl != current) {
                        cl = current;
                        providerClass = cl.loadClass(className);
                    }
                    throw x;
                }
                throw x;
            }
        }
        return providerClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object findJarServiceProvider(String factoryId) throws ConfigurationError {
        block34: {
            ClassLoader current;
            SecuritySupport ss = SecuritySupport.getInstance();
            String serviceId = "META-INF/services/" + factoryId;
            ClassLoader cl = ObjectFactory.findClassLoader();
            InputStream is = ss.getResourceAsStream(cl, serviceId);
            if (is == null && cl != (current = ObjectFactory.class.getClassLoader())) {
                cl = current;
                is = ss.getResourceAsStream(cl, serviceId);
            }
            if (is == null) {
                current = null;
                return current;
            }
            String factoryClassName = null;
            try (BufferedReader rd = new BufferedReader(new InputStreamReader(is, "UTF-8"), 80);){
                factoryClassName = rd.readLine();
                rd.close();
            }
            catch (IOException x) {
                Object var7_11 = null;
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return var7_11;
            }
            if (factoryClassName == null || "".equals(factoryClassName)) break block34;
            Object object = ObjectFactory.newInstance(factoryClassName, cl, false);
            return object;
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    static class ConfigurationError
    extends Error {
        private Exception exception;

        ConfigurationError(String msg, Exception x) {
            super(msg);
            this.exception = x;
        }

        Exception getException() {
            return this.exception;
        }
    }
}

