/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.calculate;

import nl.basjes.parse.useragent.AgentField;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.calculate.FieldCalculator;
import nl.basjes.parse.useragent.utils.Normalize;

public class CalculateAgentName
implements FieldCalculator {
    @Override
    public void calculate(UserAgent.MutableUserAgent userAgent) {
        AgentField name = userAgent.get("AgentName");
        if (name.isDefaultValue()) {
            name = userAgent.get("DeviceBrand");
            if (name.isDefaultValue()) {
                userAgent.setForced("AgentName", "<<<null>>>", name.getConfidence());
            } else {
                userAgent.setForced("AgentName", name.getValue(), name.getConfidence());
            }
            return;
        }
        String value = name.getValue();
        if (Normalize.isLowerCase(value)) {
            long confidence = name.getConfidence();
            if (confidence < 0L) {
                confidence = 0L;
            }
            userAgent.setForced("AgentName", Normalize.brand(value), confidence);
        }
    }

    @Override
    public String[] getDependencies() {
        return new String[]{"DeviceBrand"};
    }

    public String toString() {
        return "Calculate AgentName";
    }
}

