/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.utils;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Normalize {
    private static final Pattern DEVICE_CLEANUP_PATTERN_1 = Pattern.compile("- +");
    private static final Pattern DEVICE_CLEANUP_PATTERN_2 = Pattern.compile(" +-");
    private static final Pattern DEVICE_CLEANUP_PATTERN_3 = Pattern.compile(" +");
    private static final Pattern DEVICE_CLEANUP_PATTERN_4 = Pattern.compile("( -| )+");

    private Normalize() {
    }

    private static boolean isTokenSeparator(char letter) {
        switch (letter) {
            case ' ': 
            case '-': 
            case '/': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    public static String brand(String brand) {
        if (brand == null) {
            return null;
        }
        if (brand.length() <= 3) {
            return brand.toUpperCase(Locale.ENGLISH);
        }
        StringBuilder sb = new StringBuilder(brand.length());
        char[] nameChars = brand.toCharArray();
        StringBuilder wordBuilder = new StringBuilder(brand.length());
        int lowerChars = 0;
        boolean wordHasNumbers = false;
        for (int i = 0; i < nameChars.length; ++i) {
            char thisChar = nameChars[i];
            if (Character.isDigit(thisChar)) {
                wordHasNumbers = true;
            }
            if (Normalize.isTokenSeparator(thisChar)) {
                if (wordBuilder.length() <= 3 || wordHasNumbers) {
                    sb.append(wordBuilder.toString().toUpperCase(Locale.ENGLISH));
                } else {
                    sb.append((CharSequence)wordBuilder);
                }
                wordBuilder.setLength(0);
                lowerChars = 0;
                wordHasNumbers = false;
                sb.append(thisChar);
                continue;
            }
            if (wordBuilder.length() == 0) {
                wordBuilder.append(Character.toUpperCase(thisChar));
            } else {
                boolean isUpperCase = Character.isUpperCase(thisChar);
                if (isUpperCase) {
                    if (lowerChars >= 3) {
                        wordBuilder.append(thisChar);
                    } else {
                        wordBuilder.append(Character.toLowerCase(thisChar));
                    }
                    lowerChars = 0;
                } else {
                    wordBuilder.append(Character.toLowerCase(thisChar));
                    ++lowerChars;
                }
            }
            if (i != nameChars.length - 1) continue;
            if (wordBuilder.length() <= 3 || wordHasNumbers) {
                sb.append(wordBuilder.toString().toUpperCase(Locale.ENGLISH));
            } else {
                sb.append((CharSequence)wordBuilder);
            }
            wordBuilder.setLength(0);
            lowerChars = 0;
            wordHasNumbers = false;
        }
        return sb.toString().trim();
    }

    public static String cleanupDeviceBrandName(String deviceBrand, String deviceName) {
        String result;
        deviceName = Normalize.replaceString(deviceName, "'", " ");
        deviceName = Normalize.replaceString(deviceName, "_", " ");
        deviceName = DEVICE_CLEANUP_PATTERN_1.matcher(deviceName).replaceAll("-");
        deviceName = DEVICE_CLEANUP_PATTERN_2.matcher(deviceName).replaceAll("-");
        deviceName = DEVICE_CLEANUP_PATTERN_3.matcher(deviceName).replaceAll(" ");
        String lowerDeviceName = deviceName.toLowerCase(Locale.ENGLISH);
        if (!deviceBrand.isEmpty()) {
            String lowerDeviceBrand = deviceBrand.toLowerCase(Locale.ENGLISH);
            if (lowerDeviceName.startsWith(lowerDeviceBrand)) {
                deviceName = Normalize.replaceString(deviceName, "_", " ");
                deviceName = deviceName.replaceAll("(?i)^" + Pattern.quote(deviceBrand) + "([^ ].*)$", Matcher.quoteReplacement(deviceBrand) + " $1");
                deviceName = DEVICE_CLEANUP_PATTERN_4.matcher(deviceName).replaceAll(" ");
            } else {
                deviceName = deviceBrand + ' ' + deviceName;
            }
        }
        if ((result = Normalize.brand(deviceName)).indexOf(73) != -1) {
            result = Normalize.replaceString(result, "Ipad", "iPad");
            result = Normalize.replaceString(result, "Ipod", "iPod");
            result = Normalize.replaceString(result, "Iphone", "iPhone");
            result = Normalize.replaceString(result, "IOS ", "iOS ");
        }
        return result;
    }

    public static String email(String email) {
        String cleaned = email;
        cleaned = Normalize.replaceString(cleaned, "[at]", "@");
        cleaned = Normalize.replaceString(cleaned, "[\\xc3\\xa07]", "@");
        cleaned = Normalize.replaceString(cleaned, "[dot]", ".");
        cleaned = Normalize.replaceString(cleaned, "\\", " ");
        cleaned = Normalize.replaceString(cleaned, " at ", "@");
        cleaned = Normalize.replaceString(cleaned, "dot", ".");
        cleaned = Normalize.replaceString(cleaned, " dash ", "-");
        cleaned = Normalize.replaceString(cleaned, " ", "");
        return cleaned;
    }

    public static String replaceString(String input, String searchFor, String replaceWith) {
        int startIdx = 0;
        int idxSearchFor = input.indexOf(searchFor, startIdx);
        if (idxSearchFor < 0) {
            return input;
        }
        StringBuilder result = new StringBuilder(input.length() + 32);
        while (idxSearchFor >= 0) {
            result.append(input, startIdx, idxSearchFor);
            result.append(replaceWith);
            startIdx = idxSearchFor + searchFor.length();
            idxSearchFor = input.indexOf(searchFor, startIdx);
        }
        result.append(input.substring(startIdx));
        return result.toString();
    }

    public static boolean isLowerCase(String text) {
        return text.codePoints().noneMatch(Character::isUpperCase);
    }
}

