/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.JobNotFoundException;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.activiti.engine.impl.persistence.entity.TimerJobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveTimerToExecutableJobCmd
implements Command<JobEntity>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(MoveTimerToExecutableJobCmd.class);
    protected String jobId;

    public MoveTimerToExecutableJobCmd(String jobId) {
        this.jobId = jobId;
    }

    @Override
    public JobEntity execute(CommandContext commandContext) {
        if (this.jobId == null) {
            throw new ActivitiIllegalArgumentException("jobId and job is null");
        }
        TimerJobEntity timerJob = (TimerJobEntity)commandContext.getTimerJobEntityManager().findById(this.jobId);
        if (timerJob == null) {
            throw new JobNotFoundException(this.jobId);
        }
        if (log.isDebugEnabled()) {
            log.debug("Executing timer job {}", (Object)timerJob.getId());
        }
        return commandContext.getJobManager().moveTimerJobToExecutableJob(timerJob);
    }

    public String getJobId() {
        return this.jobId;
    }
}

