/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.scheduler.quartz;

import com.google.common.base.Strings;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.dao.entity.Schedule;
import org.apache.dolphinscheduler.scheduler.api.SchedulerApi;
import org.apache.dolphinscheduler.scheduler.api.SchedulerException;
import org.apache.dolphinscheduler.scheduler.quartz.ProcessScheduleTask;
import org.apache.dolphinscheduler.scheduler.quartz.utils.QuartzTaskUtils;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class QuartzScheduler
implements SchedulerApi {
    private static final Logger logger = LoggerFactory.getLogger(QuartzScheduler.class);
    @Autowired
    private Scheduler scheduler;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public void start() throws SchedulerException {
        try {
            this.scheduler.start();
        }
        catch (Exception e) {
            throw new SchedulerException("Failed to start quartz scheduler ", (Throwable)e);
        }
    }

    public void insertOrUpdateScheduleTask(int projectId, Schedule schedule) throws SchedulerException {
        JobKey jobKey = QuartzTaskUtils.getJobKey(schedule.getId(), projectId);
        Map<String, Object> jobDataMap = QuartzTaskUtils.buildDataMap(projectId, schedule);
        String cronExpression = schedule.getCrontab();
        String timezoneId = schedule.getTimezoneId();
        Date startDate = DateUtils.transformTimezoneDate((Date)schedule.getStartTime(), (String)timezoneId);
        Date endDate = DateUtils.transformTimezoneDate((Date)schedule.getEndTime(), (String)timezoneId);
        this.lock.writeLock().lock();
        try {
            JobDetail jobDetail;
            if (this.scheduler.checkExists(jobKey)) {
                jobDetail = this.scheduler.getJobDetail(jobKey);
                jobDetail.getJobDataMap().putAll(jobDataMap);
            } else {
                jobDetail = JobBuilder.newJob(ProcessScheduleTask.class).withIdentity(jobKey).build();
                jobDetail.getJobDataMap().putAll(jobDataMap);
                this.scheduler.addJob(jobDetail, false, true);
                logger.info("Add job, job name: {}, group name: {}", (Object)jobKey.getName(), (Object)jobKey.getGroup());
            }
            TriggerKey triggerKey = new TriggerKey(jobKey.getName(), jobKey.getGroup());
            CronTrigger cronTrigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(triggerKey).startAt(startDate).endAt(endDate).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression).withMisfireHandlingInstructionDoNothing().inTimeZone(DateUtils.getTimezone((String)timezoneId))).forJob(jobDetail).build();
            if (this.scheduler.checkExists(triggerKey)) {
                CronTrigger oldCronTrigger = (CronTrigger)this.scheduler.getTrigger(triggerKey);
                String oldCronExpression = oldCronTrigger.getCronExpression();
                if (!Strings.nullToEmpty((String)cronExpression).equalsIgnoreCase(Strings.nullToEmpty((String)oldCronExpression))) {
                    this.scheduler.rescheduleJob(triggerKey, (Trigger)cronTrigger);
                    logger.info("reschedule job trigger, triggerName: {}, triggerGroupName: {}, cronExpression: {}, startDate: {}, endDate: {}", new Object[]{triggerKey.getName(), triggerKey.getGroup(), cronExpression, startDate, endDate});
                }
            } else {
                this.scheduler.scheduleJob((Trigger)cronTrigger);
                logger.info("schedule job trigger, triggerName: {}, triggerGroupName: {}, cronExpression: {}, startDate: {}, endDate: {}", new Object[]{triggerKey.getName(), triggerKey.getGroup(), cronExpression, startDate, endDate});
            }
        }
        catch (Exception e) {
            logger.error("Failed to add scheduler task, projectId: {}, scheduler: {}", new Object[]{projectId, schedule, e});
            throw new SchedulerException("Add schedule job failed", (Throwable)e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void deleteScheduleTask(int projectId, int scheduleId) throws SchedulerException {
        JobKey jobKey = QuartzTaskUtils.getJobKey(scheduleId, projectId);
        try {
            if (this.scheduler.checkExists(jobKey)) {
                logger.info("Try to delete scheduler task, projectId: {}, schedulerId: {}", (Object)projectId, (Object)scheduleId);
                this.scheduler.deleteJob(jobKey);
            }
        }
        catch (Exception e) {
            logger.error("Failed to delete scheduler task, projectId: {}, schedulerId: {}", new Object[]{projectId, scheduleId, e});
            throw new SchedulerException("Failed to delete scheduler task");
        }
    }

    public void close() {
        try {
            this.scheduler.shutdown();
        }
        catch (org.quartz.SchedulerException e) {
            throw new SchedulerException("Failed to shutdown scheduler", (Throwable)e);
        }
    }
}

