/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api;

import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.dolphinscheduler.plugin.task.api.TaskCallBack;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.model.TaskAlertInfo;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public abstract class AbstractTask {
    public static final Marker FINALIZE_SESSION_MARKER = MarkerFactory.getMarker((String)"FINALIZE_SESSION");
    protected final Logger logger = LoggerFactory.getLogger((String)String.format("TaskLogLogger-%s", this.getClass()));
    public String rgex = "['\"]*\\$\\{(.*?)\\}['\"]*";
    protected String varPool;
    protected TaskExecutionContext taskRequest;
    protected int processId;
    protected String resultString;
    protected String appIds;
    protected volatile int exitStatusCode = -1;
    protected boolean needAlert = false;
    protected TaskAlertInfo taskAlertInfo;

    protected AbstractTask(TaskExecutionContext taskExecutionContext) {
        this.taskRequest = taskExecutionContext;
    }

    public void init() {
    }

    public String getPreScript() {
        return null;
    }

    public abstract void handle(TaskCallBack var1) throws TaskException;

    public abstract void cancel() throws TaskException;

    public void setVarPool(String varPool) {
        this.varPool = varPool;
    }

    public String getVarPool() {
        return this.varPool;
    }

    public int getExitStatusCode() {
        return this.exitStatusCode;
    }

    public void setExitStatusCode(int exitStatusCode) {
        this.exitStatusCode = exitStatusCode;
    }

    public int getProcessId() {
        return this.processId;
    }

    public void setProcessId(int processId) {
        this.processId = processId;
    }

    public String getResultString() {
        return this.resultString;
    }

    public void setResultString(String resultString) {
        this.resultString = resultString;
    }

    public String getAppIds() {
        return this.appIds;
    }

    public void setAppIds(String appIds) {
        this.appIds = appIds;
    }

    public boolean getNeedAlert() {
        return this.needAlert;
    }

    public void setNeedAlert(boolean needAlert) {
        this.needAlert = needAlert;
    }

    public TaskAlertInfo getTaskAlertInfo() {
        return this.taskAlertInfo;
    }

    public void setTaskAlertInfo(TaskAlertInfo taskAlertInfo) {
        this.taskAlertInfo = taskAlertInfo;
    }

    public abstract AbstractParameters getParameters();

    public TaskExecutionStatus getExitStatus() {
        TaskExecutionStatus status;
        switch (this.getExitStatusCode()) {
            case 0: {
                status = TaskExecutionStatus.SUCCESS;
                break;
            }
            case 137: {
                status = TaskExecutionStatus.KILL;
                break;
            }
            default: {
                status = TaskExecutionStatus.FAILURE;
            }
        }
        return status;
    }

    public void logHandle(LinkedBlockingQueue<String> logs) {
        if (logs.contains(FINALIZE_SESSION_MARKER.toString())) {
            this.logger.info(FINALIZE_SESSION_MARKER, FINALIZE_SESSION_MARKER.toString());
        } else {
            StringJoiner joiner = new StringJoiner("\n\t");
            while (!logs.isEmpty()) {
                joiner.add(logs.poll());
            }
            this.logger.info(" -> {}", (Object)joiner);
        }
    }

    public void setSqlParamsMap(String content, String rgex, Map<Integer, Property> sqlParamsMap, Map<String, Property> paramsPropsMap, int taskInstanceId) {
        if (paramsPropsMap == null) {
            return;
        }
        Pattern pattern = Pattern.compile(rgex);
        Matcher m = pattern.matcher(content);
        int index = 1;
        while (m.find()) {
            String paramName = m.group(1);
            Property prop = paramsPropsMap.get(paramName);
            if (prop == null) {
                this.logger.error("setSqlParamsMap: No Property with paramName: {} is found in paramsPropsMap of task instance with id: {}. So couldn't put Property in sqlParamsMap.", (Object)paramName, (Object)taskInstanceId);
                continue;
            }
            sqlParamsMap.put(index, prop);
            ++index;
            this.logger.info("setSqlParamsMap: Property with paramName: {} put in sqlParamsMap of content {} successfully.", (Object)paramName, (Object)content);
        }
    }
}

