/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import java.util.HashMap;
import java.util.Map;

public enum TaskExecutionStatus {
    SUBMITTED_SUCCESS(0, "submit success"),
    RUNNING_EXECUTION(1, "running"),
    PAUSE(3, "pause"),
    FAILURE(6, "failure"),
    SUCCESS(7, "success"),
    NEED_FAULT_TOLERANCE(8, "need fault tolerance"),
    KILL(9, "kill"),
    DELAY_EXECUTION(12, "delay execution"),
    FORCED_SUCCESS(13, "forced success"),
    DISPATCH(17, "dispatch");

    private static final Map<Integer, TaskExecutionStatus> CODE_MAP;
    private static final int[] NEED_FAILOVER_STATES;
    @EnumValue
    private final int code;
    private final String desc;

    public static TaskExecutionStatus of(int code) {
        TaskExecutionStatus taskExecutionStatus = CODE_MAP.get(code);
        if (taskExecutionStatus == null) {
            throw new IllegalArgumentException(String.format("The task execution status code: %s is invalidated", code));
        }
        return taskExecutionStatus;
    }

    public boolean isRunning() {
        return this == RUNNING_EXECUTION;
    }

    public boolean isSuccess() {
        return this == SUCCESS;
    }

    public boolean isForceSuccess() {
        return this == FORCED_SUCCESS;
    }

    public boolean isKill() {
        return this == KILL;
    }

    public boolean isFailure() {
        return this == FAILURE || this == NEED_FAULT_TOLERANCE;
    }

    public boolean isPause() {
        return this == PAUSE;
    }

    public boolean isFinished() {
        return this.isSuccess() || this.isKill() || this.isFailure() || this.isPause();
    }

    public boolean isNeedFaultTolerance() {
        return this == NEED_FAULT_TOLERANCE;
    }

    public static int[] getNeedFailoverWorkflowInstanceState() {
        return NEED_FAILOVER_STATES;
    }

    public boolean shouldFailover() {
        return SUBMITTED_SUCCESS == this || DISPATCH == this || RUNNING_EXECUTION == this || DELAY_EXECUTION == this;
    }

    private TaskExecutionStatus(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public String toString() {
        return "TaskExecutionStatus{code=" + this.code + ", desc='" + this.desc + '\'' + '}';
    }

    static {
        CODE_MAP = new HashMap<Integer, TaskExecutionStatus>();
        NEED_FAILOVER_STATES = new int[]{SUBMITTED_SUCCESS.getCode(), DISPATCH.getCode(), RUNNING_EXECUTION.getCode(), DELAY_EXECUTION.getCode()};
        for (TaskExecutionStatus executionStatus : TaskExecutionStatus.values()) {
            CODE_MAP.put(executionStatus.getCode(), executionStatus);
        }
    }
}

