/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.enums.dp;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum ValueType {
    STRING(0, "string"),
    LIST(1, "list"),
    NUMBER(2, "number"),
    LIKE_SQL(3, "sql");

    private final int code;
    private final String description;
    private static final Map<Integer, ValueType> VALUES_MAP;

    private ValueType(int code, String description) {
        this.code = code;
        this.description = description;
    }

    @JsonValue
    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public static ValueType of(Integer status) {
        if (VALUES_MAP.containsKey(status)) {
            return VALUES_MAP.get(status);
        }
        throw new IllegalArgumentException("invalid code : " + status);
    }

    static {
        VALUES_MAP = new HashMap<Integer, ValueType>();
        for (ValueType type : ValueType.values()) {
            VALUES_MAP.put(type.code, type);
        }
    }
}

