/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.utils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);
    private static final FileAttribute<Set<PosixFilePermission>> PERMISSION_755 = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwxr-xr-x"));

    public static void createFileWith755(@NonNull Path path) throws IOException {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            Files.createFile(path, new FileAttribute[0]);
        } else {
            Files.createFile(path, PERMISSION_755);
        }
    }
}

