/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.seatunnel;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.plugin.task.api.model.ResourceInfo;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.seatunnel.EngineEnum;
import org.apache.dolphinscheduler.plugin.task.seatunnel.flink.SeatunnelFlinkParameters;
import org.apache.dolphinscheduler.plugin.task.seatunnel.spark.SeatunnelSparkParameters;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, visible=true, property="engine")
@JsonSubTypes(value={@JsonSubTypes.Type(value=SeatunnelFlinkParameters.class, name="FLINK"), @JsonSubTypes.Type(value=SeatunnelSparkParameters.class, name="SPARK")})
public class SeatunnelParameters
extends AbstractParameters {
    private EngineEnum engine;
    private Boolean useCustom;
    private String rawScript;
    private List<ResourceInfo> resourceList;

    public EngineEnum getEngine() {
        return this.engine;
    }

    public void setEngine(EngineEnum engine) {
        this.engine = engine;
    }

    public Boolean getUseCustom() {
        return this.useCustom;
    }

    public void setUseCustom(Boolean useCustom) {
        this.useCustom = useCustom;
    }

    public String getRawScript() {
        return this.rawScript;
    }

    public void setRawScript(String rawScript) {
        this.rawScript = rawScript;
    }

    public List<ResourceInfo> getResourceList() {
        return this.resourceList;
    }

    public void setResourceList(List<ResourceInfo> resourceList) {
        this.resourceList = resourceList;
    }

    public boolean checkParameters() {
        return Objects.nonNull((Object)this.engine) && (BooleanUtils.isTrue((Boolean)this.useCustom) && StringUtils.isNotBlank((CharSequence)this.rawScript) || BooleanUtils.isFalse((Boolean)this.useCustom) && CollectionUtils.isNotEmpty(this.resourceList) && this.resourceList.size() == 1);
    }

    public List<ResourceInfo> getResourceFilesList() {
        return this.resourceList;
    }
}

