/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.seatunnel.spark;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.plugin.task.seatunnel.DeployModeEnum;
import org.apache.dolphinscheduler.plugin.task.seatunnel.SeatunnelParameters;

public class SeatunnelSparkParameters
extends SeatunnelParameters {
    private DeployModeEnum deployMode;
    private MasterTypeEnum master;
    private String masterUrl;

    @Override
    public boolean checkParameters() {
        boolean result;
        boolean bl = result = super.checkParameters() && Objects.nonNull((Object)this.deployMode);
        if (result && DeployModeEnum.local != this.deployMode && (result = Objects.nonNull((Object)this.master)) && (MasterTypeEnum.SPARK == this.master || MasterTypeEnum.MESOS == this.master)) {
            result = StringUtils.isNotBlank((CharSequence)this.masterUrl);
        }
        return result;
    }

    public DeployModeEnum getDeployMode() {
        return this.deployMode;
    }

    public void setDeployMode(DeployModeEnum deployMode) {
        this.deployMode = deployMode;
    }

    public MasterTypeEnum getMaster() {
        return this.master;
    }

    public void setMaster(MasterTypeEnum master) {
        this.master = master;
    }

    public String getMasterUrl() {
        return this.masterUrl;
    }

    public void setMasterUrl(String masterUrl) {
        this.masterUrl = masterUrl;
    }

    public static enum MasterTypeEnum {
        YARN("yarn"),
        LOCAL("local"),
        SPARK("spark://"),
        MESOS("mesos://");

        private String command;

        private MasterTypeEnum(String command) {
            this.command = command;
        }

        public String getCommand() {
            return this.command;
        }
    }
}

