/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.shell;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import org.apache.commons.lang3.SystemUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractTask;
import org.apache.dolphinscheduler.plugin.task.api.ShellCommandExecutor;
import org.apache.dolphinscheduler.plugin.task.api.TaskCallBack;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.model.TaskResponse;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.parser.ParamUtils;
import org.apache.dolphinscheduler.plugin.task.api.parser.ParameterUtils;
import org.apache.dolphinscheduler.plugin.task.api.utils.FileUtils;
import org.apache.dolphinscheduler.plugin.task.shell.ShellParameters;

public class ShellTask
extends AbstractTask {
    private ShellParameters shellParameters;
    private ShellCommandExecutor shellCommandExecutor;
    private TaskExecutionContext taskExecutionContext;

    public ShellTask(TaskExecutionContext taskExecutionContext) {
        super(taskExecutionContext);
        this.taskExecutionContext = taskExecutionContext;
        this.shellCommandExecutor = new ShellCommandExecutor(arg_0 -> ((ShellTask)this).logHandle(arg_0), taskExecutionContext, this.logger);
    }

    public void init() {
        this.logger.info("shell task params {}", (Object)this.taskExecutionContext.getTaskParams());
        this.shellParameters = (ShellParameters)((Object)JSONUtils.parseObject((String)this.taskExecutionContext.getTaskParams(), ShellParameters.class));
        if (!this.shellParameters.checkParameters()) {
            throw new RuntimeException("shell task params is not valid");
        }
    }

    public void handle(TaskCallBack taskCallBack) throws TaskException {
        try {
            String command = this.buildCommand();
            TaskResponse commandExecuteResult = this.shellCommandExecutor.run(command);
            this.setExitStatusCode(commandExecuteResult.getExitStatusCode());
            this.setProcessId(commandExecuteResult.getProcessId());
            this.shellParameters.dealOutParam(this.shellCommandExecutor.getVarPool());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.error("The current Shell task has been interrupted", (Throwable)e);
            this.setExitStatusCode(-1);
            throw new TaskException("The current Shell task has been interrupted", (Throwable)e);
        }
        catch (Exception e) {
            this.logger.error("shell task error", (Throwable)e);
            this.setExitStatusCode(-1);
            throw new TaskException("Execute shell task error", (Throwable)e);
        }
    }

    public void cancel() throws TaskException {
        try {
            this.shellCommandExecutor.cancelApplication();
        }
        catch (Exception e) {
            throw new TaskException("cancel application error", (Throwable)e);
        }
    }

    private String buildCommand() throws Exception {
        String fileName = String.format("%s/%s_node.%s", this.taskExecutionContext.getExecutePath(), this.taskExecutionContext.getTaskAppId(), SystemUtils.IS_OS_WINDOWS ? "bat" : "sh");
        File file = new File(fileName);
        Path path = file.toPath();
        if (Files.exists(path, new LinkOption[0])) {
            this.logger.warn("The command file: {} is already exist", (Object)path);
            return fileName;
        }
        String script = this.shellParameters.getRawScript().replaceAll("\\r\\n", "\n");
        script = this.parseScript(script);
        this.shellParameters.setRawScript(script);
        this.logger.info("raw script : {}", (Object)this.shellParameters.getRawScript());
        this.logger.info("task execute path : {}", (Object)this.taskExecutionContext.getExecutePath());
        FileUtils.createFileWith755((Path)path);
        Files.write(path, this.shellParameters.getRawScript().getBytes(), StandardOpenOption.APPEND);
        return fileName;
    }

    public AbstractParameters getParameters() {
        return this.shellParameters;
    }

    private String parseScript(String script) {
        Map paramsMap = this.taskExecutionContext.getPrepareParamsMap();
        return ParameterUtils.convertParameterPlaceholders((String)script, (Map)ParamUtils.convert((Map)paramsMap));
    }
}

