/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestDatanodeConfig {
    private static final File BASE_DIR = new File(MiniDFSCluster.getBaseDirectory());
    private static MiniDFSCluster cluster;

    @BeforeClass
    public static void setUp() throws Exception {
        TestDatanodeConfig.clearBaseDir();
        HdfsConfiguration conf = new HdfsConfiguration();
        cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
        cluster.waitActive();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
        TestDatanodeConfig.clearBaseDir();
    }

    private static void clearBaseDir() throws IOException {
        if (BASE_DIR.exists() && !FileUtil.fullyDelete((File)BASE_DIR)) {
            throw new IOException("Cannot clear BASE_DIR " + BASE_DIR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDataDirectories() throws IOException {
        File dataDir = new File(BASE_DIR, "data").getCanonicalFile();
        Configuration conf = cluster.getConfiguration(0);
        String dnDir = TestDatanodeConfig.makeURI("shv", null, Util.fileAsURI((File)dataDir).getPath());
        conf.set("dfs.datanode.data.dir", dnDir);
        DataNode dn = null;
        try {
            dn = DataNode.createDataNode((String[])new String[0], (Configuration)conf);
            Assert.fail();
        }
        catch (Exception e) {
        }
        finally {
            if (dn != null) {
                dn.shutdown();
            }
        }
        Assert.assertNull((String)"Data-node startup should have failed.", (Object)dn);
        String dnDir1 = Util.fileAsURI((File)dataDir).toString() + "1";
        String dnDir2 = TestDatanodeConfig.makeURI("file", "localhost", Util.fileAsURI((File)dataDir).getPath() + "2");
        String dnDir3 = dataDir.getAbsolutePath() + "3";
        conf.set("dfs.datanode.data.dir", dnDir1 + "," + dnDir2 + "," + dnDir3);
        cluster.startDataNodes(conf, 1, false, HdfsServerConstants.StartupOption.REGULAR, null);
        Assert.assertTrue((String)"Data-node should startup.", (boolean)cluster.isDataNodeUp());
    }

    private static String makeURI(String scheme, String host, String path) throws IOException {
        try {
            URI uDir = new URI(scheme, host, path, null);
            return uDir.toString();
        }
        catch (URISyntaxException e) {
            throw new IOException("Bad URI", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testMemlockLimit() throws Exception {
        Assume.assumeTrue((boolean)NativeIO.isAvailable());
        long memlockLimit = NativeIO.POSIX.getCacheManipulator().getMemlockLimit();
        Assume.assumeTrue((memlockLimit != Long.MAX_VALUE ? 1 : 0) != 0);
        File dataDir = new File(BASE_DIR, "data").getCanonicalFile();
        Configuration conf = cluster.getConfiguration(0);
        conf.set("dfs.datanode.data.dir", TestDatanodeConfig.makeURI("file", null, Util.fileAsURI((File)dataDir).getPath()));
        long prevLimit = conf.getLong("dfs.datanode.max.locked.memory", 0L);
        DataNode dn = null;
        try {
            conf.setLong("dfs.datanode.max.locked.memory", memlockLimit);
            dn = DataNode.createDataNode((String[])new String[0], (Configuration)conf);
            dn.shutdown();
            dn = null;
            conf.setLong("dfs.datanode.max.locked.memory", memlockLimit + 1L);
            try {
                dn = DataNode.createDataNode((String[])new String[0], (Configuration)conf);
            }
            catch (RuntimeException e) {
                GenericTestUtils.assertExceptionContains((String)"more than the datanode's available RLIMIT_MEMLOCK", (Throwable)e);
            }
        }
        finally {
            if (dn != null) {
                dn.shutdown();
            }
            conf.setLong("dfs.datanode.max.locked.memory", prevLimit);
        }
    }
}

