/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.balancer;

import java.net.URI;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.server.balancer.Balancer;
import org.apache.hadoop.hdfs.server.balancer.TestBalancer;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestBalancerWithHANameNodes {
    private MiniDFSCluster cluster;
    ClientProtocol client;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testBalancerWithHANameNodes() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestBalancer.initConf((Configuration)conf);
        long newNodeCapacity = 500L;
        String newNodeRack = "/rack2";
        String[] racks = new String[]{"/rack0", "/rack1"};
        long[] capacities = new long[]{500L, 500L};
        Assert.assertEquals((long)capacities.length, (long)racks.length);
        int numOfDatanodes = capacities.length;
        MiniDFSNNTopology.NNConf nn1Conf = new MiniDFSNNTopology.NNConf("nn1");
        nn1Conf.setIpcPort(8020);
        Configuration copiedConf = new Configuration((Configuration)conf);
        this.cluster = new MiniDFSCluster.Builder(copiedConf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(capacities.length).racks(racks).simulatedCapacities(capacities).build();
        HATestUtil.setFailoverConfigurations(this.cluster, (Configuration)conf);
        try {
            this.cluster.waitActive();
            this.cluster.transitionToActive(1);
            Thread.sleep(500L);
            this.client = (ClientProtocol)NameNodeProxies.createProxy((Configuration)conf, (URI)FileSystem.getDefaultUri((Configuration)conf), ClientProtocol.class).getProxy();
            long totalCapacity = TestBalancer.sum(capacities);
            long totalUsedSpace = totalCapacity * 3L / 10L;
            TestBalancer.createFile(this.cluster, TestBalancer.filePath, totalUsedSpace / (long)numOfDatanodes, (short)numOfDatanodes, 1);
            this.cluster.startDataNodes((Configuration)conf, 1, true, null, new String[]{newNodeRack}, new long[]{newNodeCapacity});
            TestBalancer.waitForHeartBeat(totalUsedSpace, totalCapacity += newNodeCapacity, this.client, this.cluster);
            Collection namenodes = DFSUtil.getNsServiceRpcUris((Configuration)conf);
            Assert.assertEquals((long)1L, (long)namenodes.size());
            Assert.assertTrue((boolean)namenodes.contains(HATestUtil.getLogicalUri(this.cluster)));
            int r = Balancer.run((Collection)namenodes, (Balancer.Parameters)Balancer.Parameters.DEFALUT, (Configuration)conf);
            Assert.assertEquals((long)Balancer.ReturnStatus.SUCCESS.code, (long)r);
            TestBalancer.waitForBalancer(totalUsedSpace, totalCapacity, this.client, this.cluster);
        }
        finally {
            this.cluster.shutdown();
        }
    }

    static {
        Balancer.setBlockMoveWaitTime((long)1000L);
    }
}

