/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StorageType;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestStorageReport {
    public static final Log LOG = LogFactory.getLog(TestStorageReport.class);
    private static final short REPL_FACTOR = 1;
    private static final StorageType storageType = StorageType.SSD;
    private static Configuration conf;
    private MiniDFSCluster cluster;
    private DistributedFileSystem fs;
    static String bpid;

    @Before
    public void startUpCluster() throws IOException {
        conf = new HdfsConfiguration();
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).storageType(storageType).build();
        this.fs = this.cluster.getFileSystem();
        bpid = this.cluster.getNamesystem().getBlockPoolId();
    }

    @After
    public void shutDownCluster() throws IOException {
        if (this.cluster != null) {
            this.fs.close();
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testStorageReportHasStorageTypeAndState() throws IOException {
        StorageReport[] reports;
        Assert.assertNotSame((Object)storageType, (Object)StorageType.DEFAULT);
        NameNode nn = this.cluster.getNameNode();
        DataNode dn = this.cluster.getDataNodes().get(0);
        DatanodeProtocolClientSideTranslatorPB nnSpy = DataNodeTestUtils.spyOnBposToNN(dn, nn);
        DataNodeTestUtils.triggerHeartbeat(dn);
        ArgumentCaptor captor = ArgumentCaptor.forClass(StorageReport[].class);
        ((DatanodeProtocolClientSideTranslatorPB)Mockito.verify((Object)nnSpy)).sendHeartbeat((DatanodeRegistration)Matchers.any(DatanodeRegistration.class), (StorageReport[])captor.capture(), Matchers.anyLong(), Matchers.anyLong(), Matchers.anyInt(), Matchers.anyInt(), Matchers.anyInt());
        for (StorageReport report : reports = (StorageReport[])captor.getValue()) {
            Assert.assertThat((Object)report.getStorage().getStorageType(), (Matcher)Is.is((Object)storageType));
            Assert.assertThat((Object)report.getStorage().getState(), (Matcher)Is.is((Object)DatanodeStorage.State.NORMAL));
        }
    }
}

