/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.util.LightWeightHashSet;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestLightWeightHashSet {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.hdfs.TestLightWeightHashSet");
    private final ArrayList<Integer> list = new ArrayList();
    private final int NUM = 100;
    private LightWeightHashSet<Integer> set;
    private Random rand;

    @Before
    public void setUp() {
        float maxF = 0.75f;
        float minF = 0.2f;
        int initCapacity = 16;
        this.rand = new Random(Time.now());
        this.list.clear();
        for (int i = 0; i < 100; ++i) {
            this.list.add(this.rand.nextInt());
        }
        this.set = new LightWeightHashSet(initCapacity, maxF, minF);
    }

    @Test
    public void testEmptyBasic() {
        LOG.info((Object)"Test empty basic");
        Iterator iter = this.set.iterator();
        Assert.assertFalse((boolean)iter.hasNext());
        Assert.assertEquals((long)0L, (long)this.set.size());
        Assert.assertTrue((boolean)this.set.isEmpty());
        LOG.info((Object)"Test empty - DONE");
    }

    @Test
    public void testOneElementBasic() {
        LOG.info((Object)"Test one element basic");
        this.set.add((Object)this.list.get(0));
        Assert.assertEquals((long)1L, (long)this.set.size());
        Assert.assertFalse((boolean)this.set.isEmpty());
        Iterator iter = this.set.iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals((Object)this.list.get(0), iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
        LOG.info((Object)"Test one element basic - DONE");
    }

    @Test
    public void testMultiBasic() {
        LOG.info((Object)"Test multi element basic");
        for (Integer i : this.list) {
            Assert.assertTrue((boolean)this.set.add((Object)i));
        }
        Assert.assertEquals((long)this.list.size(), (long)this.set.size());
        for (Integer i : this.list) {
            Assert.assertTrue((boolean)this.set.contains((Object)i));
        }
        for (Integer i : this.list) {
            Assert.assertFalse((boolean)this.set.add((Object)i));
        }
        for (Integer i : this.list) {
            Assert.assertTrue((boolean)this.set.contains((Object)i));
        }
        Iterator iter = this.set.iterator();
        int num = 0;
        while (iter.hasNext()) {
            Integer next = (Integer)iter.next();
            Assert.assertNotNull((Object)next);
            Assert.assertTrue((boolean)this.list.contains(next));
            ++num;
        }
        Assert.assertEquals((long)this.list.size(), (long)num);
        LOG.info((Object)"Test multi element basic - DONE");
    }

    @Test
    public void testRemoveOne() {
        LOG.info((Object)"Test remove one");
        Assert.assertTrue((boolean)this.set.add((Object)this.list.get(0)));
        Assert.assertEquals((long)1L, (long)this.set.size());
        Assert.assertTrue((boolean)this.set.remove((Object)this.list.get(0)));
        Assert.assertEquals((long)0L, (long)this.set.size());
        Iterator iter = this.set.iterator();
        Assert.assertFalse((boolean)iter.hasNext());
        Assert.assertTrue((boolean)this.set.add((Object)this.list.get(0)));
        Assert.assertEquals((long)1L, (long)this.set.size());
        iter = this.set.iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        LOG.info((Object)"Test remove one - DONE");
    }

    @Test
    public void testRemoveMulti() {
        int i;
        LOG.info((Object)"Test remove multi");
        for (Integer i2 : this.list) {
            Assert.assertTrue((boolean)this.set.add((Object)i2));
        }
        for (i = 0; i < 50; ++i) {
            Assert.assertTrue((boolean)this.set.remove((Object)this.list.get(i)));
        }
        for (i = 0; i < 50; ++i) {
            Assert.assertFalse((boolean)this.set.contains((Object)this.list.get(i)));
        }
        for (i = 50; i < 100; ++i) {
            Assert.assertTrue((boolean)this.set.contains((Object)this.list.get(i)));
        }
        LOG.info((Object)"Test remove multi - DONE");
    }

    @Test
    public void testRemoveAll() {
        int i;
        LOG.info((Object)"Test remove all");
        for (Integer i2 : this.list) {
            Assert.assertTrue((boolean)this.set.add((Object)i2));
        }
        for (i = 0; i < 100; ++i) {
            Assert.assertTrue((boolean)this.set.remove((Object)this.list.get(i)));
        }
        for (i = 0; i < 100; ++i) {
            Assert.assertFalse((boolean)this.set.contains((Object)this.list.get(i)));
        }
        Iterator iter = this.set.iterator();
        Assert.assertFalse((boolean)iter.hasNext());
        Assert.assertTrue((boolean)this.set.isEmpty());
        LOG.info((Object)"Test remove all - DONE");
    }

    @Test
    public void testPollAll() {
        LOG.info((Object)"Test poll all");
        for (Integer i : this.list) {
            Assert.assertTrue((boolean)this.set.add((Object)i));
        }
        List poll = this.set.pollAll();
        Assert.assertEquals((long)0L, (long)this.set.size());
        Assert.assertTrue((boolean)this.set.isEmpty());
        for (int i = 0; i < 100; ++i) {
            Assert.assertFalse((boolean)this.set.contains((Object)this.list.get(i)));
        }
        for (Integer i : poll) {
            Assert.assertTrue((boolean)this.list.contains(i));
        }
        Iterator iter = this.set.iterator();
        Assert.assertFalse((boolean)iter.hasNext());
        LOG.info((Object)"Test poll all - DONE");
    }

    @Test
    public void testPollNMulti() {
        LOG.info((Object)"Test pollN multi");
        this.set.addAll(this.list);
        List poll = this.set.pollN(0);
        Assert.assertEquals((long)0L, (long)poll.size());
        for (Integer i : this.list) {
            Assert.assertTrue((boolean)this.set.contains((Object)i));
        }
        poll = this.set.pollN(10);
        Assert.assertEquals((long)10L, (long)poll.size());
        for (Integer i : poll) {
            Assert.assertTrue((boolean)this.list.contains(i));
            Assert.assertFalse((boolean)this.set.contains((Object)i));
        }
        poll = this.set.pollN(1000);
        Assert.assertEquals((long)90L, (long)poll.size());
        for (Integer i : poll) {
            Assert.assertTrue((boolean)this.list.contains(i));
        }
        Assert.assertTrue((boolean)this.set.isEmpty());
        Assert.assertEquals((long)0L, (long)this.set.size());
        LOG.info((Object)"Test pollN multi - DONE");
    }

    @Test
    public void testPollNMultiArray() {
        int i;
        LOG.info((Object)"Test pollN multi array");
        this.set.addAll(this.list);
        Object[] poll = new Integer[10];
        poll = (Integer[])this.set.pollToArray(poll);
        Assert.assertEquals((long)10L, (long)poll.length);
        for (Object i2 : poll) {
            Assert.assertTrue((boolean)this.list.contains(i2));
            Assert.assertFalse((boolean)this.set.contains(i2));
        }
        poll = new Integer[100];
        poll = (Integer[])this.set.pollToArray(poll);
        Assert.assertEquals((long)90L, (long)poll.length);
        for (i = 0; i < 90; ++i) {
            Assert.assertTrue((boolean)this.list.contains(poll[i]));
        }
        Assert.assertTrue((boolean)this.set.isEmpty());
        Assert.assertEquals((long)0L, (long)this.set.size());
        this.set.addAll(this.list);
        poll = new Integer[100];
        poll = (Integer[])this.set.pollToArray(poll);
        Assert.assertTrue((boolean)this.set.isEmpty());
        Assert.assertEquals((long)0L, (long)this.set.size());
        Assert.assertEquals((long)100L, (long)poll.length);
        for (i = 0; i < 100; ++i) {
            Assert.assertTrue((boolean)this.list.contains(poll[i]));
        }
        this.set.addAll(this.list);
        poll = new Integer[]{};
        poll = (Integer[])this.set.pollToArray(poll);
        for (i = 0; i < 100; ++i) {
            Assert.assertTrue((boolean)this.set.contains((Object)this.list.get(i)));
        }
        Assert.assertEquals((long)0L, (long)poll.length);
        LOG.info((Object)"Test pollN multi array- DONE");
    }

    @Test
    public void testClear() {
        LOG.info((Object)"Test clear");
        this.set.addAll(this.list);
        Assert.assertEquals((long)100L, (long)this.set.size());
        Assert.assertFalse((boolean)this.set.isEmpty());
        this.set.clear();
        Assert.assertEquals((long)0L, (long)this.set.size());
        Assert.assertTrue((boolean)this.set.isEmpty());
        Iterator iter = this.set.iterator();
        Assert.assertFalse((boolean)iter.hasNext());
        LOG.info((Object)"Test clear - DONE");
    }

    @Test
    public void testCapacity() {
        int expCap;
        LOG.info((Object)"Test capacity");
        float maxF = 0.75f;
        float minF = 0.2f;
        this.set = new LightWeightHashSet(1, maxF, minF);
        Assert.assertEquals((long)16L, (long)this.set.getCapacity());
        this.set = new LightWeightHashSet(30, maxF, minF);
        Assert.assertEquals((long)Math.max(16, 32), (long)this.set.getCapacity());
        this.set = new LightWeightHashSet(64, maxF, minF);
        Assert.assertEquals((long)Math.max(16, 64), (long)this.set.getCapacity());
        this.set.addAll(this.list);
        for (expCap = 16; expCap < 100 && maxF * (float)expCap < 100.0f; expCap <<= 1) {
        }
        Assert.assertEquals((long)expCap, (long)this.set.getCapacity());
        this.set.clear();
        this.set.addAll(this.list);
        int toRemove = this.set.size() - (int)((float)this.set.getCapacity() * minF) + 1;
        for (int i = 0; i < toRemove; ++i) {
            this.set.remove((Object)this.list.get(i));
        }
        Assert.assertEquals((long)Math.max(16, expCap / 2), (long)this.set.getCapacity());
        LOG.info((Object)"Test capacity - DONE");
    }

    @Test
    public void testOther() {
        LOG.info((Object)"Test other");
        Assert.assertTrue((boolean)this.set.addAll(this.list));
        Assert.assertTrue((boolean)this.set.removeAll(this.list));
        Assert.assertTrue((boolean)this.set.isEmpty());
        LinkedList<Integer> sub = new LinkedList<Integer>();
        for (int i = 0; i < 10; ++i) {
            sub.add(this.list.get(i));
        }
        Assert.assertTrue((boolean)this.set.addAll(this.list));
        Assert.assertTrue((boolean)this.set.removeAll(sub));
        Assert.assertFalse((boolean)this.set.isEmpty());
        Assert.assertEquals((long)90L, (long)this.set.size());
        for (Integer i : sub) {
            Assert.assertFalse((boolean)this.set.contains((Object)i));
        }
        Assert.assertFalse((boolean)this.set.containsAll(sub));
        LinkedList<Integer> sub2 = new LinkedList<Integer>();
        for (int i = 10; i < 100; ++i) {
            sub2.add(this.list.get(i));
        }
        Assert.assertTrue((boolean)this.set.containsAll(sub2));
        Integer[] array = (Integer[])this.set.toArray((Object[])new Integer[0]);
        Assert.assertEquals((long)90L, (long)array.length);
        for (int i = 0; i < array.length; ++i) {
            Assert.assertTrue((boolean)sub2.contains(array[i]));
        }
        Assert.assertEquals((long)90L, (long)this.set.size());
        Object[] array2 = this.set.toArray();
        Assert.assertEquals((long)90L, (long)array2.length);
        for (int i = 0; i < array2.length; ++i) {
            Assert.assertTrue((boolean)sub2.contains((Integer)array2[i]));
        }
        LOG.info((Object)"Test other - DONE");
    }

    @Test
    public void testGetElement() {
        LightWeightHashSet objSet = new LightWeightHashSet();
        TestObject objA = new TestObject("object A");
        TestObject equalToObjA = new TestObject("object A");
        TestObject objB = new TestObject("object B");
        objSet.add((Object)objA);
        objSet.add((Object)objB);
        Assert.assertSame((Object)objA, (Object)objSet.getElement((Object)objA));
        Assert.assertSame((Object)objA, (Object)objSet.getElement((Object)equalToObjA));
        Assert.assertSame((Object)objB, (Object)objSet.getElement((Object)objB));
        Assert.assertNull((Object)objSet.getElement((Object)new TestObject("not in set")));
    }

    private static class TestObject {
        private final String value;

        public TestObject(String value) {
            this.value = value;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TestObject other = (TestObject)obj;
            return this.value.equals(other.value);
        }
    }
}

