/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.resources.DeleteOpParam;
import org.apache.hadoop.hdfs.web.resources.GetOpParam;
import org.apache.hadoop.hdfs.web.resources.HttpOpParam;
import org.apache.hadoop.hdfs.web.resources.Param;
import org.apache.hadoop.hdfs.web.resources.PostOpParam;
import org.apache.hadoop.hdfs.web.resources.PutOpParam;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;
import org.mockito.verification.VerificationMode;

public class TestWebHdfsTokens {
    private static Configuration conf;

    @BeforeClass
    public static void setUp() {
        conf = new Configuration();
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)conf);
        UserGroupInformation.setConfiguration((Configuration)conf);
    }

    private WebHdfsFileSystem spyWebhdfsInSecureSetup() throws IOException {
        WebHdfsFileSystem fsOrig = new WebHdfsFileSystem();
        fsOrig.initialize(URI.create("webhdfs://127.0.0.1:0"), conf);
        WebHdfsFileSystem fs = (WebHdfsFileSystem)Mockito.spy((Object)fsOrig);
        Whitebox.setInternalState((Object)fsOrig.tokenAspect, (String)"fs", (Object)fs);
        return fs;
    }

    @Test(timeout=5000L)
    public void testTokenForNonTokenOp() throws IOException {
        WebHdfsFileSystem fs = this.spyWebhdfsInSecureSetup();
        Token token = (Token)Mockito.mock(Token.class);
        ((WebHdfsFileSystem)Mockito.doReturn((Object)token).when((Object)fs)).getDelegationToken(null);
        fs.toUrl((HttpOpParam.Op)GetOpParam.Op.OPEN, null, new Param[0]);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs)).getDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs)).getDelegationToken(null);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs)).setDelegationToken(token);
        Mockito.reset((Object[])new WebHdfsFileSystem[]{fs});
        fs.toUrl((HttpOpParam.Op)GetOpParam.Op.OPEN, null, new Param[0]);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs)).getDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken(null);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).setDelegationToken(token);
    }

    @Test(timeout=5000L)
    public void testNoTokenForGetToken() throws IOException {
        this.checkNoTokenForOperation((HttpOpParam.Op)GetOpParam.Op.GETDELEGATIONTOKEN);
    }

    @Test(timeout=5000L)
    public void testNoTokenForCanclToken() throws IOException {
        this.checkNoTokenForOperation((HttpOpParam.Op)PutOpParam.Op.RENEWDELEGATIONTOKEN);
    }

    @Test(timeout=5000L)
    public void testNoTokenForCancelToken() throws IOException {
        this.checkNoTokenForOperation((HttpOpParam.Op)PutOpParam.Op.CANCELDELEGATIONTOKEN);
    }

    private void checkNoTokenForOperation(HttpOpParam.Op op) throws IOException {
        WebHdfsFileSystem fs = this.spyWebhdfsInSecureSetup();
        ((WebHdfsFileSystem)Mockito.doReturn(null).when((Object)fs)).getDelegationToken(null);
        fs.initialize(URI.create("webhdfs://127.0.0.1:0"), conf);
        fs.toUrl(op, null, new Param[0]);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken(null);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).setDelegationToken((Token)Matchers.any(Token.class));
    }

    @Test(timeout=1000L)
    public void testGetOpRequireAuth() {
        for (GetOpParam.Op op : GetOpParam.Op.values()) {
            boolean expect = op == GetOpParam.Op.GETDELEGATIONTOKEN;
            Assert.assertEquals((Object)expect, (Object)op.getRequireAuth());
        }
    }

    @Test(timeout=1000L)
    public void testPutOpRequireAuth() {
        for (PutOpParam.Op op : PutOpParam.Op.values()) {
            boolean expect = op == PutOpParam.Op.RENEWDELEGATIONTOKEN || op == PutOpParam.Op.CANCELDELEGATIONTOKEN;
            Assert.assertEquals((Object)expect, (Object)op.getRequireAuth());
        }
    }

    @Test(timeout=1000L)
    public void testPostOpRequireAuth() {
        for (PostOpParam.Op op : PostOpParam.Op.values()) {
            Assert.assertFalse((boolean)op.getRequireAuth());
        }
    }

    @Test(timeout=1000L)
    public void testDeleteOpRequireAuth() {
        for (DeleteOpParam.Op op : DeleteOpParam.Op.values()) {
            Assert.assertFalse((boolean)op.getRequireAuth());
        }
    }
}

