/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Futures;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.HardLink;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LayoutVersion;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.InconsistentFSStateException;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.datanode.BlockPoolSliceStorage;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeLayoutVersion;
import org.apache.hadoop.hdfs.server.datanode.DatanodeUtil;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.DiskChecker;

@InterfaceAudience.Private
public class DataStorage
extends Storage {
    public static final String BLOCK_SUBDIR_PREFIX = "subdir";
    static final String COPY_FILE_PREFIX = "dncp_";
    static final String STORAGE_DIR_DETACHED = "detach";
    public static final String STORAGE_DIR_RBW = "rbw";
    public static final String STORAGE_DIR_FINALIZED = "finalized";
    public static final String STORAGE_DIR_LAZY_PERSIST = "lazypersist";
    public static final String STORAGE_DIR_TMP = "tmp";
    private Set<String> trashEnabledBpids;
    private volatile String datanodeUuid = null;
    private boolean initialized = false;
    private final Map<String, BlockPoolSliceStorage> bpStorageMap = Collections.synchronizedMap(new HashMap());

    DataStorage() {
        super(HdfsServerConstants.NodeType.DATA_NODE);
        this.trashEnabledBpids = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    public BlockPoolSliceStorage getBPStorage(String bpid) {
        return this.bpStorageMap.get(bpid);
    }

    public DataStorage(StorageInfo storageInfo) {
        super(storageInfo);
    }

    public String getDatanodeUuid() {
        return this.datanodeUuid;
    }

    public void setDatanodeUuid(String newDatanodeUuid) {
        this.datanodeUuid = newDatanodeUuid;
    }

    private static boolean createStorageID(Storage.StorageDirectory sd, int lv) {
        boolean haveValidStorageId = DataNodeLayoutVersion.supports(LayoutVersion.Feature.ADD_DATANODE_AND_STORAGE_UUIDS, lv) && DatanodeStorage.isValidStorageId(sd.getStorageUuid());
        return DataStorage.createStorageID(sd, !haveValidStorageId);
    }

    public static boolean createStorageID(Storage.StorageDirectory sd, boolean regenerateStorageIds) {
        String oldStorageID = sd.getStorageUuid();
        if (oldStorageID == null || regenerateStorageIds) {
            sd.setStorageUuid(DatanodeStorage.generateUuid());
            LOG.info((Object)("Generated new storageID " + sd.getStorageUuid() + " for directory " + sd.getRoot() + (oldStorageID == null ? "" : " to replace " + oldStorageID)));
            return true;
        }
        return false;
    }

    public void enableTrash(String bpid) {
        if (this.trashEnabledBpids.add(bpid)) {
            this.getBPStorage(bpid).stopTrashCleaner();
            LOG.info((Object)("Enabled trash for bpid " + bpid));
        }
    }

    public void clearTrash(String bpid) {
        if (this.trashEnabledBpids.contains(bpid)) {
            this.getBPStorage(bpid).clearTrash();
            this.trashEnabledBpids.remove(bpid);
            LOG.info((Object)("Cleared trash for bpid " + bpid));
        }
    }

    public boolean trashEnabled(String bpid) {
        return this.trashEnabledBpids.contains(bpid);
    }

    public void setRollingUpgradeMarker(String bpid) throws IOException {
        this.getBPStorage(bpid).setRollingUpgradeMarkers(this.storageDirs);
    }

    public void clearRollingUpgradeMarker(String bpid) throws IOException {
        this.getBPStorage(bpid).clearRollingUpgradeMarkers(this.storageDirs);
    }

    public String getTrashDirectoryForBlockFile(String bpid, File blockFile) {
        if (this.trashEnabledBpids.contains(bpid)) {
            return this.getBPStorage(bpid).getTrashDirectory(blockFile);
        }
        return null;
    }

    private Storage.StorageDirectory loadStorageDirectory(DataNode datanode, NamespaceInfo nsInfo, File dataDir, HdfsServerConstants.StartupOption startOpt, List<Callable<Storage.StorageDirectory>> callables) throws IOException {
        Storage.StorageDirectory sd = new Storage.StorageDirectory(dataDir, null, false);
        try {
            Storage.StorageState curState = sd.analyzeStorage(startOpt, this);
            switch (curState) {
                case NORMAL: {
                    break;
                }
                case NON_EXISTENT: {
                    LOG.info((Object)("Storage directory " + dataDir + " does not exist"));
                    throw new IOException("Storage directory " + dataDir + " does not exist");
                }
                case NOT_FORMATTED: {
                    LOG.info((Object)("Storage directory " + dataDir + " is not formatted for namespace " + nsInfo.getNamespaceID() + ". Formatting..."));
                    this.format(sd, nsInfo, datanode.getDatanodeUuid());
                    break;
                }
                default: {
                    sd.doRecover(curState);
                }
            }
            if (!this.doTransition(sd, nsInfo, startOpt, callables, datanode.getConf())) {
                this.setServiceLayoutVersion(this.getServiceLayoutVersion());
                this.writeProperties(sd);
            }
            return sd;
        }
        catch (IOException ioe) {
            sd.unlock();
            throw ioe;
        }
    }

    public VolumeBuilder prepareVolume(DataNode datanode, File volume, List<NamespaceInfo> nsInfos) throws IOException {
        if (this.containsStorageDir(volume)) {
            String errorMessage = "Storage directory is in use";
            LOG.warn((Object)"Storage directory is in use.");
            throw new IOException("Storage directory is in use");
        }
        Storage.StorageDirectory sd = this.loadStorageDirectory(datanode, nsInfos.get(0), volume, HdfsServerConstants.StartupOption.HOTSWAP, null);
        VolumeBuilder builder = new VolumeBuilder(this, sd);
        for (NamespaceInfo nsInfo : nsInfos) {
            ArrayList bpDataDirs = Lists.newArrayList();
            bpDataDirs.add(BlockPoolSliceStorage.getBpRoot(nsInfo.getBlockPoolID(), new File(volume, "current")));
            DataStorage.makeBlockPoolDataDir(bpDataDirs, null);
            BlockPoolSliceStorage bpStorage = this.getBlockPoolSliceStorage(nsInfo);
            List<Storage.StorageDirectory> dirs = bpStorage.loadBpStorageDirectories(nsInfo, bpDataDirs, HdfsServerConstants.StartupOption.HOTSWAP, null, datanode.getConf());
            builder.addBpStorageDirectories(nsInfo.getBlockPoolID(), dirs);
        }
        return builder;
    }

    static int getParallelVolumeLoadThreadsNum(int dataDirs, Configuration conf) {
        String key = "dfs.datanode.parallel.volumes.load.threads.num";
        int n = conf.getInt("dfs.datanode.parallel.volumes.load.threads.num", dataDirs);
        if (n < 1) {
            throw new HadoopIllegalArgumentException("dfs.datanode.parallel.volumes.load.threads.num = " + n + " < 1");
        }
        int min = Math.min(n, dataDirs);
        LOG.info((Object)("Using " + min + " threads to upgrade data directories (" + "dfs.datanode.parallel.volumes.load.threads.num" + "=" + n + ", dataDirs=" + dataDirs + ")"));
        return min;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    synchronized List<Storage.StorageDirectory> addStorageLocations(DataNode datanode, NamespaceInfo nsInfo, Collection<StorageLocation> dataDirs, HdfsServerConstants.StartupOption startOpt) throws IOException {
        int numThreads = DataStorage.getParallelVolumeLoadThreadsNum(dataDirs.size(), datanode.getConf());
        ExecutorService executor = Executors.newFixedThreadPool(numThreads);
        try {
            List<StorageLocation> successLocations = this.loadDataStorage(datanode, nsInfo, dataDirs, startOpt, executor);
            List<Storage.StorageDirectory> list = this.loadBlockPoolSliceStorage(datanode, nsInfo, successLocations, startOpt, executor);
            return list;
        }
        finally {
            executor.shutdown();
        }
    }

    private List<StorageLocation> loadDataStorage(DataNode datanode, NamespaceInfo nsInfo, Collection<StorageLocation> dataDirs, HdfsServerConstants.StartupOption startOpt, ExecutorService executor) throws IOException {
        ArrayList success = Lists.newArrayList();
        ArrayList tasks = Lists.newArrayList();
        for (StorageLocation dataDir : dataDirs) {
            File root = dataDir.getFile();
            if (!this.containsStorageDir(root)) {
                try {
                    ArrayList callables = Lists.newArrayList();
                    Storage.StorageDirectory sd = this.loadStorageDirectory(datanode, nsInfo, root, startOpt, callables);
                    if (callables.isEmpty()) {
                        this.addStorageDir(sd);
                        success.add(dataDir);
                        continue;
                    }
                    for (Callable c : callables) {
                        tasks.add(new UpgradeTask(dataDir, executor.submit(c)));
                    }
                    continue;
                }
                catch (IOException e) {
                    LOG.warn((Object)("Failed to add storage directory " + dataDir), (Throwable)e);
                    continue;
                }
            }
            LOG.info((Object)("Storage directory " + dataDir + " has already been used."));
            success.add(dataDir);
        }
        if (!tasks.isEmpty()) {
            LOG.info((Object)("loadDataStorage: " + tasks.size() + " upgrade tasks"));
            for (UpgradeTask t : tasks) {
                try {
                    this.addStorageDir((Storage.StorageDirectory)t.future.get());
                    success.add(t.dataDir);
                }
                catch (ExecutionException e) {
                    LOG.warn((Object)("Failed to upgrade storage directory " + t.dataDir), (Throwable)e);
                }
                catch (InterruptedException e) {
                    throw (InterruptedIOException)new InterruptedIOException("Task interrupted").initCause(e);
                }
            }
        }
        return success;
    }

    private List<Storage.StorageDirectory> loadBlockPoolSliceStorage(DataNode datanode, NamespaceInfo nsInfo, Collection<StorageLocation> dataDirs, HdfsServerConstants.StartupOption startOpt, ExecutorService executor) throws IOException {
        String bpid = nsInfo.getBlockPoolID();
        BlockPoolSliceStorage bpStorage = this.getBlockPoolSliceStorage(nsInfo);
        ArrayList success = Lists.newArrayList();
        ArrayList tasks = Lists.newArrayList();
        for (StorageLocation dataDir : dataDirs) {
            File curDir = new File(dataDir.getFile(), "current");
            ArrayList<File> bpDataDirs = new ArrayList<File>();
            bpDataDirs.add(BlockPoolSliceStorage.getBpRoot(bpid, curDir));
            try {
                DataStorage.makeBlockPoolDataDir(bpDataDirs, null);
                ArrayList callables = Lists.newArrayList();
                List<Storage.StorageDirectory> dirs = bpStorage.recoverTransitionRead(nsInfo, bpDataDirs, startOpt, callables, datanode.getConf());
                if (callables.isEmpty()) {
                    for (Storage.StorageDirectory sd : dirs) {
                        success.add(sd);
                    }
                    continue;
                }
                for (Callable c : callables) {
                    tasks.add(new UpgradeTask(dataDir, executor.submit(c)));
                }
            }
            catch (IOException e) {
                LOG.warn((Object)("Failed to add storage directory " + dataDir + " for block pool " + bpid), (Throwable)e);
            }
        }
        if (!tasks.isEmpty()) {
            LOG.info((Object)("loadBlockPoolSliceStorage: " + tasks.size() + " upgrade tasks"));
            for (UpgradeTask t : tasks) {
                try {
                    success.add(t.future.get());
                }
                catch (ExecutionException e) {
                    LOG.warn((Object)("Failed to upgrade storage directory " + t.dataDir + " for block pool " + bpid), (Throwable)e);
                }
                catch (InterruptedException e) {
                    throw (InterruptedIOException)new InterruptedIOException("Task interrupted").initCause(e);
                }
            }
        }
        return success;
    }

    synchronized void removeVolumes(Set<File> dirsToRemove) throws IOException {
        if (dirsToRemove.isEmpty()) {
            return;
        }
        StringBuilder errorMsgBuilder = new StringBuilder();
        Iterator it = this.storageDirs.iterator();
        while (it.hasNext()) {
            Storage.StorageDirectory sd = (Storage.StorageDirectory)it.next();
            if (!dirsToRemove.contains(sd.getRoot())) continue;
            for (Map.Entry<String, BlockPoolSliceStorage> entry : this.bpStorageMap.entrySet()) {
                String bpid = entry.getKey();
                BlockPoolSliceStorage bpsStorage = entry.getValue();
                File bpRoot = BlockPoolSliceStorage.getBpRoot(bpid, sd.getCurrentDir());
                bpsStorage.remove(bpRoot.getAbsoluteFile());
            }
            it.remove();
            try {
                sd.unlock();
            }
            catch (IOException e) {
                LOG.warn((Object)String.format("I/O error attempting to unlock storage directory %s.", sd.getRoot()), (Throwable)e);
                errorMsgBuilder.append(String.format("Failed to remove %s: %s%n", sd.getRoot(), e.getMessage()));
            }
        }
        if (errorMsgBuilder.length() > 0) {
            throw new IOException(errorMsgBuilder.toString());
        }
    }

    void recoverTransitionRead(DataNode datanode, NamespaceInfo nsInfo, Collection<StorageLocation> dataDirs, HdfsServerConstants.StartupOption startOpt) throws IOException {
        if (this.initialized) {
            LOG.info((Object)("DataNode version: " + HdfsConstants.DATANODE_LAYOUT_VERSION + " and NameNode layout version: " + nsInfo.getLayoutVersion()));
            this.storageDirs = new ArrayList(dataDirs.size());
            this.initialized = true;
        }
        if (this.addStorageLocations(datanode, nsInfo, dataDirs, startOpt).isEmpty()) {
            throw new IOException("All specified directories are failed to load.");
        }
    }

    static void makeBlockPoolDataDir(Collection<File> dataDirs, Configuration conf) throws IOException {
        if (conf == null) {
            conf = new HdfsConfiguration();
        }
        LocalFileSystem localFS = FileSystem.getLocal((Configuration)conf);
        FsPermission permission = new FsPermission(conf.get("dfs.datanode.data.dir.perm", "700"));
        for (File data : dataDirs) {
            try {
                DiskChecker.checkDir((LocalFileSystem)localFS, (Path)new Path(data.toURI()), (FsPermission)permission);
            }
            catch (IOException e) {
                LOG.warn((Object)("Invalid directory in: " + data.getCanonicalPath() + ": " + e.getMessage()));
            }
        }
    }

    void format(Storage.StorageDirectory sd, NamespaceInfo nsInfo, String datanodeUuid) throws IOException {
        sd.clearDirectory();
        this.layoutVersion = HdfsConstants.DATANODE_LAYOUT_VERSION;
        this.clusterID = nsInfo.getClusterID();
        this.namespaceID = nsInfo.getNamespaceID();
        this.cTime = 0L;
        this.setDatanodeUuid(datanodeUuid);
        DataStorage.createStorageID(sd, false);
        this.writeProperties(sd);
    }

    @Override
    protected void setPropertiesFromFields(Properties props, Storage.StorageDirectory sd) throws IOException {
        props.setProperty("storageType", this.storageType.toString());
        props.setProperty("clusterID", this.clusterID);
        props.setProperty("cTime", String.valueOf(this.cTime));
        props.setProperty("layoutVersion", String.valueOf(this.layoutVersion));
        props.setProperty("storageID", sd.getStorageUuid());
        String datanodeUuid = this.getDatanodeUuid();
        if (datanodeUuid != null) {
            props.setProperty("datanodeUuid", datanodeUuid);
        }
        if (!DataNodeLayoutVersion.supports(LayoutVersion.Feature.FEDERATION, this.layoutVersion)) {
            props.setProperty("namespaceID", String.valueOf(this.namespaceID));
        }
    }

    @Override
    protected void setFieldsFromProperties(Properties props, Storage.StorageDirectory sd) throws IOException {
        this.setFieldsFromProperties(props, sd, false, 0);
    }

    private void setFieldsFromProperties(Properties props, Storage.StorageDirectory sd, boolean overrideLayoutVersion, int toLayoutVersion) throws IOException {
        String ssid;
        if (overrideLayoutVersion) {
            this.layoutVersion = toLayoutVersion;
        } else {
            this.setLayoutVersion(props, sd);
        }
        this.setcTime(props, sd);
        this.checkStorageType(props, sd);
        this.setClusterId(props, this.layoutVersion, sd);
        if (!DataNodeLayoutVersion.supports(LayoutVersion.Feature.FEDERATION, this.layoutVersion)) {
            this.setNamespaceID(props, sd);
        }
        if ((ssid = props.getProperty("storageID")) == null) {
            throw new InconsistentFSStateException(sd.getRoot(), "file VERSION is invalid.");
        }
        String sid = sd.getStorageUuid();
        if (!(sid == null || sid.equals("") || ssid.equals("") || sid.equals(ssid))) {
            throw new InconsistentFSStateException(sd.getRoot(), "has incompatible storage Id.");
        }
        if (sid == null) {
            sd.setStorageUuid(ssid);
        }
        if (props.getProperty("datanodeUuid") != null) {
            String dnUuid = props.getProperty("datanodeUuid");
            if (this.getDatanodeUuid() == null) {
                this.setDatanodeUuid(dnUuid);
            } else if (this.getDatanodeUuid().compareTo(dnUuid) != 0) {
                throw new InconsistentFSStateException(sd.getRoot(), "Root " + sd.getRoot() + ": DatanodeUuid=" + dnUuid + ", does not match " + this.getDatanodeUuid() + " from other" + " StorageDirectory.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPreUpgradableLayout(Storage.StorageDirectory sd) throws IOException {
        File oldF = new File(sd.getRoot(), "storage");
        if (!oldF.exists()) {
            return false;
        }
        RandomAccessFile oldFile = new RandomAccessFile(oldF, "rws");
        FileLock oldLock = oldFile.getChannel().tryLock();
        try {
            oldFile.seek(0L);
            int oldVersion = oldFile.readInt();
            if (oldVersion < -3) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            oldLock.release();
            oldFile.close();
        }
        return true;
    }

    void readProperties(Storage.StorageDirectory sd, int rollbackLayoutVersion) throws IOException {
        Properties props = DataStorage.readPropertiesFile(sd.getVersionFile());
        this.setFieldsFromProperties(props, sd, true, rollbackLayoutVersion);
    }

    private boolean doTransition(Storage.StorageDirectory sd, NamespaceInfo nsInfo, HdfsServerConstants.StartupOption startOpt, List<Callable<Storage.StorageDirectory>> callables, Configuration conf) throws IOException {
        if (startOpt == HdfsServerConstants.StartupOption.ROLLBACK) {
            this.doRollback(sd, nsInfo);
        }
        this.readProperties(sd);
        DataStorage.checkVersionUpgradable(this.layoutVersion);
        assert (this.layoutVersion >= HdfsConstants.DATANODE_LAYOUT_VERSION) : "Future version is not allowed";
        boolean federationSupported = DataNodeLayoutVersion.supports(LayoutVersion.Feature.FEDERATION, this.layoutVersion);
        if (!federationSupported && this.getNamespaceID() != nsInfo.getNamespaceID()) {
            throw new IOException("Incompatible namespaceIDs in " + sd.getRoot().getCanonicalPath() + ": namenode namespaceID = " + nsInfo.getNamespaceID() + "; datanode namespaceID = " + this.getNamespaceID());
        }
        if (federationSupported && !this.getClusterID().equals(nsInfo.getClusterID())) {
            throw new IOException("Incompatible clusterIDs in " + sd.getRoot().getCanonicalPath() + ": namenode clusterID = " + nsInfo.getClusterID() + "; datanode clusterID = " + this.getClusterID());
        }
        if (this.layoutVersion == HdfsConstants.DATANODE_LAYOUT_VERSION) {
            DataStorage.createStorageID(sd, this.layoutVersion);
            return false;
        }
        if (this.layoutVersion > HdfsConstants.DATANODE_LAYOUT_VERSION) {
            if (federationSupported) {
                this.upgradeProperties(sd);
            } else {
                this.doUpgradePreFederation(sd, nsInfo, callables, conf);
            }
            return true;
        }
        throw new IOException("BUG: The stored LV = " + this.getLayoutVersion() + " is newer than the supported LV = " + HdfsConstants.DATANODE_LAYOUT_VERSION);
    }

    void doUpgradePreFederation(final Storage.StorageDirectory sd, final NamespaceInfo nsInfo, List<Callable<Storage.StorageDirectory>> callables, final Configuration conf) throws IOException {
        final int oldLV = this.getLayoutVersion();
        LOG.info((Object)("Upgrading storage directory " + sd.getRoot() + ".\n   old LV = " + oldLV + "; old CTime = " + this.getCTime() + ".\n   new LV = " + HdfsConstants.DATANODE_LAYOUT_VERSION + "; new CTime = " + nsInfo.getCTime()));
        File curDir = sd.getCurrentDir();
        final File prevDir = sd.getPreviousDir();
        final File bbwDir = new File(sd.getRoot(), "blocksBeingWritten");
        assert (curDir.exists()) : "Data node current directory must exist.";
        this.cleanupDetachDir(new File(curDir, STORAGE_DIR_DETACHED));
        if (prevDir.exists()) {
            DataStorage.deleteDir(prevDir);
        }
        final File tmpDir = sd.getPreviousTmp();
        assert (!tmpDir.exists()) : "Data node previous.tmp directory must not exist.";
        DataStorage.rename(curDir, tmpDir);
        File curBpDir = BlockPoolSliceStorage.getBpRoot(nsInfo.getBlockPoolID(), curDir);
        BlockPoolSliceStorage bpStorage = this.getBlockPoolSliceStorage(nsInfo);
        bpStorage.format(curDir, nsInfo);
        final File toDir = new File(curBpDir, "current");
        if (callables == null) {
            this.doUpgrade(sd, nsInfo, prevDir, tmpDir, bbwDir, toDir, oldLV, conf);
        } else {
            callables.add(new Callable<Storage.StorageDirectory>(){

                @Override
                public Storage.StorageDirectory call() throws Exception {
                    DataStorage.this.doUpgrade(sd, nsInfo, prevDir, tmpDir, bbwDir, toDir, oldLV, conf);
                    return sd;
                }
            });
        }
    }

    private void doUpgrade(Storage.StorageDirectory sd, NamespaceInfo nsInfo, File prevDir, File tmpDir, File bbwDir, File toDir, int oldLV, Configuration conf) throws IOException {
        DataStorage.linkAllBlocks(tmpDir, bbwDir, toDir, oldLV, conf);
        this.clusterID = nsInfo.getClusterID();
        this.upgradeProperties(sd);
        DataStorage.rename(tmpDir, prevDir);
        LOG.info((Object)("Upgrade of " + sd.getRoot() + " is complete"));
    }

    void upgradeProperties(Storage.StorageDirectory sd) throws IOException {
        DataStorage.createStorageID(sd, this.layoutVersion);
        LOG.info((Object)("Updating layout version from " + this.layoutVersion + " to " + HdfsConstants.DATANODE_LAYOUT_VERSION + " for storage " + sd.getRoot()));
        this.layoutVersion = HdfsConstants.DATANODE_LAYOUT_VERSION;
        this.writeProperties(sd);
    }

    private void cleanupDetachDir(File detachDir) throws IOException {
        if (!DataNodeLayoutVersion.supports(LayoutVersion.Feature.APPEND_RBW_DIR, this.layoutVersion) && detachDir.exists() && detachDir.isDirectory()) {
            if (FileUtil.list((File)detachDir).length != 0) {
                throw new IOException("Detached directory " + detachDir + " is not empty. Please manually move each file under this " + "directory to the finalized directory if the finalized " + "directory tree does not have the file.");
            }
            if (!detachDir.delete()) {
                throw new IOException("Cannot remove directory " + detachDir);
            }
        }
    }

    void doRollback(Storage.StorageDirectory sd, NamespaceInfo nsInfo) throws IOException {
        File prevDir = sd.getPreviousDir();
        if (!prevDir.exists()) {
            if (DataNodeLayoutVersion.supports(LayoutVersion.Feature.FEDERATION, HdfsConstants.DATANODE_LAYOUT_VERSION)) {
                this.readProperties(sd, HdfsConstants.DATANODE_LAYOUT_VERSION);
                this.writeProperties(sd);
                LOG.info((Object)("Layout version rolled back to " + HdfsConstants.DATANODE_LAYOUT_VERSION + " for storage " + sd.getRoot()));
            }
            return;
        }
        DataStorage prevInfo = new DataStorage();
        prevInfo.readPreviousVersionProperties(sd);
        if (prevInfo.getLayoutVersion() < HdfsConstants.DATANODE_LAYOUT_VERSION || prevInfo.getCTime() > nsInfo.getCTime()) {
            throw new InconsistentFSStateException(sd.getRoot(), "Cannot rollback to a newer state.\nDatanode previous state: LV = " + prevInfo.getLayoutVersion() + " CTime = " + prevInfo.getCTime() + " is newer than the namespace state: LV = " + HdfsConstants.DATANODE_LAYOUT_VERSION + " CTime = " + nsInfo.getCTime());
        }
        LOG.info((Object)("Rolling back storage directory " + sd.getRoot() + ".\n   target LV = " + HdfsConstants.DATANODE_LAYOUT_VERSION + "; target CTime = " + nsInfo.getCTime()));
        File tmpDir = sd.getRemovedTmp();
        assert (!tmpDir.exists()) : "removed.tmp directory must not exist.";
        File curDir = sd.getCurrentDir();
        assert (curDir.exists()) : "Current directory must exist.";
        DataStorage.rename(curDir, tmpDir);
        DataStorage.rename(prevDir, curDir);
        DataStorage.deleteDir(tmpDir);
        LOG.info((Object)("Rollback of " + sd.getRoot() + " is complete"));
    }

    void doFinalize(Storage.StorageDirectory sd) throws IOException {
        File prevDir = sd.getPreviousDir();
        if (!prevDir.exists()) {
            return;
        }
        final String dataDirPath = sd.getRoot().getCanonicalPath();
        LOG.info((Object)("Finalizing upgrade for storage directory " + dataDirPath + ".\n   cur LV = " + this.getLayoutVersion() + "; cur CTime = " + this.getCTime()));
        assert (sd.getCurrentDir().exists()) : "Current directory must exist.";
        final File tmpDir = sd.getFinalizedTmp();
        final File bbwDir = new File(sd.getRoot(), "blocksBeingWritten");
        DataStorage.rename(prevDir, tmpDir);
        new Daemon(new Runnable(){

            @Override
            public void run() {
                try {
                    Storage.deleteDir(tmpDir);
                    if (bbwDir.exists()) {
                        Storage.deleteDir(bbwDir);
                    }
                }
                catch (IOException ex) {
                    Storage.LOG.error((Object)("Finalize upgrade for " + dataDirPath + " failed"), (Throwable)ex);
                }
                Storage.LOG.info((Object)("Finalize upgrade for " + dataDirPath + " is complete"));
            }

            public String toString() {
                return "Finalize " + dataDirPath;
            }
        }).start();
    }

    void finalizeUpgrade(String bpID) throws IOException {
        for (Storage.StorageDirectory sd : this.storageDirs) {
            File prevDir = sd.getPreviousDir();
            if (prevDir.exists()) {
                this.doFinalize(sd);
                continue;
            }
            BlockPoolSliceStorage bpStorage = this.bpStorageMap.get(bpID);
            bpStorage.doFinalize(sd.getCurrentDir());
        }
    }

    private static void linkAllBlocks(File fromDir, File fromBbwDir, File toDir, int diskLayoutVersion, Configuration conf) throws IOException {
        HardLink hardLink = new HardLink();
        if (DataNodeLayoutVersion.supports(LayoutVersion.Feature.APPEND_RBW_DIR, diskLayoutVersion)) {
            DataStorage.linkBlocks(fromDir, toDir, STORAGE_DIR_FINALIZED, diskLayoutVersion, hardLink, conf);
            DataStorage.linkBlocks(fromDir, toDir, STORAGE_DIR_RBW, diskLayoutVersion, hardLink, conf);
        } else {
            DataStorage.linkBlocks(fromDir, new File(toDir, STORAGE_DIR_FINALIZED), diskLayoutVersion, hardLink, conf);
            if (fromBbwDir.exists()) {
                DataStorage.linkBlocks(fromBbwDir, new File(toDir, STORAGE_DIR_RBW), diskLayoutVersion, hardLink, conf);
            }
        }
        LOG.info((Object)("Linked blocks from " + fromDir + " to " + toDir + ". " + hardLink.linkStats.report()));
    }

    static void linkBlocks(File fromDir, File toDir, String subdir, int oldLV, HardLink hl, Configuration conf) throws IOException {
        DataStorage.linkBlocks(new File(fromDir, subdir), new File(toDir, subdir), oldLV, hl, conf);
    }

    private static void linkBlocks(File from, File to, int oldLV, HardLink hl, Configuration conf) throws IOException {
        LOG.info((Object)("Start linking block files from " + from + " to " + to));
        boolean upgradeToIdBasedLayout = false;
        if (oldLV > DataNodeLayoutVersion.Feature.BLOCKID_BASED_LAYOUT.getInfo().getLayoutVersion() && to.getName().equals(STORAGE_DIR_FINALIZED)) {
            upgradeToIdBasedLayout = true;
        }
        final ArrayList idBasedLayoutSingleLinks = Lists.newArrayList();
        DataStorage.linkBlocksHelper(from, to, oldLV, hl, upgradeToIdBasedLayout, to, idBasedLayoutSingleLinks);
        ArrayList<LinkArgs> duplicates = DataStorage.findDuplicateEntries(idBasedLayoutSingleLinks);
        if (!duplicates.isEmpty()) {
            LOG.error((Object)("There are " + duplicates.size() + " duplicate block " + "entries within the same volume."));
            DataStorage.removeDuplicateEntries(idBasedLayoutSingleLinks, duplicates);
        }
        int numLinkWorkers = conf.getInt("dfs.datanode.block.id.layout.upgrade.threads", 12);
        ExecutorService linkWorkers = Executors.newFixedThreadPool(numLinkWorkers);
        final int step = idBasedLayoutSingleLinks.size() / numLinkWorkers + 1;
        ArrayList futures = Lists.newArrayList();
        for (int i = 0; i < idBasedLayoutSingleLinks.size(); i += step) {
            final int iCopy = i;
            futures.add(linkWorkers.submit(new Callable<Void>(){

                @Override
                public Void call() throws IOException {
                    int upperBound = Math.min(iCopy + step, idBasedLayoutSingleLinks.size());
                    for (int j = iCopy; j < upperBound; ++j) {
                        LinkArgs cur = (LinkArgs)idBasedLayoutSingleLinks.get(j);
                        NativeIO.link((File)cur.src, (File)cur.dst);
                    }
                    return null;
                }
            }));
        }
        linkWorkers.shutdown();
        for (Future f : futures) {
            Futures.get((Future)f, IOException.class);
        }
    }

    static ArrayList<LinkArgs> findDuplicateEntries(ArrayList<LinkArgs> all) {
        Collections.sort(all, new Comparator<LinkArgs>(){

            @Override
            public int compare(LinkArgs a, LinkArgs b) {
                return ComparisonChain.start().compare((Comparable)((Object)a.src.getName()), (Comparable)((Object)b.src.getName())).compare((Comparable)a.src, (Comparable)b.src).compare((Comparable)a.dst, (Comparable)b.dst).result();
            }
        });
        ArrayList duplicates = Lists.newArrayList();
        Long prevBlockId = null;
        boolean prevWasMeta = false;
        boolean addedPrev = false;
        for (int i = 0; i < all.size(); ++i) {
            LinkArgs args = all.get(i);
            long blockId = Block.getBlockId(args.src.getName());
            boolean isMeta = Block.isMetaFilename(args.src.getName());
            if (prevBlockId == null || prevBlockId != blockId) {
                prevBlockId = blockId;
                addedPrev = false;
            } else if (isMeta == prevWasMeta) {
                duplicates.add(args);
                if (!addedPrev) {
                    duplicates.add(all.get(i - 1));
                }
                addedPrev = true;
            } else {
                addedPrev = false;
            }
            prevWasMeta = isMeta;
        }
        return duplicates;
    }

    private static void removeDuplicateEntries(ArrayList<LinkArgs> all, ArrayList<LinkArgs> duplicates) {
        long blockId;
        long blockId2;
        TreeMap highestGenstamps = new TreeMap();
        for (LinkArgs duplicate : duplicates) {
            if (!Block.isMetaFilename(duplicate.src.getName())) continue;
            blockId2 = Block.getBlockId(duplicate.src.getName());
            List prevHighest = (List)highestGenstamps.get(blockId2);
            if (prevHighest == null) {
                LinkedList<LinkArgs> highest = new LinkedList<LinkArgs>();
                highest.add(duplicate);
                highestGenstamps.put(blockId2, highest);
                continue;
            }
            long prevGenstamp = Block.getGenerationStamp(((LinkArgs)prevHighest.get((int)0)).src.getName());
            long genstamp = Block.getGenerationStamp(duplicate.src.getName());
            if (genstamp < prevGenstamp) continue;
            if (genstamp > prevGenstamp) {
                prevHighest.clear();
            }
            prevHighest.add(duplicate);
        }
        Iterator<LinkArgs> iter = duplicates.iterator();
        while (iter.hasNext()) {
            LinkArgs duplicate;
            duplicate = iter.next();
            blockId2 = Block.getBlockId(duplicate.src.getName());
            List highest = (List)highestGenstamps.get(blockId2);
            if (highest == null) continue;
            boolean found = false;
            for (LinkArgs high : highest) {
                if (!high.src.getParent().equals(duplicate.src.getParent())) continue;
                found = true;
                break;
            }
            if (found) continue;
            LOG.warn((Object)("Unexpectedly low genstamp on " + duplicate.src.getAbsolutePath() + "."));
            iter.remove();
        }
        TreeMap<Long, LinkArgs> longestBlockFiles = new TreeMap<Long, LinkArgs>();
        for (LinkArgs duplicate : duplicates) {
            long prevBlockLength;
            if (Block.isMetaFilename(duplicate.src.getName())) continue;
            blockId = Block.getBlockId(duplicate.src.getName());
            LinkArgs prevLongest = (LinkArgs)longestBlockFiles.get(blockId);
            if (prevLongest == null) {
                longestBlockFiles.put(blockId, duplicate);
                continue;
            }
            long blockLength = duplicate.src.length();
            if (blockLength < (prevBlockLength = prevLongest.src.length())) {
                LOG.warn((Object)("Unexpectedly short length on " + duplicate.src.getAbsolutePath() + "."));
                continue;
            }
            if (blockLength > prevBlockLength) {
                LOG.warn((Object)("Unexpectedly short length on " + prevLongest.src.getAbsolutePath() + "."));
            }
            longestBlockFiles.put(blockId, duplicate);
        }
        Iterator<LinkArgs> iter2 = all.iterator();
        while (iter2.hasNext()) {
            LinkArgs args = iter2.next();
            blockId = Block.getBlockId(args.src.getName());
            LinkArgs bestDuplicate = (LinkArgs)longestBlockFiles.get(blockId);
            if (bestDuplicate == null || bestDuplicate.src.getParent().equals(args.src.getParent())) continue;
            LOG.warn((Object)("Discarding " + args.src.getAbsolutePath() + "."));
            iter2.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void linkBlocksHelper(File from, File to, int oldLV, HardLink hl, boolean upgradeToIdBasedLayout, File blockRoot, List<LinkArgs> idBasedLayoutSingleLinks) throws IOException {
        if (!from.exists()) {
            return;
        }
        if (!from.isDirectory()) {
            block17: {
                if (from.getName().startsWith(COPY_FILE_PREFIX)) {
                    try (FileInputStream in = new FileInputStream(from);
                         FileOutputStream out = new FileOutputStream(to);){
                        IOUtils.copyBytes((InputStream)in, (OutputStream)out, (int)16384);
                        ++hl.linkStats.countPhysicalFileCopies;
                        break block17;
                    }
                }
                HardLink.createHardLink((File)from, (File)to);
                ++hl.linkStats.countSingleLinks;
            }
            return;
        }
        ++hl.linkStats.countDirs;
        String[] blockNames = from.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("blk_");
            }
        });
        if (!(upgradeToIdBasedLayout && to.getName().startsWith(BLOCK_SUBDIR_PREFIX) || to.mkdirs())) {
            throw new IOException("Cannot create directory " + to);
        }
        if (blockNames.length > 0) {
            if (upgradeToIdBasedLayout) {
                for (String blockName : blockNames) {
                    long blockId = Block.getBlockId(blockName);
                    File blockLocation = DatanodeUtil.idToBlockDir(blockRoot, blockId);
                    if (!blockLocation.exists() && !blockLocation.mkdirs()) {
                        throw new IOException("Failed to mkdirs " + blockLocation);
                    }
                    idBasedLayoutSingleLinks.add(new LinkArgs(new File(from, blockName), new File(blockLocation, blockName)));
                    ++hl.linkStats.countSingleLinks;
                }
            } else {
                HardLink.createHardLinkMult((File)from, (String[])blockNames, (File)to);
                ++hl.linkStats.countMultLinks;
                hl.linkStats.countFilesMultLinks += blockNames.length;
            }
        } else {
            ++hl.linkStats.countEmptyDirs;
        }
        String[] otherNames = from.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(DataStorage.BLOCK_SUBDIR_PREFIX) || name.startsWith(DataStorage.COPY_FILE_PREFIX);
            }
        });
        for (int i = 0; i < otherNames.length; ++i) {
            DataStorage.linkBlocksHelper(new File(from, otherNames[i]), new File(to, otherNames[i]), oldLV, hl, upgradeToIdBasedLayout, blockRoot, idBasedLayoutSingleLinks);
        }
    }

    synchronized BlockPoolSliceStorage getBlockPoolSliceStorage(NamespaceInfo nsInfo) {
        String bpid = nsInfo.getBlockPoolID();
        BlockPoolSliceStorage bpStorage = this.bpStorageMap.get(bpid);
        if (bpStorage == null) {
            bpStorage = new BlockPoolSliceStorage(nsInfo.getNamespaceID(), bpid, nsInfo.getCTime(), nsInfo.getClusterID());
            this.bpStorageMap.put(bpid, bpStorage);
        }
        return bpStorage;
    }

    synchronized void removeBlockPoolStorage(String bpId) {
        this.bpStorageMap.remove(bpId);
    }

    private static class LinkArgs {
        File src;
        File dst;

        LinkArgs(File src, File dst) {
            this.src = src;
            this.dst = dst;
        }
    }

    static class UpgradeTask {
        private final StorageLocation dataDir;
        private final Future<Storage.StorageDirectory> future;

        UpgradeTask(StorageLocation dataDir, Future<Storage.StorageDirectory> future) {
            this.dataDir = dataDir;
            this.future = future;
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static class VolumeBuilder {
        private DataStorage storage;
        private Storage.StorageDirectory sd;
        private Map<String, List<Storage.StorageDirectory>> bpStorageDirMap = Maps.newHashMap();

        @VisibleForTesting
        public VolumeBuilder(DataStorage storage, Storage.StorageDirectory sd) {
            this.storage = storage;
            this.sd = sd;
        }

        public final Storage.StorageDirectory getStorageDirectory() {
            return this.sd;
        }

        private void addBpStorageDirectories(String bpid, List<Storage.StorageDirectory> dirs) {
            this.bpStorageDirMap.put(bpid, dirs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void build() {
            assert (this.sd != null);
            DataStorage dataStorage = this.storage;
            synchronized (dataStorage) {
                for (Map.Entry<String, List<Storage.StorageDirectory>> e : this.bpStorageDirMap.entrySet()) {
                    String bpid = e.getKey();
                    BlockPoolSliceStorage bpStorage = (BlockPoolSliceStorage)this.storage.bpStorageMap.get(bpid);
                    assert (bpStorage != null);
                    for (Storage.StorageDirectory bpSd : e.getValue()) {
                        bpStorage.addStorageDir(bpSd);
                    }
                }
                this.storage.addStorageDir(this.sd);
            }
        }
    }
}

