/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.protobuf.generated.ComparatorProtos;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class BinaryComparator
extends ByteArrayComparable {
    public BinaryComparator(byte[] value) {
        super(value);
    }

    @Override
    public int compareTo(byte[] value, int offset, int length) {
        return Bytes.compareTo((byte[])this.value, (int)0, (int)this.value.length, (byte[])value, (int)offset, (int)length);
    }

    @Override
    public byte[] toByteArray() {
        ComparatorProtos.BinaryComparator.Builder builder = ComparatorProtos.BinaryComparator.newBuilder();
        builder.setComparable(super.convert());
        return builder.build().toByteArray();
    }

    public static BinaryComparator parseFrom(byte[] pbBytes) throws DeserializationException {
        ComparatorProtos.BinaryComparator proto;
        try {
            proto = ComparatorProtos.BinaryComparator.parseFrom((byte[])pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        return new BinaryComparator(proto.getComparable().getValue().toByteArray());
    }

    @Override
    boolean areSerializedFieldsEqual(ByteArrayComparable other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof BinaryComparator)) {
            return false;
        }
        return super.areSerializedFieldsEqual(other);
    }
}

