/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.ServerListener;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class DrainingServerTracker
extends ZooKeeperListener {
    private static final Log LOG = LogFactory.getLog(DrainingServerTracker.class);
    private ServerManager serverManager;
    private final NavigableSet<ServerName> drainingServers = new TreeSet<ServerName>();
    private Abortable abortable;

    public DrainingServerTracker(ZooKeeperWatcher watcher, Abortable abortable, ServerManager serverManager) {
        super(watcher);
        this.abortable = abortable;
        this.serverManager = serverManager;
    }

    public void start() throws KeeperException, IOException {
        this.watcher.registerListener((ZooKeeperListener)this);
        this.serverManager.registerListener(new ServerListener(){

            @Override
            public void serverAdded(ServerName sn) {
                if (DrainingServerTracker.this.drainingServers.contains(sn)) {
                    DrainingServerTracker.this.serverManager.addServerToDrainList(sn);
                }
            }

            @Override
            public void serverRemoved(ServerName serverName) {
            }
        });
        List servers = ZKUtil.listChildrenAndWatchThem((ZooKeeperWatcher)this.watcher, (String)this.watcher.drainingZNode);
        this.add(servers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(List<String> servers) throws IOException {
        NavigableSet<ServerName> navigableSet = this.drainingServers;
        synchronized (navigableSet) {
            this.drainingServers.clear();
            for (String n : servers) {
                ServerName sn = ServerName.valueOf((String)ZKUtil.getNodeName((String)n));
                this.drainingServers.add(sn);
                this.serverManager.addServerToDrainList(sn);
                LOG.info((Object)("Draining RS node created, adding to list [" + sn + "]"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(ServerName sn) {
        NavigableSet<ServerName> navigableSet = this.drainingServers;
        synchronized (navigableSet) {
            this.drainingServers.remove(sn);
            this.serverManager.removeServerFromDrainList(sn);
        }
    }

    public void nodeDeleted(String path) {
        if (path.startsWith(this.watcher.drainingZNode)) {
            ServerName sn = ServerName.valueOf((String)ZKUtil.getNodeName((String)path));
            LOG.info((Object)("Draining RS node deleted, removing from list [" + sn + "]"));
            this.remove(sn);
        }
    }

    public void nodeChildrenChanged(String path) {
        if (path.equals(this.watcher.drainingZNode)) {
            try {
                List newNodes = ZKUtil.listChildrenAndWatchThem((ZooKeeperWatcher)this.watcher, (String)this.watcher.drainingZNode);
                this.add(newNodes);
            }
            catch (KeeperException e) {
                this.abortable.abort("Unexpected zk exception getting RS nodes", (Throwable)e);
            }
            catch (IOException e) {
                this.abortable.abort("Unexpected zk exception getting RS nodes", (Throwable)e);
            }
        }
    }
}

