/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.requests.RequestUtils;
import org.apache.kafka.common.utils.Utils;

public class FetchRequest
extends AbstractRequest {
    public static final int CONSUMER_REPLICA_ID = -1;
    private static final Field.ComplexArray TOPICS = new Field.ComplexArray("topics", "Topics to fetch in the order provided.");
    private static final Field.ComplexArray FORGOTTEN_TOPICS = new Field.ComplexArray("forgotten_topics_data", "Topics to remove from the fetch session.");
    private static final Field.Int32 MAX_BYTES = new Field.Int32("max_bytes", "Maximum bytes to accumulate in the response. Note that this is not an absolute maximum, if the first message in the first non-empty partition of the fetch is larger than this value, the message will still be returned to ensure that progress can be made.");
    private static final Field.Int8 ISOLATION_LEVEL = new Field.Int8("isolation_level", "This setting controls the visibility of transactional records. Using READ_UNCOMMITTED (isolation_level = 0) makes all records visible. With READ_COMMITTED (isolation_level = 1), non-transactional and COMMITTED transactional records are visible. To be more concrete, READ_COMMITTED returns all data from offsets smaller than the current LSO (last stable offset), and enables the inclusion of the list of aborted transactions in the result, which allows consumers to discard ABORTED transactional records");
    private static final Field.Int32 SESSION_ID = new Field.Int32("session_id", "The fetch session ID");
    private static final Field.Int32 SESSION_EPOCH = new Field.Int32("session_epoch", "The fetch session epoch");
    private static final Field.ComplexArray PARTITIONS = new Field.ComplexArray("partitions", "Partitions to fetch.");
    private static final Field.Int32 REPLICA_ID = new Field.Int32("replica_id", "Broker id of the follower. For normal consumers, use -1.");
    private static final Field.Int64 FETCH_OFFSET = new Field.Int64("fetch_offset", "Message offset.");
    private static final Field.Int32 PARTITION_MAX_BYTES = new Field.Int32("partition_max_bytes", "Maximum bytes to fetch.");
    private static final Field.Int32 MAX_WAIT_TIME = new Field.Int32("max_wait_time", "Maximum time in ms to wait for the response.");
    private static final Field.Int32 MIN_BYTES = new Field.Int32("min_bytes", "Minimum bytes to accumulate in the response.");
    private static final Field.Int64 LOG_START_OFFSET = new Field.Int64("log_start_offset", "Earliest available offset of the follower replica. The field is only used when request is sent by follower. ");
    private static final Field PARTITIONS_V0 = PARTITIONS.withFields(CommonFields.PARTITION_ID, FETCH_OFFSET, PARTITION_MAX_BYTES);
    private static final Field TOPICS_V0 = TOPICS.withFields(CommonFields.TOPIC_NAME, PARTITIONS_V0);
    private static final Schema FETCH_REQUEST_V0;
    private static final Schema FETCH_REQUEST_V1;
    private static final Schema FETCH_REQUEST_V2;
    private static final Schema FETCH_REQUEST_V3;
    private static final Schema FETCH_REQUEST_V4;
    private static final Field PARTITIONS_V5;
    private static final Field TOPICS_V5;
    private static final Schema FETCH_REQUEST_V5;
    private static final Schema FETCH_REQUEST_V6;
    private static final Field.Array FORGOTTEN_PARTITIONS;
    private static final Field FORGOTTEN_TOPIC_DATA_V7;
    private static final Schema FETCH_REQUEST_V7;
    private static final Schema FETCH_REQUEST_V8;
    private static final Field FETCH_REQUEST_PARTITION_V9;
    private static final Field FETCH_REQUEST_TOPIC_V9;
    private static final Schema FETCH_REQUEST_V9;
    private static final Schema FETCH_REQUEST_V10;
    public static final int DEFAULT_RESPONSE_MAX_BYTES = Integer.MAX_VALUE;
    public static final long INVALID_LOG_START_OFFSET = -1L;
    private final int replicaId;
    private final int maxWait;
    private final int minBytes;
    private final int maxBytes;
    private final IsolationLevel isolationLevel;
    private final Map<TopicPartition, PartitionData> fetchData;
    private final List<TopicPartition> toForget;
    private final FetchMetadata metadata;

    public static Schema[] schemaVersions() {
        return new Schema[]{FETCH_REQUEST_V0, FETCH_REQUEST_V1, FETCH_REQUEST_V2, FETCH_REQUEST_V3, FETCH_REQUEST_V4, FETCH_REQUEST_V5, FETCH_REQUEST_V6, FETCH_REQUEST_V7, FETCH_REQUEST_V8, FETCH_REQUEST_V9, FETCH_REQUEST_V10};
    }

    private FetchRequest(short version, int replicaId, int maxWait, int minBytes, int maxBytes, Map<TopicPartition, PartitionData> fetchData, IsolationLevel isolationLevel, List<TopicPartition> toForget, FetchMetadata metadata) {
        super(ApiKeys.FETCH, version);
        this.replicaId = replicaId;
        this.maxWait = maxWait;
        this.minBytes = minBytes;
        this.maxBytes = maxBytes;
        this.fetchData = fetchData;
        this.isolationLevel = isolationLevel;
        this.toForget = toForget;
        this.metadata = metadata;
    }

    public FetchRequest(Struct struct, short version) {
        super(ApiKeys.FETCH, version);
        this.replicaId = struct.get(REPLICA_ID);
        this.maxWait = struct.get(MAX_WAIT_TIME);
        this.minBytes = struct.get(MIN_BYTES);
        this.maxBytes = struct.getOrElse(MAX_BYTES, Integer.MAX_VALUE);
        this.isolationLevel = struct.hasField(ISOLATION_LEVEL) ? IsolationLevel.forId(struct.get(ISOLATION_LEVEL)) : IsolationLevel.READ_UNCOMMITTED;
        this.toForget = new ArrayList<TopicPartition>(0);
        if (struct.hasField(FORGOTTEN_TOPICS)) {
            for (Object forgottenTopicObj : struct.get(FORGOTTEN_TOPICS)) {
                Struct forgottenTopic = (Struct)forgottenTopicObj;
                String topicName = forgottenTopic.get(CommonFields.TOPIC_NAME);
                for (Object partObj : forgottenTopic.get(FORGOTTEN_PARTITIONS)) {
                    Integer part = (Integer)partObj;
                    this.toForget.add(new TopicPartition(topicName, part));
                }
            }
        }
        this.metadata = new FetchMetadata(struct.getOrElse(SESSION_ID, 0), struct.getOrElse(SESSION_EPOCH, -1));
        this.fetchData = new LinkedHashMap<TopicPartition, PartitionData>();
        for (Object topicResponseObj : struct.get(TOPICS)) {
            Struct topicResponse = (Struct)topicResponseObj;
            String topic = topicResponse.get(CommonFields.TOPIC_NAME);
            for (Object partitionResponseObj : topicResponse.get(PARTITIONS)) {
                Struct partitionResponse = (Struct)partitionResponseObj;
                int partition = partitionResponse.get(CommonFields.PARTITION_ID);
                long offset = partitionResponse.get(FETCH_OFFSET);
                int maxBytes = partitionResponse.get(PARTITION_MAX_BYTES);
                long logStartOffset = partitionResponse.getOrElse(LOG_START_OFFSET, -1L);
                Optional<Integer> currentLeaderEpoch = RequestUtils.getLeaderEpoch(partitionResponse, CommonFields.CURRENT_LEADER_EPOCH);
                PartitionData partitionData = new PartitionData(offset, logStartOffset, maxBytes, currentLeaderEpoch);
                this.fetchData.put(new TopicPartition(topic, partition), partitionData);
            }
        }
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        LinkedHashMap responseData = new LinkedHashMap();
        for (Map.Entry<TopicPartition, PartitionData> entry : this.fetchData.entrySet()) {
            FetchResponse.PartitionData<MemoryRecords> partitionResponse = new FetchResponse.PartitionData<MemoryRecords>(error, -1L, -1L, -1L, null, MemoryRecords.EMPTY);
            responseData.put(entry.getKey(), partitionResponse);
        }
        return new FetchResponse(error, responseData, throttleTimeMs, this.metadata.sessionId());
    }

    public int replicaId() {
        return this.replicaId;
    }

    public int maxWait() {
        return this.maxWait;
    }

    public int minBytes() {
        return this.minBytes;
    }

    public int maxBytes() {
        return this.maxBytes;
    }

    public Map<TopicPartition, PartitionData> fetchData() {
        return this.fetchData;
    }

    public List<TopicPartition> toForget() {
        return this.toForget;
    }

    public boolean isFromFollower() {
        return this.replicaId >= 0;
    }

    public IsolationLevel isolationLevel() {
        return this.isolationLevel;
    }

    public FetchMetadata metadata() {
        return this.metadata;
    }

    public static FetchRequest parse(ByteBuffer buffer, short version) {
        return new FetchRequest(ApiKeys.FETCH.parseRequest(version, buffer), version);
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.FETCH.requestSchema(this.version()));
        List topicsData = TopicAndPartitionData.batchByTopic(this.fetchData.entrySet().iterator());
        struct.set(REPLICA_ID, this.replicaId);
        struct.set(MAX_WAIT_TIME, this.maxWait);
        struct.set(MIN_BYTES, this.minBytes);
        struct.setIfExists(MAX_BYTES, (Object)this.maxBytes);
        struct.setIfExists(ISOLATION_LEVEL, (Object)this.isolationLevel.id());
        struct.setIfExists(SESSION_ID, (Object)this.metadata.sessionId());
        struct.setIfExists(SESSION_EPOCH, (Object)this.metadata.epoch());
        ArrayList<Struct> topicArray = new ArrayList<Struct>();
        for (TopicAndPartitionData topicAndPartitionData : topicsData) {
            Struct topicData = struct.instance(TOPICS);
            topicData.set(CommonFields.TOPIC_NAME, topicAndPartitionData.topic);
            ArrayList<Struct> partitionArray = new ArrayList<Struct>();
            for (Map.Entry partitionEntry : topicAndPartitionData.partitions.entrySet()) {
                PartitionData fetchPartitionData = (PartitionData)partitionEntry.getValue();
                Struct partitionData = topicData.instance(PARTITIONS);
                partitionData.set(CommonFields.PARTITION_ID, partitionEntry.getKey());
                partitionData.set(FETCH_OFFSET, fetchPartitionData.fetchOffset);
                partitionData.set(PARTITION_MAX_BYTES, fetchPartitionData.maxBytes);
                partitionData.setIfExists(LOG_START_OFFSET, (Object)fetchPartitionData.logStartOffset);
                RequestUtils.setLeaderEpochIfExists(partitionData, CommonFields.CURRENT_LEADER_EPOCH, fetchPartitionData.currentLeaderEpoch);
                partitionArray.add(partitionData);
            }
            topicData.set(PARTITIONS, partitionArray.toArray());
            topicArray.add(topicData);
        }
        struct.set(TOPICS, topicArray.toArray());
        if (struct.hasField(FORGOTTEN_TOPICS)) {
            HashMap<String, List> topicsToPartitions = new HashMap<String, List>();
            for (TopicPartition part : this.toForget) {
                List partitions = topicsToPartitions.computeIfAbsent(part.topic(), topic -> new ArrayList());
                partitions.add(part.partition());
            }
            ArrayList<Struct> arrayList = new ArrayList<Struct>();
            for (Map.Entry entry : topicsToPartitions.entrySet()) {
                Struct toForgetStruct = struct.instance(FORGOTTEN_TOPICS);
                toForgetStruct.set(CommonFields.TOPIC_NAME, (String)entry.getKey());
                toForgetStruct.set(FORGOTTEN_PARTITIONS, ((List)entry.getValue()).toArray());
                arrayList.add(toForgetStruct);
            }
            struct.set(FORGOTTEN_TOPICS, arrayList.toArray());
        }
        return struct;
    }

    static {
        FETCH_REQUEST_V2 = FETCH_REQUEST_V1 = (FETCH_REQUEST_V0 = new Schema(REPLICA_ID, MAX_WAIT_TIME, MIN_BYTES, TOPICS_V0));
        FETCH_REQUEST_V3 = new Schema(REPLICA_ID, MAX_WAIT_TIME, MIN_BYTES, MAX_BYTES, TOPICS_V0);
        FETCH_REQUEST_V4 = new Schema(REPLICA_ID, MAX_WAIT_TIME, MIN_BYTES, MAX_BYTES, ISOLATION_LEVEL, TOPICS_V0);
        PARTITIONS_V5 = PARTITIONS.withFields(CommonFields.PARTITION_ID, FETCH_OFFSET, LOG_START_OFFSET, PARTITION_MAX_BYTES);
        TOPICS_V5 = TOPICS.withFields(CommonFields.TOPIC_NAME, PARTITIONS_V5);
        FETCH_REQUEST_V6 = FETCH_REQUEST_V5 = new Schema(REPLICA_ID, MAX_WAIT_TIME, MIN_BYTES, MAX_BYTES, ISOLATION_LEVEL, TOPICS_V5);
        FORGOTTEN_PARTITIONS = new Field.Array("partitions", Type.INT32, "Partitions to remove from the fetch session.");
        FORGOTTEN_TOPIC_DATA_V7 = FORGOTTEN_TOPICS.withFields(CommonFields.TOPIC_NAME, FORGOTTEN_PARTITIONS);
        FETCH_REQUEST_V8 = FETCH_REQUEST_V7 = new Schema(REPLICA_ID, MAX_WAIT_TIME, MIN_BYTES, MAX_BYTES, ISOLATION_LEVEL, SESSION_ID, SESSION_EPOCH, TOPICS_V5, FORGOTTEN_TOPIC_DATA_V7);
        FETCH_REQUEST_PARTITION_V9 = PARTITIONS.withFields(CommonFields.PARTITION_ID, CommonFields.CURRENT_LEADER_EPOCH, FETCH_OFFSET, LOG_START_OFFSET, PARTITION_MAX_BYTES);
        FETCH_REQUEST_TOPIC_V9 = TOPICS.withFields(CommonFields.TOPIC_NAME, FETCH_REQUEST_PARTITION_V9);
        FETCH_REQUEST_V10 = FETCH_REQUEST_V9 = new Schema(REPLICA_ID, MAX_WAIT_TIME, MIN_BYTES, MAX_BYTES, ISOLATION_LEVEL, SESSION_ID, SESSION_EPOCH, FETCH_REQUEST_TOPIC_V9, FORGOTTEN_TOPIC_DATA_V7);
    }

    public static class Builder
    extends AbstractRequest.Builder<FetchRequest> {
        private final int maxWait;
        private final int minBytes;
        private final int replicaId;
        private final Map<TopicPartition, PartitionData> fetchData;
        private IsolationLevel isolationLevel = IsolationLevel.READ_UNCOMMITTED;
        private int maxBytes = Integer.MAX_VALUE;
        private FetchMetadata metadata = FetchMetadata.LEGACY;
        private List<TopicPartition> toForget = Collections.emptyList();

        public static Builder forConsumer(int maxWait, int minBytes, Map<TopicPartition, PartitionData> fetchData) {
            return new Builder(ApiKeys.FETCH.oldestVersion(), ApiKeys.FETCH.latestVersion(), -1, maxWait, minBytes, fetchData);
        }

        public static Builder forReplica(short allowedVersion, int replicaId, int maxWait, int minBytes, Map<TopicPartition, PartitionData> fetchData) {
            return new Builder(allowedVersion, allowedVersion, replicaId, maxWait, minBytes, fetchData);
        }

        public Builder(short minVersion, short maxVersion, int replicaId, int maxWait, int minBytes, Map<TopicPartition, PartitionData> fetchData) {
            super(ApiKeys.FETCH, minVersion, maxVersion);
            this.replicaId = replicaId;
            this.maxWait = maxWait;
            this.minBytes = minBytes;
            this.fetchData = fetchData;
        }

        public Builder isolationLevel(IsolationLevel isolationLevel) {
            this.isolationLevel = isolationLevel;
            return this;
        }

        public Builder metadata(FetchMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Map<TopicPartition, PartitionData> fetchData() {
            return this.fetchData;
        }

        public Builder setMaxBytes(int maxBytes) {
            this.maxBytes = maxBytes;
            return this;
        }

        public List<TopicPartition> toForget() {
            return this.toForget;
        }

        public Builder toForget(List<TopicPartition> toForget) {
            this.toForget = toForget;
            return this;
        }

        @Override
        public FetchRequest build(short version) {
            if (version < 3) {
                this.maxBytes = Integer.MAX_VALUE;
            }
            return new FetchRequest(version, this.replicaId, this.maxWait, this.minBytes, this.maxBytes, this.fetchData, this.isolationLevel, this.toForget, this.metadata);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=FetchRequest").append(", replicaId=").append(this.replicaId).append(", maxWait=").append(this.maxWait).append(", minBytes=").append(this.minBytes).append(", maxBytes=").append(this.maxBytes).append(", fetchData=").append(this.fetchData).append(", isolationLevel=").append((Object)this.isolationLevel).append(", toForget=").append(Utils.join(this.toForget, ", ")).append(", metadata=").append(this.metadata).append(")");
            return bld.toString();
        }
    }

    static final class TopicAndPartitionData<T> {
        public final String topic;
        public final LinkedHashMap<Integer, T> partitions;

        public TopicAndPartitionData(String topic) {
            this.topic = topic;
            this.partitions = new LinkedHashMap();
        }

        public static <T> List<TopicAndPartitionData<T>> batchByTopic(Iterator<Map.Entry<TopicPartition, T>> iter) {
            ArrayList<TopicAndPartitionData<T>> topics = new ArrayList<TopicAndPartitionData<T>>();
            while (iter.hasNext()) {
                Map.Entry<TopicPartition, T> topicEntry = iter.next();
                String topic = topicEntry.getKey().topic();
                int partition = topicEntry.getKey().partition();
                T partitionData = topicEntry.getValue();
                if (topics.isEmpty() || !((TopicAndPartitionData)topics.get((int)(topics.size() - 1))).topic.equals(topic)) {
                    topics.add(new TopicAndPartitionData<T>(topic));
                }
                ((TopicAndPartitionData)topics.get((int)(topics.size() - 1))).partitions.put(partition, partitionData);
            }
            return topics;
        }
    }

    public static final class PartitionData {
        public final long fetchOffset;
        public final long logStartOffset;
        public final int maxBytes;
        public final Optional<Integer> currentLeaderEpoch;

        public PartitionData(long fetchOffset, long logStartOffset, int maxBytes, Optional<Integer> currentLeaderEpoch) {
            this.fetchOffset = fetchOffset;
            this.logStartOffset = logStartOffset;
            this.maxBytes = maxBytes;
            this.currentLeaderEpoch = currentLeaderEpoch;
        }

        public String toString() {
            return "(fetchOffset=" + this.fetchOffset + ", logStartOffset=" + this.logStartOffset + ", maxBytes=" + this.maxBytes + ", currentLeaderEpoch=" + this.currentLeaderEpoch + ")";
        }

        public int hashCode() {
            return Objects.hash(this.fetchOffset, this.logStartOffset, this.maxBytes, this.currentLeaderEpoch);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionData that = (PartitionData)o;
            return Objects.equals(this.fetchOffset, that.fetchOffset) && Objects.equals(this.logStartOffset, that.logStartOffset) && Objects.equals(this.maxBytes, that.maxBytes) && Objects.equals(this.currentLeaderEpoch, that.currentLeaderEpoch);
        }
    }
}

