/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol.types;

import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.junit.Assert;
import org.junit.Test;

public class StructTest {
    private static final Schema FLAT_STRUCT_SCHEMA = new Schema(new Field[]{new Field.Int8("int8", ""), new Field.Int16("int16", ""), new Field.Int32("int32", ""), new Field.Int64("int64", ""), new Field.Bool("boolean", ""), new Field.Str("string", "")});
    private static final Schema ARRAY_SCHEMA = new Schema(new Field[]{new Field.Array("array", (Type)new ArrayOf((Type)Type.INT8), "")});
    private static final Schema NESTED_CHILD_SCHEMA = new Schema(new Field[]{new Field.Int8("int8", "")});
    private static final Schema NESTED_SCHEMA = new Schema(new Field[]{new Field.Array("array", (Type)ARRAY_SCHEMA, ""), new Field("nested", (Type)NESTED_CHILD_SCHEMA, "")});

    @Test
    public void testEquals() {
        Struct struct1 = new Struct(FLAT_STRUCT_SCHEMA).set("int8", (Object)12).set("int16", (Object)12).set("int32", (Object)12).set("int64", (Object)12L).set("boolean", (Object)true).set("string", (Object)"foobar");
        Struct struct2 = new Struct(FLAT_STRUCT_SCHEMA).set("int8", (Object)12).set("int16", (Object)12).set("int32", (Object)12).set("int64", (Object)12L).set("boolean", (Object)true).set("string", (Object)"foobar");
        Struct struct3 = new Struct(FLAT_STRUCT_SCHEMA).set("int8", (Object)12).set("int16", (Object)12).set("int32", (Object)12).set("int64", (Object)12L).set("boolean", (Object)true).set("string", (Object)"mismatching string");
        Assert.assertEquals((Object)struct1, (Object)struct2);
        Assert.assertNotEquals((Object)struct1, (Object)struct3);
        Object[] array = new Object[]{(byte)1, (byte)2};
        struct1 = new Struct(NESTED_SCHEMA).set("array", (Object)array).set("nested", (Object)new Struct(NESTED_CHILD_SCHEMA).set("int8", (Object)12));
        Object[] array2 = new Object[]{(byte)1, (byte)2};
        struct2 = new Struct(NESTED_SCHEMA).set("array", (Object)array2).set("nested", (Object)new Struct(NESTED_CHILD_SCHEMA).set("int8", (Object)12));
        Object[] array3 = new Object[]{(byte)1, (byte)2, (byte)3};
        struct3 = new Struct(NESTED_SCHEMA).set("array", (Object)array3).set("nested", (Object)new Struct(NESTED_CHILD_SCHEMA).set("int8", (Object)13));
        Assert.assertEquals((Object)struct1, (Object)struct2);
        Assert.assertNotEquals((Object)struct1, (Object)struct3);
    }
}

