/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.Iterator;
import org.apache.kafka.common.utils.FixedOrderMap;
import org.apache.kafka.common.utils.Utils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class FixedOrderMapTest {
    @Test
    public void shouldMaintainOrderWhenAdding() {
        FixedOrderMap map = new FixedOrderMap();
        map.put((Object)"a", (Object)0);
        map.put((Object)"b", (Object)1);
        map.put((Object)"c", (Object)2);
        map.put((Object)"b", (Object)3);
        Iterator iterator = map.entrySet().iterator();
        MatcherAssert.assertThat(iterator.next(), (Matcher)CoreMatchers.is((Object)Utils.mkEntry((Object)"a", (Object)0)));
        MatcherAssert.assertThat(iterator.next(), (Matcher)CoreMatchers.is((Object)Utils.mkEntry((Object)"b", (Object)3)));
        MatcherAssert.assertThat(iterator.next(), (Matcher)CoreMatchers.is((Object)Utils.mkEntry((Object)"c", (Object)2)));
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void shouldForbidRemove() {
        FixedOrderMap map = new FixedOrderMap();
        map.put((Object)"a", (Object)0);
        try {
            map.remove((Object)"a");
            Assert.fail((String)"expected exception");
        }
        catch (RuntimeException e) {
            MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(UnsupportedOperationException.class));
        }
        MatcherAssert.assertThat((Object)map.get((Object)"a"), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void shouldForbidConditionalRemove() {
        FixedOrderMap map = new FixedOrderMap();
        map.put((Object)"a", (Object)0);
        try {
            map.remove((Object)"a", (Object)0);
            Assert.fail((String)"expected exception");
        }
        catch (RuntimeException e) {
            MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(UnsupportedOperationException.class));
        }
        MatcherAssert.assertThat((Object)map.get((Object)"a"), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void shouldForbidConditionalClear() {
        FixedOrderMap map = new FixedOrderMap();
        map.put((Object)"a", (Object)0);
        try {
            map.clear();
            Assert.fail((String)"expected exception");
        }
        catch (RuntimeException e) {
            MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(UnsupportedOperationException.class));
        }
        MatcherAssert.assertThat((Object)map.get((Object)"a"), (Matcher)CoreMatchers.is((Object)0));
    }
}

