/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class AddPartitionsToTxnResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private AddPartitionsToTxnTopicResultCollection results;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;

    public AddPartitionsToTxnResponseData(Readable readable, short version) {
        this.results = new AddPartitionsToTxnTopicResultCollection(0);
        this.read(readable, version);
    }

    public AddPartitionsToTxnResponseData(Struct struct, short version) {
        this.results = new AddPartitionsToTxnTopicResultCollection(0);
        this.fromStruct(struct, version);
    }

    public AddPartitionsToTxnResponseData() {
        this.throttleTimeMs = 0;
        this.results = new AddPartitionsToTxnTopicResultCollection(0);
    }

    @Override
    public short apiKey() {
        return 24;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public void read(Readable readable, short version) {
        this.throttleTimeMs = readable.readInt();
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.results = null;
        } else {
            this.results.clear(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                this.results.add(new AddPartitionsToTxnTopicResult(readable, version));
            }
        }
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeInt(this.throttleTimeMs);
        writable.writeInt(this.results.size());
        for (AddPartitionsToTxnTopicResult element : this.results) {
            element.write(writable, version);
        }
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.throttleTimeMs = struct.getInt("throttle_time_ms");
        Object[] nestedObjects = struct.getArray("results");
        this.results = new AddPartitionsToTxnTopicResultCollection(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.results.add(new AddPartitionsToTxnTopicResult((Struct)nestedObject, version));
        }
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        Struct[] nestedObjects = new Struct[this.results.size()];
        int i = 0;
        for (AddPartitionsToTxnTopicResult element : this.results) {
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("results", (Object)nestedObjects);
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        size += 4;
        size += 4;
        for (AddPartitionsToTxnTopicResult element : this.results) {
            size += element.size(version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AddPartitionsToTxnResponseData)) {
            return false;
        }
        AddPartitionsToTxnResponseData other = (AddPartitionsToTxnResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        return !(this.results == null ? other.results != null : !this.results.equals(other.results));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.results == null ? 0 : this.results.hashCode());
        return hashCode;
    }

    public String toString() {
        return "AddPartitionsToTxnResponseData(throttleTimeMs=" + this.throttleTimeMs + ", results=" + MessageUtil.deepToString(this.results.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public AddPartitionsToTxnTopicResultCollection results() {
        return this.results;
    }

    public AddPartitionsToTxnResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public AddPartitionsToTxnResponseData setResults(AddPartitionsToTxnTopicResultCollection v) {
        this.results = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "Duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("results", new ArrayOf(AddPartitionsToTxnTopicResult.SCHEMA_0), "The results for each topic."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }

    public static class AddPartitionsToTxnTopicResultCollection
    extends ImplicitLinkedHashMultiCollection<AddPartitionsToTxnTopicResult> {
        public AddPartitionsToTxnTopicResultCollection() {
        }

        public AddPartitionsToTxnTopicResultCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public AddPartitionsToTxnTopicResultCollection(Iterator<AddPartitionsToTxnTopicResult> iterator) {
            super(iterator);
        }

        @Override
        public AddPartitionsToTxnTopicResult find(String name) {
            AddPartitionsToTxnTopicResult key = new AddPartitionsToTxnTopicResult();
            key.setName(name);
            return this.find(key);
        }

        @Override
        public List<AddPartitionsToTxnTopicResult> findAll(String name) {
            AddPartitionsToTxnTopicResult key = new AddPartitionsToTxnTopicResult();
            key.setName(name);
            return this.findAll(key);
        }
    }

    public static class AddPartitionsToTxnPartitionResultCollection
    extends ImplicitLinkedHashMultiCollection<AddPartitionsToTxnPartitionResult> {
        public AddPartitionsToTxnPartitionResultCollection() {
        }

        public AddPartitionsToTxnPartitionResultCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public AddPartitionsToTxnPartitionResultCollection(Iterator<AddPartitionsToTxnPartitionResult> iterator) {
            super(iterator);
        }

        @Override
        public AddPartitionsToTxnPartitionResult find(int partitionIndex) {
            AddPartitionsToTxnPartitionResult key = new AddPartitionsToTxnPartitionResult();
            key.setPartitionIndex(partitionIndex);
            return this.find(key);
        }

        @Override
        public List<AddPartitionsToTxnPartitionResult> findAll(int partitionIndex) {
            AddPartitionsToTxnPartitionResult key = new AddPartitionsToTxnPartitionResult();
            key.setPartitionIndex(partitionIndex);
            return this.findAll(key);
        }
    }

    public static class AddPartitionsToTxnPartitionResult
    implements Message,
    ImplicitLinkedHashCollection.Element {
        private int partitionIndex;
        private short errorCode;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;

        public AddPartitionsToTxnPartitionResult(Readable readable, short version) {
            this.read(readable, version);
        }

        public AddPartitionsToTxnPartitionResult(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public AddPartitionsToTxnPartitionResult() {
            this.partitionIndex = 0;
            this.errorCode = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public void read(Readable readable, short version) {
            this.partitionIndex = readable.readInt();
            this.errorCode = readable.readShort();
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeInt(this.partitionIndex);
            writable.writeShort(this.errorCode);
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.partitionIndex = struct.getInt("partition_index");
            this.errorCode = struct.getShort("error_code");
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("partition_index", (Object)this.partitionIndex);
            struct.set("error_code", (Object)this.errorCode);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 4;
            return size += 2;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AddPartitionsToTxnPartitionResult)) {
                return false;
            }
            AddPartitionsToTxnPartitionResult other = (AddPartitionsToTxnPartitionResult)obj;
            return this.partitionIndex == other.partitionIndex;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            return hashCode;
        }

        public String toString() {
            return "AddPartitionsToTxnPartitionResult(partitionIndex=" + this.partitionIndex + ", errorCode=" + this.errorCode + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public short errorCode() {
            return this.errorCode;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        public AddPartitionsToTxnPartitionResult setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public AddPartitionsToTxnPartitionResult setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partition indexes."), new Field("error_code", Type.INT16, "The response error code."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }

    public static class AddPartitionsToTxnTopicResult
    implements Message,
    ImplicitLinkedHashCollection.Element {
        private String name;
        private AddPartitionsToTxnPartitionResultCollection results;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;

        public AddPartitionsToTxnTopicResult(Readable readable, short version) {
            this.results = new AddPartitionsToTxnPartitionResultCollection(0);
            this.read(readable, version);
        }

        public AddPartitionsToTxnTopicResult(Struct struct, short version) {
            this.results = new AddPartitionsToTxnPartitionResultCollection(0);
            this.fromStruct(struct, version);
        }

        public AddPartitionsToTxnTopicResult() {
            this.name = "";
            this.results = new AddPartitionsToTxnPartitionResultCollection(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public void read(Readable readable, short version) {
            this.name = readable.readNullableString();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.results = null;
            } else {
                this.results.clear(arrayLength);
                for (int i = 0; i < arrayLength; ++i) {
                    this.results.add(new AddPartitionsToTxnPartitionResult(readable, version));
                }
            }
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeString(this.name);
            writable.writeInt(this.results.size());
            for (AddPartitionsToTxnPartitionResult element : this.results) {
                element.write(writable, version);
            }
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.name = struct.getString("name");
            Object[] nestedObjects = struct.getArray("results");
            this.results = new AddPartitionsToTxnPartitionResultCollection(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.results.add(new AddPartitionsToTxnPartitionResult((Struct)nestedObject, version));
            }
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("name", (Object)this.name);
            Struct[] nestedObjects = new Struct[this.results.size()];
            int i = 0;
            for (AddPartitionsToTxnPartitionResult element : this.results) {
                nestedObjects[i++] = element.toStruct(version);
            }
            struct.set("results", (Object)nestedObjects);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.name);
            size += 4;
            for (AddPartitionsToTxnPartitionResult element : this.results) {
                size += element.size(version);
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AddPartitionsToTxnTopicResult)) {
                return false;
            }
            AddPartitionsToTxnTopicResult other = (AddPartitionsToTxnTopicResult)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        public String toString() {
            return "AddPartitionsToTxnTopicResult(name='" + this.name + "', results=" + MessageUtil.deepToString(this.results.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public AddPartitionsToTxnPartitionResultCollection results() {
            return this.results;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        public AddPartitionsToTxnTopicResult setName(String v) {
            this.name = v;
            return this;
        }

        public AddPartitionsToTxnTopicResult setResults(AddPartitionsToTxnPartitionResultCollection v) {
            this.results = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("results", new ArrayOf(AddPartitionsToTxnPartitionResult.SCHEMA_0), "The results for each partition"));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }
}

