/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.StickyAssignor;
import org.apache.kafka.clients.consumer.internals.PartitionAssignor;
import org.apache.kafka.clients.consumer.internals.PartitionAssignorAdapter;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.junit.Assert;
import org.junit.Test;

public class PartitionAssignorAdapterTest {
    private List<String> classNames;
    private List<Object> classTypes;

    @Test
    public void shouldInstantiateNewAssignors() {
        this.classNames = Arrays.asList(StickyAssignor.class.getName());
        List assignors = PartitionAssignorAdapter.getAssignorInstances(this.classNames, Collections.emptyMap());
        Assert.assertTrue((boolean)StickyAssignor.class.isInstance(assignors.get(0)));
    }

    @Test
    public void shouldAdaptOldAssignors() {
        this.classNames = Arrays.asList(OldPartitionAssignor.class.getName());
        List assignors = PartitionAssignorAdapter.getAssignorInstances(this.classNames, Collections.emptyMap());
        Assert.assertTrue((boolean)PartitionAssignorAdapter.class.isInstance(assignors.get(0)));
    }

    @Test
    public void shouldThrowKafkaExceptionOnNonAssignor() {
        this.classNames = Arrays.asList(String.class.getName());
        Assert.assertThrows(KafkaException.class, () -> PartitionAssignorAdapter.getAssignorInstances(this.classNames, Collections.emptyMap()));
    }

    @Test
    public void shouldThrowKafkaExceptionOnAssignorNotFound() {
        this.classNames = Arrays.asList("Non-existent assignor");
        Assert.assertThrows(KafkaException.class, () -> PartitionAssignorAdapter.getAssignorInstances(this.classNames, Collections.emptyMap()));
    }

    @Test
    public void shouldInstantiateFromListOfOldAndNewClassTypes() {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", "localhost:9999");
        this.classTypes = Arrays.asList(StickyAssignor.class, OldPartitionAssignor.class);
        props.put("partition.assignment.strategy", this.classTypes);
        KafkaConsumer consumer = new KafkaConsumer(props, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
        consumer.close();
    }

    @Test
    public void shouldThrowKafkaExceptionOnListWithNonAssignorClassType() {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", "localhost:9999");
        this.classTypes = Arrays.asList(StickyAssignor.class, OldPartitionAssignor.class, String.class);
        props.put("partition.assignment.strategy", this.classTypes);
        Assert.assertThrows(KafkaException.class, () -> new KafkaConsumer(props, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer()));
    }

    @Test
    public void testOnAssignment() {
        OldPartitionAssignor oldAssignor = new OldPartitionAssignor();
        PartitionAssignorAdapter adaptedAssignor = new PartitionAssignorAdapter((PartitionAssignor)oldAssignor);
        TopicPartition tp1 = new TopicPartition("tp1", 1);
        TopicPartition tp2 = new TopicPartition("tp2", 2);
        List<TopicPartition> partitions = Arrays.asList(tp1, tp2);
        adaptedAssignor.onAssignment(new ConsumerPartitionAssignor.Assignment(partitions), new ConsumerGroupMetadata("", 1, "", Optional.empty()));
        Assert.assertEquals(oldAssignor.partitions, partitions);
    }

    @Test
    public void testAssign() {
        PartitionAssignorAdapter adaptedAssignor = new PartitionAssignorAdapter((PartitionAssignor)new OldPartitionAssignor());
        HashMap<String, ConsumerPartitionAssignor.Subscription> subscriptions = new HashMap<String, ConsumerPartitionAssignor.Subscription>();
        subscriptions.put("C1", new ConsumerPartitionAssignor.Subscription(Arrays.asList("topic1")));
        subscriptions.put("C2", new ConsumerPartitionAssignor.Subscription(Arrays.asList("topic1", "topic2")));
        subscriptions.put("C3", new ConsumerPartitionAssignor.Subscription(Arrays.asList("topic2", "topic3")));
        ConsumerPartitionAssignor.GroupSubscription groupSubscription = new ConsumerPartitionAssignor.GroupSubscription(subscriptions);
        Map assignments = adaptedAssignor.assign(null, groupSubscription).groupAssignment();
        Assert.assertEquals((Object)((ConsumerPartitionAssignor.Assignment)assignments.get("C1")).partitions(), Arrays.asList(new TopicPartition("topic1", 1)));
        Assert.assertEquals((Object)((ConsumerPartitionAssignor.Assignment)assignments.get("C2")).partitions(), Arrays.asList(new TopicPartition("topic1", 1), new TopicPartition("topic2", 1)));
        Assert.assertEquals((Object)((ConsumerPartitionAssignor.Assignment)assignments.get("C3")).partitions(), Arrays.asList(new TopicPartition("topic2", 1), new TopicPartition("topic3", 1)));
    }

    public static class OldPartitionAssignor
    implements PartitionAssignor {
        List<TopicPartition> partitions = null;

        public PartitionAssignor.Subscription subscription(Set<String> topics) {
            return new PartitionAssignor.Subscription(new ArrayList<String>(topics), null);
        }

        public Map<String, PartitionAssignor.Assignment> assign(Cluster metadata, Map<String, PartitionAssignor.Subscription> subscriptions) {
            HashMap<String, PartitionAssignor.Assignment> assignments = new HashMap<String, PartitionAssignor.Assignment>();
            for (Map.Entry<String, PartitionAssignor.Subscription> entry : subscriptions.entrySet()) {
                ArrayList<TopicPartition> partitions = new ArrayList<TopicPartition>();
                for (String topic : entry.getValue().topics()) {
                    partitions.add(new TopicPartition(topic, 1));
                }
                assignments.put(entry.getKey(), new PartitionAssignor.Assignment(partitions, null));
            }
            return assignments;
        }

        public void onAssignment(PartitionAssignor.Assignment assignment) {
            this.partitions = assignment.partitions();
        }

        public String name() {
            return "old-assignor";
        }
    }
}

