/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.clients.consumer.internals.DefaultEventHandler;
import org.apache.kafka.clients.consumer.internals.NoOpConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.internals.PrototypeAsyncConsumer;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.clients.consumer.internals.events.EventHandler;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.internals.ClusterResourceListeners;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class PrototypeAsyncConsumerTest {
    private Map<String, Object> properties;
    private SubscriptionState subscriptionState;
    private MockTime time;
    private LogContext logContext;
    private Metrics metrics;
    private ClusterResourceListeners clusterResourceListeners;
    private Optional<String> groupId;
    private String clientId;
    private EventHandler eventHandler;

    @BeforeEach
    public void setup() {
        this.subscriptionState = (SubscriptionState)Mockito.mock(SubscriptionState.class);
        this.eventHandler = (EventHandler)Mockito.mock(DefaultEventHandler.class);
        this.logContext = new LogContext();
        this.time = new MockTime();
        this.metrics = new Metrics((Time)this.time);
        this.groupId = Optional.empty();
        this.clientId = "client-1";
        this.clusterResourceListeners = new ClusterResourceListeners();
        this.properties = new HashMap<String, Object>();
        this.properties.put("bootstrap.servers", "localhost:9999");
        this.properties.put("key.deserializer", StringDeserializer.class);
        this.properties.put("value.deserializer", StringDeserializer.class);
        this.properties.put("client.id", "test-client");
    }

    @Test
    public void testSubscription() {
        this.subscriptionState = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
        PrototypeAsyncConsumer<String, String> consumer = this.setupConsumerWithDefault();
        this.subscriptionState.subscribe(Collections.singleton("t1"), (ConsumerRebalanceListener)new NoOpConsumerRebalanceListener());
        Assertions.assertEquals((int)1, (int)consumer.subscription().size());
    }

    @Test
    public void testUnimplementedException() {
        PrototypeAsyncConsumer<String, String> consumer = this.setupConsumerWithDefault();
        Assertions.assertThrows(KafkaException.class, () -> consumer.assignment(), (String)"not implemented exception");
    }

    public PrototypeAsyncConsumer<String, String> setupConsumerWithDefault() {
        ConsumerConfig config = new ConsumerConfig(this.properties);
        return new PrototypeAsyncConsumer((Time)this.time, this.logContext, config, this.subscriptionState, this.eventHandler, this.metrics, this.clusterResourceListeners, this.groupId, this.clientId, 0);
    }
}

