/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class AccessControlRecord
implements ApiMessage {
    byte resourceType;
    String resourceName;
    byte patternType;
    String principal;
    String host;
    byte operation;
    byte permissionType;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("resource_type", (Type)Type.INT8, "The resource type"), new Field("resource_name", (Type)Type.COMPACT_NULLABLE_STRING, "The resource name, or null if this is for the default resource."), new Field("pattern_type", (Type)Type.INT8, "The pattern type (literal, prefixed, etc.)"), new Field("principal", (Type)Type.COMPACT_STRING, "The principal name."), new Field("host", (Type)Type.COMPACT_STRING, "The host."), new Field("operation", (Type)Type.INT8, "The operation type."), new Field("permission_type", (Type)Type.INT8, "The permission type (allow, deny)."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public AccessControlRecord(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public AccessControlRecord() {
        this.resourceType = 0;
        this.resourceName = "";
        this.patternType = 0;
        this.principal = "";
        this.host = "";
        this.operation = 0;
        this.permissionType = 0;
    }

    public short apiKey() {
        return 6;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public void read(Readable _readable, short _version) {
        this.resourceType = _readable.readByte();
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.resourceName = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field resourceName had invalid length " + length);
            }
            this.resourceName = _readable.readString(length);
        }
        this.patternType = _readable.readByte();
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field principal was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field principal had invalid length " + length);
        }
        this.principal = _readable.readString(length);
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field host was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field host had invalid length " + length);
        }
        this.host = _readable.readString(length);
        this.operation = _readable.readByte();
        this.permissionType = _readable.readByte();
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        byte[] _stringBytes;
        int _numTaggedFields = 0;
        _writable.writeByte(this.resourceType);
        if (this.resourceName == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue((Object)this.resourceName);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        _writable.writeByte(this.patternType);
        _stringBytes = _cache.getSerializedValue((Object)this.principal);
        _writable.writeUnsignedVarint(_stringBytes.length + 1);
        _writable.writeByteArray(_stringBytes);
        _stringBytes = _cache.getSerializedValue((Object)this.host);
        _writable.writeUnsignedVarint(_stringBytes.length + 1);
        _writable.writeByteArray(_stringBytes);
        _writable.writeByte(this.operation);
        _writable.writeByte(this.permissionType);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        byte[] _stringBytes;
        int _numTaggedFields = 0;
        _size.addBytes(1);
        if (this.resourceName == null) {
            _size.addBytes(1);
        } else {
            _stringBytes = this.resourceName.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'resourceName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.resourceName, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        }
        _size.addBytes(1);
        _stringBytes = this.principal.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'principal' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.principal, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        _stringBytes = this.host.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'host' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.host, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        _size.addBytes(1);
        _size.addBytes(1);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AccessControlRecord)) {
            return false;
        }
        AccessControlRecord other = (AccessControlRecord)obj;
        if (this.resourceType != other.resourceType) {
            return false;
        }
        if (this.resourceName == null ? other.resourceName != null : !this.resourceName.equals(other.resourceName)) {
            return false;
        }
        if (this.patternType != other.patternType) {
            return false;
        }
        if (this.principal == null ? other.principal != null : !this.principal.equals(other.principal)) {
            return false;
        }
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.operation != other.operation) {
            return false;
        }
        if (this.permissionType != other.permissionType) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.resourceType;
        hashCode = 31 * hashCode + (this.resourceName == null ? 0 : this.resourceName.hashCode());
        hashCode = 31 * hashCode + this.patternType;
        hashCode = 31 * hashCode + (this.principal == null ? 0 : this.principal.hashCode());
        hashCode = 31 * hashCode + (this.host == null ? 0 : this.host.hashCode());
        hashCode = 31 * hashCode + this.operation;
        hashCode = 31 * hashCode + this.permissionType;
        return hashCode;
    }

    public AccessControlRecord duplicate() {
        AccessControlRecord _duplicate = new AccessControlRecord();
        _duplicate.resourceType = this.resourceType;
        _duplicate.resourceName = this.resourceName == null ? null : this.resourceName;
        _duplicate.patternType = this.patternType;
        _duplicate.principal = this.principal;
        _duplicate.host = this.host;
        _duplicate.operation = this.operation;
        _duplicate.permissionType = this.permissionType;
        return _duplicate;
    }

    public String toString() {
        return "AccessControlRecord(resourceType=" + this.resourceType + ", resourceName=" + (this.resourceName == null ? "null" : "'" + this.resourceName.toString() + "'") + ", patternType=" + this.patternType + ", principal=" + (this.principal == null ? "null" : "'" + this.principal.toString() + "'") + ", host=" + (this.host == null ? "null" : "'" + this.host.toString() + "'") + ", operation=" + this.operation + ", permissionType=" + this.permissionType + ")";
    }

    public byte resourceType() {
        return this.resourceType;
    }

    public String resourceName() {
        return this.resourceName;
    }

    public byte patternType() {
        return this.patternType;
    }

    public String principal() {
        return this.principal;
    }

    public String host() {
        return this.host;
    }

    public byte operation() {
        return this.operation;
    }

    public byte permissionType() {
        return this.permissionType;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public AccessControlRecord setResourceType(byte v) {
        this.resourceType = v;
        return this;
    }

    public AccessControlRecord setResourceName(String v) {
        this.resourceName = v;
        return this;
    }

    public AccessControlRecord setPatternType(byte v) {
        this.patternType = v;
        return this;
    }

    public AccessControlRecord setPrincipal(String v) {
        this.principal = v;
        return this;
    }

    public AccessControlRecord setHost(String v) {
        this.host = v;
        return this;
    }

    public AccessControlRecord setOperation(byte v) {
        this.operation = v;
        return this;
    }

    public AccessControlRecord setPermissionType(byte v) {
        this.permissionType = v;
        return this;
    }
}

