/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import org.apache.kafka.streams.kstream.ForeachAction;
import org.apache.kafka.streams.kstream.KeyValueMapper;

public class PrintForeachAction<K, V>
implements ForeachAction<K, V> {
    private final String label;
    private final PrintWriter printWriter;
    private final boolean closable;
    private final KeyValueMapper<? super K, ? super V, String> mapper;

    PrintForeachAction(OutputStream outputStream, KeyValueMapper<? super K, ? super V, String> mapper, String label) {
        this.printWriter = new PrintWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
        this.closable = outputStream != System.out && outputStream != System.err;
        this.mapper = mapper;
        this.label = label;
    }

    @Override
    public void apply(K key, V value) {
        String data = String.format("[%s]: %s", this.label, this.mapper.apply(key, value));
        this.printWriter.println(data);
    }

    public void close() {
        if (this.closable) {
            this.printWriter.close();
        } else {
            this.printWriter.flush();
        }
    }
}

