/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.internals.NextIteratorFunction;

class CompositeKeyValueIterator<K, V, StoreType>
implements KeyValueIterator<K, V> {
    private final Iterator<StoreType> storeIterator;
    private final NextIteratorFunction<K, V, StoreType> nextIteratorFunction;
    private KeyValueIterator<K, V> current;

    CompositeKeyValueIterator(Iterator<StoreType> underlying, NextIteratorFunction<K, V, StoreType> nextIteratorFunction) {
        this.storeIterator = underlying;
        this.nextIteratorFunction = nextIteratorFunction;
    }

    @Override
    public void close() {
        if (this.current != null) {
            this.current.close();
            this.current = null;
        }
    }

    @Override
    public K peekNextKey() {
        throw new UnsupportedOperationException("peekNextKey not supported");
    }

    @Override
    public boolean hasNext() {
        while ((this.current == null || !this.current.hasNext()) && this.storeIterator.hasNext()) {
            this.close();
            this.current = this.nextIteratorFunction.apply(this.storeIterator.next());
        }
        return this.current != null && this.current.hasNext();
    }

    @Override
    public KeyValue<K, V> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return (KeyValue)this.current.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove not supported");
    }
}

