/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.internals.HasNextCondition;
import org.apache.kafka.streams.state.internals.Segment;

class SegmentIterator
implements KeyValueIterator<Bytes, byte[]> {
    private final Bytes from;
    private final Bytes to;
    protected final Iterator<Segment> segments;
    protected final HasNextCondition hasNextCondition;
    protected KeyValueStore<Bytes, byte[]> currentSegment;
    protected KeyValueIterator<Bytes, byte[]> currentIterator;

    SegmentIterator(Iterator<Segment> segments, HasNextCondition hasNextCondition, Bytes from, Bytes to) {
        this.segments = segments;
        this.hasNextCondition = hasNextCondition;
        this.from = from;
        this.to = to;
    }

    @Override
    public void close() {
        if (this.currentIterator != null) {
            this.currentIterator.close();
            this.currentIterator = null;
        }
    }

    @Override
    public Bytes peekNextKey() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.currentIterator.peekNextKey();
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = false;
        while (!(this.currentIterator != null && (hasNext = this.hasNextConditionHasNext()) && this.currentSegment.isOpen() || !this.segments.hasNext())) {
            this.close();
            this.currentSegment = this.segments.next();
            try {
                if (this.from == null || this.to == null) {
                    this.currentIterator = this.currentSegment.all();
                    continue;
                }
                this.currentIterator = this.currentSegment.range(this.from, this.to);
            }
            catch (InvalidStateStoreException invalidStateStoreException) {}
        }
        return this.currentIterator != null && hasNext;
    }

    private boolean hasNextConditionHasNext() {
        boolean hasNext = false;
        try {
            hasNext = this.hasNextCondition.hasNext(this.currentIterator);
        }
        catch (InvalidStateStoreException invalidStateStoreException) {
            // empty catch block
        }
        return hasNext;
    }

    @Override
    public KeyValue<Bytes, byte[]> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return (KeyValue)this.currentIterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() is not supported in " + this.getClass().getName());
    }
}

