/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.agent;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.trogdor.agent.AgentRestResource;
import org.apache.kafka.trogdor.common.Node;
import org.apache.kafka.trogdor.common.Platform;
import org.apache.kafka.trogdor.fault.Fault;
import org.apache.kafka.trogdor.fault.FaultSet;
import org.apache.kafka.trogdor.fault.FaultSpec;
import org.apache.kafka.trogdor.fault.RunningState;
import org.apache.kafka.trogdor.rest.AgentFaultsResponse;
import org.apache.kafka.trogdor.rest.CreateAgentFaultRequest;
import org.apache.kafka.trogdor.rest.FaultDataMap;
import org.apache.kafka.trogdor.rest.JsonRestServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Agent {
    private static final Logger log = LoggerFactory.getLogger(Agent.class);
    private final Time time;
    private final long startTimeMs;
    private final Platform platform;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition cond = this.lock.newCondition();
    private final AgentRunnable runnable;
    private final JsonRestServer restServer;
    private final KafkaThread thread;
    private final FaultSet pendingFaults = new FaultSet();
    private final FaultSet runningFaults = new FaultSet();
    private final FaultSet doneFaults = new FaultSet();
    private boolean shutdown = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deactivateRunningFaults() {
        long now = this.time.milliseconds();
        int numDeactivated = 0;
        this.lock.lock();
        try {
            FaultSet.FaultSetIterator iter = this.runningFaults.iterateByStart();
            while (iter.hasNext()) {
                Fault fault = (Fault)iter.next();
                try {
                    ++numDeactivated;
                    iter.remove();
                    fault.deactivate(now, this.platform);
                }
                catch (Exception e) {
                    log.error("Got exception while deactivating {}", (Object)fault, (Object)e);
                }
                finally {
                    this.doneFaults.add(fault);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return numDeactivated;
    }

    public Agent(Platform platform, Time time, JsonRestServer restServer, AgentRestResource resource) {
        this.platform = platform;
        this.time = time;
        this.restServer = restServer;
        this.startTimeMs = time.milliseconds();
        this.runnable = new AgentRunnable();
        this.thread = new KafkaThread("TrogdorAgentThread", (Runnable)this.runnable, false);
        this.thread.start();
        resource.setAgent(this);
    }

    public int port() {
        return this.restServer.port();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginShutdown() {
        this.lock.lock();
        try {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
            this.cond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void waitForShutdown() {
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            log.error("Interrupted while waiting for thread shutdown", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public long startTimeMs() {
        return this.startTimeMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentFaultsResponse faults() {
        TreeMap<String, FaultDataMap.FaultData> faultData = new TreeMap<String, FaultDataMap.FaultData>();
        this.lock.lock();
        try {
            this.updateFaultsResponse(faultData, this.pendingFaults);
            this.updateFaultsResponse(faultData, this.runningFaults);
            this.updateFaultsResponse(faultData, this.doneFaults);
        }
        finally {
            this.lock.unlock();
        }
        return new AgentFaultsResponse(faultData);
    }

    private void updateFaultsResponse(Map<String, FaultDataMap.FaultData> faultData, FaultSet faultSet) {
        FaultSet.FaultSetIterator iter = faultSet.iterateByStart();
        while (iter.hasNext()) {
            Fault fault = (Fault)iter.next();
            FaultDataMap.FaultData data = new FaultDataMap.FaultData(fault.spec(), fault.state());
            faultData.put(fault.id(), data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createFault(CreateAgentFaultRequest request) throws ClassNotFoundException {
        this.lock.lock();
        try {
            Fault fault = FaultSpec.Util.createFault(request.id(), request.spec());
            this.pendingFaults.add(fault);
            this.cond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public static void main(String[] args) throws Exception {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"trogdor-agent").defaultHelp(true).description("The Trogdor fault injection agent");
        parser.addArgument(new String[]{"--agent.config"}).action((ArgumentAction)Arguments.store()).required(true).type(String.class).dest("config").metavar(new String[]{"CONFIG"}).help("The configuration file to use.");
        parser.addArgument(new String[]{"--node-name"}).action((ArgumentAction)Arguments.store()).required(true).type(String.class).dest("node_name").metavar(new String[]{"NODE_NAME"}).help("The name of this node.");
        Namespace res = null;
        try {
            res = parser.parseArgs(args);
        }
        catch (ArgumentParserException e) {
            if (args.length == 0) {
                parser.printHelp();
                Exit.exit((int)0);
            }
            parser.handleError(e);
            Exit.exit((int)1);
        }
        String configPath = res.getString("config");
        String nodeName = res.getString("node_name");
        Platform platform = Platform.Config.parse(nodeName, configPath);
        JsonRestServer restServer = new JsonRestServer(Node.Util.getTrogdorAgentPort(platform.curNode()));
        AgentRestResource resource = new AgentRestResource();
        final Agent agent = new Agent(platform, Time.SYSTEM, restServer, resource);
        restServer.start(resource);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                log.error("Running shutdown hook...");
                agent.beginShutdown();
                agent.waitForShutdown();
            }
        });
        agent.waitForShutdown();
    }

    static /* synthetic */ Time access$100(Agent x0) {
        return x0.time;
    }

    static /* synthetic */ ReentrantLock access$200(Agent x0) {
        return x0.lock;
    }

    static /* synthetic */ FaultSet access$300(Agent x0) {
        return x0.pendingFaults;
    }

    static /* synthetic */ FaultSet access$400(Agent x0) {
        return x0.runningFaults;
    }

    static /* synthetic */ Platform access$500(Agent x0) {
        return x0.platform;
    }

    static /* synthetic */ FaultSet access$600(Agent x0) {
        return x0.doneFaults;
    }

    static /* synthetic */ boolean access$700(Agent x0) {
        return x0.shutdown;
    }

    static /* synthetic */ Condition access$800(Agent x0) {
        return x0.cond;
    }

    static /* synthetic */ JsonRestServer access$900(Agent x0) {
        return x0.restServer;
    }

    static /* synthetic */ int access$1000(Agent x0) {
        return x0.deactivateRunningFaults();
    }

    class AgentRunnable
    implements Runnable {
        AgentRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            Agent.access$000().info("Starting main service thread.");
            try {
                while (true) {
                    toStart = new ArrayList<Fault>();
                    started = new ArrayList<Fault>();
                    toEnd = new ArrayList<Fault>();
                    ended = new ArrayList<Fault>();
                    now = Agent.access$100(Agent.this).milliseconds();
                    nextWakeMs = now + 3600000L;
                    Agent.access$200(Agent.this).lock();
                    try {
                        pending = Agent.access$300(Agent.this).iterateByStart();
                        while (pending.hasNext()) {
                            fault = (Fault)pending.next();
                            toStart.add(fault);
                            endMs = fault.spec().startMs() + fault.spec().durationMs();
                            nextWakeMs = Math.min(nextWakeMs, endMs);
                            pending.remove();
                        }
                        running = Agent.access$400(Agent.this).iterateByEnd();
                        while (running.hasNext()) {
                            fault = (Fault)running.next();
                            state = (RunningState)fault.state();
                            endMs = state.startedMs() + fault.spec().durationMs();
                            if (now < endMs) {
                                nextWakeMs = Math.min(nextWakeMs, endMs);
                                break;
                            }
                            toEnd.add(fault);
                            running.remove();
                        }
                    }
                    finally {
                        Agent.access$200(Agent.this).unlock();
                    }
                    for (Fault fault : toStart) {
                        try {
                            Agent.access$000().debug("Activating fault " + fault);
                            fault.activate(now, Agent.access$500(Agent.this));
                            started.add(fault);
                        }
                        catch (Throwable e) {
                            Agent.access$000().error("Error activating fault " + fault.id(), e);
                            ended.add(fault);
                        }
                    }
                    for (Fault fault : toEnd) {
                        try {
                            Agent.access$000().debug("Deactivating fault " + fault);
                            fault.deactivate(now, Agent.access$500(Agent.this));
                        }
                        catch (Throwable e) {
                            Agent.access$000().error("Error deactivating fault " + fault.id(), e);
                        }
                        finally {
                            ended.add(fault);
                        }
                    }
                    Agent.access$200(Agent.this).lock();
                    for (Fault fault : started) {
                        Agent.access$400(Agent.this).add(fault);
                    }
                    for (Fault fault : ended) {
                        Agent.access$600(Agent.this).add(fault);
                    }
                    if (!Agent.access$700(Agent.this)) ** break block31
                    Agent.access$200(Agent.this).unlock();
                    return;
                    break;
                }
                {
                    catch (Throwable var17_21) {
                        Agent.access$200(Agent.this).unlock();
                        throw var17_21;
                    }
                }
                {
                    block32: {
                        if (nextWakeMs > now) {
                            Agent.access$000().trace("Sleeping for {} ms", (Object)(nextWakeMs - now));
                            if (Agent.access$800(Agent.this).await(nextWakeMs - now, TimeUnit.MILLISECONDS)) {
                                Agent.access$000().trace("AgentRunnable woke up early");
                            }
                        }
                        if (!Agent.access$700(Agent.this)) break block32;
                        Agent.access$200(Agent.this).unlock();
                        return;
                    }
                    Agent.access$200(Agent.this).unlock();
                    continue;
                }
                catch (Throwable t) {
                    Agent.access$000().error("Unhandled exception in AgentRunnable", t);
                }
            }
            finally {
                Agent.access$000().info("AgentRunnable shutting down.");
                Agent.access$900(Agent.this).stop();
                numDeactivated = Agent.access$1000(Agent.this);
                Agent.access$000().info("AgentRunnable deactivated {} fault(s).", (Object)numDeactivated);
            }
        }
    }
}

