/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.fault;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.apache.kafka.trogdor.fault.Fault;

public class FaultSet {
    private static final long NS_PER_MS = 1000000L;
    private final TreeMap<Long, Fault> byStart = new TreeMap();
    private final TreeMap<Long, Fault> byEnd = new TreeMap();

    public FaultSetIterator iterateByStart() {
        return new FaultSetIterator(this.byStart);
    }

    public FaultSetIterator iterateByEnd() {
        return new FaultSetIterator(this.byEnd);
    }

    public void add(Fault fault) {
        this.insertUnique(this.byStart, fault.spec().startMs() * 1000000L, fault);
        long endMs = fault.spec().startMs() + fault.spec().durationMs();
        this.insertUnique(this.byEnd, endMs * 1000000L, fault);
    }

    private void insertUnique(TreeMap<Long, Fault> map, long key, Fault fault) {
        while (true) {
            Fault existing;
            if ((existing = map.get(key)) == null) {
                map.put(key, fault);
                return;
            }
            if (existing == fault) {
                return;
            }
            ++key;
        }
    }

    public void remove(Fault fault) {
        this.removeUnique(this.byStart, fault.spec().startMs() * 1000000L, fault);
        long endMs = fault.spec().startMs() + fault.spec().durationMs();
        this.removeUnique(this.byEnd, endMs * 1000000L, fault);
    }

    private void removeUnique(TreeMap<Long, Fault> map, long key, Fault fault) {
        while (true) {
            Map.Entry<Long, Fault> existing;
            if ((existing = map.ceilingEntry(key)) == null) {
                throw new NoSuchElementException("No such element as " + fault);
            }
            if (existing.getValue() == fault) {
                map.remove(existing.getKey());
                return;
            }
            key = existing.getKey() + 1L;
        }
    }

    class FaultSetIterator
    implements Iterator<Fault> {
        private final TreeMap<Long, Fault> map;
        private Fault cur = null;
        private long prevKey = -1L;

        FaultSetIterator(TreeMap<Long, Fault> map) {
            this.map = map;
        }

        @Override
        public boolean hasNext() {
            Map.Entry<Long, Fault> entry = this.map.higherEntry(this.prevKey);
            return entry != null;
        }

        @Override
        public Fault next() {
            Map.Entry<Long, Fault> entry = this.map.higherEntry(this.prevKey);
            if (entry == null) {
                throw new NoSuchElementException();
            }
            this.prevKey = entry.getKey();
            this.cur = entry.getValue();
            return this.cur;
        }

        @Override
        public void remove() {
            if (this.cur == null) {
                throw new IllegalStateException();
            }
            FaultSet.this.remove(this.cur);
            this.cur = null;
        }
    }
}

