/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.fault;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.trogdor.fault.Fault;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="class")
public interface FaultSpec {
    @JsonProperty
    public long startMs();

    @JsonProperty
    public long durationMs();

    public static class Util {
        private static final String SPEC_STRING = "Spec";

        public static Fault createFault(String faultId, FaultSpec faultSpec) throws ClassNotFoundException {
            String faultSpecClassName = faultSpec.getClass().getName();
            if (!faultSpecClassName.endsWith(SPEC_STRING)) {
                throw new RuntimeException("FaultSpec class name must end with Spec");
            }
            String faultClassName = faultSpecClassName.substring(0, faultSpecClassName.length() - SPEC_STRING.length());
            return (Fault)Utils.newParameterizedInstance((String)faultClassName, (Object[])new Object[]{String.class, faultId, FaultSpec.class, faultSpec});
        }
    }
}

