/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.fault;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.kafka.trogdor.common.Node;
import org.apache.kafka.trogdor.common.Platform;
import org.apache.kafka.trogdor.common.Topology;
import org.apache.kafka.trogdor.fault.AbstractFault;
import org.apache.kafka.trogdor.fault.FaultSpec;
import org.apache.kafka.trogdor.fault.NetworkPartitionFaultSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkPartitionFault
extends AbstractFault {
    private static final Logger log = LoggerFactory.getLogger(NetworkPartitionFault.class);
    private final List<Set<String>> partitions;

    public NetworkPartitionFault(String id, FaultSpec spec) {
        super(id, spec);
        NetworkPartitionFaultSpec faultSpec = (NetworkPartitionFaultSpec)spec;
        this.partitions = new ArrayList<Set<String>>();
        HashSet<String> prevNodes = new HashSet<String>();
        for (List<String> partition : faultSpec.partitions()) {
            for (String nodeName : partition) {
                if (prevNodes.contains(nodeName)) {
                    throw new RuntimeException("Node " + nodeName + " appears in more than one partition.");
                }
                prevNodes.add(nodeName);
                this.partitions.add(new HashSet<String>(partition));
            }
        }
    }

    @Override
    protected void handleActivation(long now, Platform platform) throws Exception {
        log.info("Activating NetworkPartitionFault...");
        this.runIptablesCommands(platform, "-A");
    }

    @Override
    protected void handleDeactivation(long now, Platform platform) throws Exception {
        log.info("Deactivating NetworkPartitionFault...");
        this.runIptablesCommands(platform, "-D");
    }

    private void runIptablesCommands(Platform platform, String iptablesAction) throws Exception {
        Node curNode = platform.curNode();
        Topology topology = platform.topology();
        TreeSet<String> toBlock = new TreeSet<String>();
        for (Set<String> partition : this.partitions) {
            if (partition.contains(curNode.name())) continue;
            for (String nodeName : partition) {
                toBlock.add(nodeName);
            }
        }
        for (String nodeName : toBlock) {
            Node node = topology.node(nodeName);
            InetAddress addr = InetAddress.getByName(node.hostname());
            platform.runCommand(new String[]{"sudo", "iptables", iptablesAction, "INPUT", "-p", "tcp", "-s", addr.getHostAddress(), "-j", "DROP", "-m", "comment", "--comment", nodeName});
        }
    }

    @Override
    public Set<String> targetNodes(Topology topology) {
        HashSet<String> targetNodes = new HashSet<String>();
        for (Set<String> partition : this.partitions) {
            targetNodes.addAll(partition);
        }
        return targetNodes;
    }
}

