/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.trogdor.common.JsonUtil;
import org.apache.kafka.trogdor.fault.FaultSpec;
import org.apache.kafka.trogdor.fault.FaultState;

public class FaultDataMap {
    private final Map<String, FaultData> faults;

    @JsonCreator
    public FaultDataMap(@JsonProperty(value="faults") Map<String, FaultData> faults) {
        this.faults = faults;
    }

    @JsonProperty
    public Map<String, FaultData> faults() {
        return this.faults;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FaultDataMap that = (FaultDataMap)o;
        return Objects.equals(this.faults, that.faults);
    }

    public int hashCode() {
        return Objects.hashCode(this.faults);
    }

    public String toString() {
        return JsonUtil.toJsonString(this);
    }

    public static class FaultData {
        private final FaultSpec spec;
        private final FaultState state;

        @JsonCreator
        public FaultData(@JsonProperty(value="spec") FaultSpec spec, @JsonProperty(value="state") FaultState state) {
            this.spec = spec;
            this.state = state;
        }

        @JsonProperty
        public FaultSpec spec() {
            return this.spec;
        }

        @JsonProperty
        public FaultState state() {
            return this.state;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FaultData that = (FaultData)o;
            return Objects.equals(this.spec, that.spec) && Objects.equals(this.state, that.state);
        }

        public int hashCode() {
            return Objects.hash(this.spec, this.state);
        }
    }
}

