/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.coordinator;

import com.fasterxml.jackson.core.type.TypeReference;
import javax.ws.rs.core.UriBuilder;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.trogdor.common.JsonUtil;
import org.apache.kafka.trogdor.rest.CoordinatorStatusResponse;
import org.apache.kafka.trogdor.rest.CreateTaskRequest;
import org.apache.kafka.trogdor.rest.DestroyTaskRequest;
import org.apache.kafka.trogdor.rest.Empty;
import org.apache.kafka.trogdor.rest.JsonRestServer;
import org.apache.kafka.trogdor.rest.StopTaskRequest;
import org.apache.kafka.trogdor.rest.TasksRequest;
import org.apache.kafka.trogdor.rest.TasksResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordinatorClient {
    private final Logger log;
    private final int maxTries;
    private final String target;

    private CoordinatorClient(Logger log, int maxTries, String target) {
        this.log = log;
        this.maxTries = maxTries;
        this.target = target;
    }

    public int maxTries() {
        return this.maxTries;
    }

    private String url(String suffix) {
        return String.format("http://%s%s", this.target, suffix);
    }

    public CoordinatorStatusResponse status() throws Exception {
        JsonRestServer.HttpResponse<CoordinatorStatusResponse> resp = JsonRestServer.httpRequest(this.url("/coordinator/status"), "GET", null, new TypeReference<CoordinatorStatusResponse>(){}, this.maxTries);
        return resp.body();
    }

    public void createTask(CreateTaskRequest request) throws Exception {
        JsonRestServer.HttpResponse<Empty> resp = JsonRestServer.httpRequest(this.log, this.url("/coordinator/task/create"), "POST", request, new TypeReference<Empty>(){}, this.maxTries);
        resp.body();
    }

    public void stopTask(StopTaskRequest request) throws Exception {
        JsonRestServer.HttpResponse<Empty> resp = JsonRestServer.httpRequest(this.log, this.url("/coordinator/task/stop"), "PUT", request, new TypeReference<Empty>(){}, this.maxTries);
        resp.body();
    }

    public void destroyTask(DestroyTaskRequest request) throws Exception {
        UriBuilder uriBuilder = UriBuilder.fromPath((String)this.url("/coordinator/tasks"));
        uriBuilder.queryParam("taskId", new Object[]{request.id()});
        JsonRestServer.HttpResponse<Empty> resp = JsonRestServer.httpRequest(this.log, uriBuilder.build(new Object[0]).toString(), "DELETE", null, new TypeReference<Empty>(){}, this.maxTries);
        resp.body();
    }

    public TasksResponse tasks(TasksRequest request) throws Exception {
        UriBuilder uriBuilder = UriBuilder.fromPath((String)this.url("/coordinator/tasks"));
        uriBuilder.queryParam("taskId", (Object[])request.taskIds().toArray(new String[0]));
        uriBuilder.queryParam("firstStartMs", new Object[]{request.firstStartMs()});
        uriBuilder.queryParam("lastStartMs", new Object[]{request.lastStartMs()});
        uriBuilder.queryParam("firstEndMs", new Object[]{request.firstEndMs()});
        uriBuilder.queryParam("lastEndMs", new Object[]{request.lastEndMs()});
        JsonRestServer.HttpResponse<TasksResponse> resp = JsonRestServer.httpRequest(this.log, uriBuilder.build(new Object[0]).toString(), "GET", null, new TypeReference<TasksResponse>(){}, this.maxTries);
        return resp.body();
    }

    public void shutdown() throws Exception {
        JsonRestServer.HttpResponse<Empty> resp = JsonRestServer.httpRequest(this.log, this.url("/coordinator/shutdown"), "PUT", null, new TypeReference<Empty>(){}, this.maxTries);
        resp.body();
    }

    public static void main(String[] args) throws Exception {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"trogdor-coordinator-client").defaultHelp(true).description("The Trogdor fault injection coordinator client.");
        parser.addArgument(new String[]{"target"}).action((ArgumentAction)Arguments.store()).required(true).type(String.class).dest("target").metavar(new String[]{"TARGET"}).help("A colon-separated host and port pair.  For example, example.com:8889");
        MutuallyExclusiveGroup actions = parser.addMutuallyExclusiveGroup();
        actions.addArgument(new String[]{"--status"}).action((ArgumentAction)Arguments.storeTrue()).type(Boolean.class).dest("status").help("Get coordinator status.");
        actions.addArgument(new String[]{"--show-tasks"}).action((ArgumentAction)Arguments.storeTrue()).type(Boolean.class).dest("show_tasks").help("Show coordinator tasks.");
        actions.addArgument(new String[]{"--create-task"}).action((ArgumentAction)Arguments.store()).type(String.class).dest("create_task").metavar(new String[]{"TASK_SPEC_JSON"}).help("Create a new task from a task spec.");
        actions.addArgument(new String[]{"--stop-task"}).action((ArgumentAction)Arguments.store()).type(String.class).dest("stop_task").metavar(new String[]{"TASK_ID"}).help("Stop a task.");
        actions.addArgument(new String[]{"--destroy-task"}).action((ArgumentAction)Arguments.store()).type(String.class).dest("destroy_task").metavar(new String[]{"TASK_ID"}).help("Destroy a task.");
        actions.addArgument(new String[]{"--shutdown"}).action((ArgumentAction)Arguments.storeTrue()).type(Boolean.class).dest("shutdown").help("Trigger coordinator shutdown");
        Namespace res = null;
        try {
            res = parser.parseArgs(args);
        }
        catch (ArgumentParserException e) {
            if (args.length == 0) {
                parser.printHelp();
                Exit.exit((int)0);
            }
            parser.handleError(e);
            Exit.exit((int)1);
        }
        String target = res.getString("target");
        CoordinatorClient client = new Builder().maxTries(3).target(target).build();
        if (res.getBoolean("status").booleanValue()) {
            System.out.println("Got coordinator status: " + JsonUtil.toPrettyJsonString(client.status()));
        } else if (res.getBoolean("show_tasks").booleanValue()) {
            System.out.println("Got coordinator tasks: " + JsonUtil.toPrettyJsonString(client.tasks(new TasksRequest(null, 0L, 0L, 0L, 0L))));
        } else if (res.getString("create_task") != null) {
            CreateTaskRequest req = (CreateTaskRequest)JsonUtil.JSON_SERDE.readValue(res.getString("create_task"), CreateTaskRequest.class);
            client.createTask(req);
            System.out.printf("Sent CreateTaskRequest for task %s.", req.id());
        } else if (res.getString("stop_task") != null) {
            String taskId = res.getString("stop_task");
            client.stopTask(new StopTaskRequest(taskId));
            System.out.printf("Sent StopTaskRequest for task %s.%n", taskId);
        } else if (res.getString("destroy_task") != null) {
            String taskId = res.getString("destroy_task");
            client.destroyTask(new DestroyTaskRequest(taskId));
            System.out.printf("Sent DestroyTaskRequest for task %s.%n", taskId);
        } else if (res.getBoolean("shutdown").booleanValue()) {
            client.shutdown();
            System.out.println("Sent ShutdownRequest.");
        } else {
            System.out.println("You must choose an action. Type --help for help.");
            Exit.exit((int)1);
        }
    }

    public static class Builder {
        private Logger log = LoggerFactory.getLogger(CoordinatorClient.class);
        private int maxTries = 1;
        private String target = null;

        public Builder log(Logger log) {
            this.log = log;
            return this;
        }

        public Builder maxTries(int maxTries) {
            this.maxTries = maxTries;
            return this;
        }

        public Builder target(String target) {
            this.target = target;
            return this;
        }

        public Builder target(String host, int port) {
            this.target = String.format("%s:%d", host, port);
            return this;
        }

        public CoordinatorClient build() {
            if (this.target == null) {
                throw new RuntimeException("You must specify a target.");
            }
            return new CoordinatorClient(this.log, this.maxTries, this.target);
        }
    }
}

