/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.admin.ConfigCommand$;
import kafka.log.LogConfig$;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicConfig$Client$;
import kafka.server.DynamicConfig$User$;
import kafka.utils.CommandLineUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.utils.Sanitizer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\r-x!B\u0001\u0003\u0011\u00039\u0011!D\"p]\u001aLwmQ8n[\u0006tGM\u0003\u0002\u0004\t\u0005)\u0011\rZ7j]*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005!IQ\"\u0001\u0002\u0007\u000b)\u0011\u0001\u0012A\u0006\u0003\u001b\r{gNZ5h\u0007>lW.\u00198e'\rIAB\u0005\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005M1R\"\u0001\u000b\u000b\u0005U!\u0011AB2p[6|g.\u0003\u0002\u0018)\t11i\u001c8gS\u001eDQ!G\u0005\u0005\u0002i\ta\u0001P5oSRtD#A\u0004\t\u000fqI!\u0019!C\u0001;\u00051B)\u001a4bk2$8k\u0019:b[&#XM]1uS>t7/F\u0001\u001f!\tiq$\u0003\u0002!\u001d\t\u0019\u0011J\u001c;\t\r\tJ\u0001\u0015!\u0003\u001f\u0003]!UMZ1vYR\u001c6M]1n\u0013R,'/\u0019;j_:\u001c\b\u0005C\u0004%\u0013\t\u0007I\u0011A\u0013\u0002m\t\u0013xn[3s\u0007>tg-[4t+B$\u0017\r^1cY\u0016,6/\u001b8h5>|7*Z3qKJ<\u0006.\u001b7f\u0005J|7.\u001a:Sk:t\u0017N\\4\u0016\u0003\u0019\u00022a\n\u0016-\u001b\u0005A#BA\u0015\u000f\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003W!\u00121aU3u!\ti#'D\u0001/\u0015\ty\u0003'\u0001\u0003mC:<'\"A\u0019\u0002\t)\fg/Y\u0005\u0003g9\u0012aa\u0015;sS:<\u0007BB\u001b\nA\u0003%a%A\u001cCe>\\WM]\"p]\u001aLwm]+qI\u0006$\u0018M\u00197f+NLgn\u001a.p_.+W\r]3s/\"LG.\u001a\"s_.,'OU;o]&tw\r\t\u0005\u0006o%!\t\u0001O\u0001\u0005[\u0006Lg\u000e\u0006\u0002:yA\u0011QBO\u0005\u0003w9\u0011A!\u00168ji\")QH\u000ea\u0001}\u0005!\u0011M]4t!\riq(Q\u0005\u0003\u0001:\u0011Q!\u0011:sCf\u0004\"AQ%\u000f\u0005\r;\u0005C\u0001#\u000f\u001b\u0005)%B\u0001$\u0007\u0003\u0019a$o\\8u}%\u0011\u0001JD\u0001\u0007!J,G-\u001a4\n\u0005MR%B\u0001%\u000f\u0011\u0015a\u0015\u0002\"\u0003N\u0003Q\u0001(o\\2fgN\u001cu.\\7b]\u0012<\u0016\u000e\u001e5[WR\u0019\u0011H\u0014)\t\u000b=[\u0005\u0019A!\u0002\u001fi\\7i\u001c8oK\u000e$8\u000b\u001e:j]\u001eDQ!U&A\u0002I\u000bAa\u001c9ugB\u00111\u000bV\u0007\u0002\u0013\u0019!Q+\u0003\u0001W\u0005Q\u0019uN\u001c4jO\u000e{W.\\1oI>\u0003H/[8ogN\u0011A\u000b\u0004\u0005\t{Q\u0013\t\u0011)A\u0005}!)\u0011\u0004\u0016C\u00013R\u0011!K\u0017\u0005\u0006{a\u0003\rA\u0010\u0005\b9R\u0013\r\u0011\"\u0001^\u0003\u0019\u0001\u0018M]:feV\ta\f\u0005\u0002`E6\t\u0001MC\u0001b\u0003)Qw\u000e\u001d;tS6\u0004H.Z\u0005\u0003G\u0002\u0014Ab\u00149uS>t\u0007+\u0019:tKJDa!\u001a+!\u0002\u0013q\u0016a\u00029beN,'\u000f\t\u0005\bOR\u0013\r\u0011\"\u0001i\u00031Q8nQ8o]\u0016\u001cGo\u00149u+\u0005I\u0007cA0k\u0003&\u00111\u000e\u0019\u0002\u001c\u0003J<W/\\3oi\u0006\u001b7-\u001a9uS:<w\n\u001d;j_:\u001c\u0006/Z2\t\r5$\u0006\u0015!\u0003j\u00035Q8nQ8o]\u0016\u001cGo\u00149uA!9q\u000e\u0016b\u0001\n\u0003A\u0017A\u00052p_R\u001cHO]1q'\u0016\u0014h/\u001a:PaRDa!\u001d+!\u0002\u0013I\u0017a\u00052p_R\u001cHO]1q'\u0016\u0014h/\u001a:PaR\u0004\u0003bB:U\u0005\u0004%\t\u0001[\u0001\u0011G>lW.\u00198e\u0007>tg-[4PaRDa!\u001e+!\u0002\u0013I\u0017!E2p[6\fg\u000eZ\"p]\u001aLwm\u00149uA!9q\u000f\u0016b\u0001\n\u0003A\u0018\u0001C1mi\u0016\u0014x\n\u001d;\u0016\u0003e\u0004\"a\u0018>\n\u0005m\u0004'!E(qi&|gn\u00159fG\n+\u0018\u000e\u001c3fe\"1Q\u0010\u0016Q\u0001\ne\f\u0011\"\u00197uKJ|\u0005\u000f\u001e\u0011\t\u000f}$&\u0019!C\u0001q\u0006YA-Z:de&\u0014Wm\u00149u\u0011\u001d\t\u0019\u0001\u0016Q\u0001\ne\fA\u0002Z3tGJL'-Z(qi\u0002B\u0001\"a\u0002U\u0005\u0004%\t\u0001[\u0001\u000bK:$\u0018\u000e^=UsB,\u0007bBA\u0006)\u0002\u0006I![\u0001\fK:$\u0018\u000e^=UsB,\u0007\u0005\u0003\u0005\u0002\u0010Q\u0013\r\u0011\"\u0001i\u0003))g\u000e^5us:\u000bW.\u001a\u0005\b\u0003'!\u0006\u0015!\u0003j\u0003-)g\u000e^5us:\u000bW.\u001a\u0011\t\u0011\u0005]AK1A\u0005\u0002a\fQ\"\u001a8uSRLH)\u001a4bk2$\bbBA\u000e)\u0002\u0006I!_\u0001\u000fK:$\u0018\u000e^=EK\u001a\fW\u000f\u001c;!\u0011%\ty\u0002\u0016b\u0001\n\u0003\t\t#\u0001\u0002oYV\tA\u0006C\u0004\u0002&Q\u0003\u000b\u0011\u0002\u0017\u0002\u00079d\u0007\u0005\u0003\u0005\u0002*Q\u0013\r\u0011\"\u0001i\u0003%\tG\rZ\"p]\u001aLw\rC\u0004\u0002.Q\u0003\u000b\u0011B5\u0002\u0015\u0005$GmQ8oM&<\u0007\u0005\u0003\u0005\u00022Q\u0013\r\u0011\"\u0001i\u00031!W\r\\3uK\u000e{gNZ5h\u0011\u001d\t)\u0004\u0016Q\u0001\n%\fQ\u0002Z3mKR,7i\u001c8gS\u001e\u0004\u0003\u0002CA\u001d)\n\u0007I\u0011\u0001=\u0002\u000f!,G\u000e](qi\"9\u0011Q\b+!\u0002\u0013I\u0018\u0001\u00035fYB|\u0005\u000f\u001e\u0011\t\u0011\u0005\u0005CK1A\u0005\u0002a\f\u0001BZ8sG\u0016|\u0005\u000f\u001e\u0005\b\u0003\u000b\"\u0006\u0015!\u0003z\u0003%1wN]2f\u001fB$\b\u0005C\u0005\u0002JQ\u0013\r\u0011\"\u0001\u0002L\u00059q\u000e\u001d;j_:\u001cXCAA'!\ry\u0016qJ\u0005\u0004\u0003#\u0002'!C(qi&|gnU3u\u0011!\t)\u0006\u0016Q\u0001\n\u00055\u0013\u0001C8qi&|gn\u001d\u0011\t\u0013\u0005eCK1A\u0005\u0002\u0005m\u0013aB1mY>\u0003Ho]\u000b\u0003\u0003;\u0002Ba\n\u0016\u0002`A\"\u0011\u0011MA6!\u0015y\u00161MA4\u0013\r\t)\u0007\u0019\u0002\u000b\u001fB$\u0018n\u001c8Ta\u0016\u001c\u0007\u0003BA5\u0003Wb\u0001\u0001\u0002\u0007\u0002n\u0005=\u0014\u0011!A\u0001\u0006\u0003\t\u0019HA\u0002`IEB\u0001\"!\u001dUA\u0003%\u0011QL\u0001\tC2dw\n\u001d;tAE!\u0011QOA>!\ri\u0011qO\u0005\u0004\u0003sr!a\u0002(pi\"Lgn\u001a\t\u0004\u001b\u0005u\u0014bAA@\u001d\t\u0019\u0011I\\=\t\u000f\u0005\rE\u000b\"\u0001\u0002\u0006\u0006I1\r[3dW\u0006\u0013xm\u001d\u000b\u0002s!A\u0011\u0011R\u0005\u0005\u0002\t\tY)A\u0006bYR,'oQ8oM&<GcB\u001d\u0002\u000e\u0006u\u0015q\u0014\u0005\t\u0003\u001f\u000b9\t1\u0001\u0002\u0012\u0006A!p[\"mS\u0016tG\u000f\u0005\u0003\u0002\u0014\u0006eUBAAK\u0015\r\t9\nB\u0001\u0003u.LA!a'\u0002\u0016\ni1*\u00194lCj[7\t\\5f]RDa!UAD\u0001\u0004\u0011\u0006\u0002CAQ\u0003\u000f\u0003\r!a)\u0002\u001b\u0005$W.\u001b8[W\u000ec\u0017.\u001a8u!\u0011\t\u0019*!*\n\t\u0005\u001d\u0016Q\u0013\u0002\u000e\u0003\u0012l\u0017N\u001c.l\u00072LWM\u001c;\t\u000f\u0005-\u0016\u0002\"\u0003\u0002.\u0006Q\u0002O]3Qe>\u001cWm]:TGJ\fWn\u0011:fI\u0016tG/[1mgR\u0019\u0011(a,\t\u0011\u0005E\u0016\u0011\u0016a\u0001\u0003g\u000b\u0001cY8oM&<7\u000fV8CK\u0006#G-\u001a3\u0011\t\u0005U\u00161X\u0007\u0003\u0003oS1!!/1\u0003\u0011)H/\u001b7\n\t\u0005u\u0016q\u0017\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\b\u0002CAa\u0013\u0011\u0005!!a1\u0002+\r\u0014X-\u0019;f!\u0006\u001c8o^8sI\u0016s7m\u001c3feR!\u0011QYAi!\u0011\t9-!4\u000e\u0005\u0005%'bAAf\t\u0005)Q\u000f^5mg&!\u0011qZAe\u0005=\u0001\u0016m]:x_J$WI\\2pI\u0016\u0014\b\u0002CAj\u0003\u007f\u0003\r!!6\u0002\u001d\u0015t7m\u001c3fe\u000e{gNZ5hgB)q%a6B\u0003&\u0019\u0011\u0011\u001c\u0015\u0003\u00075\u000b\u0007\u000fC\u0004\u0002^&!I!a8\u0002/A\u0014X\r\u0015:pG\u0016\u001c8O\u0011:pW\u0016\u00148i\u001c8gS\u001e\u001cH#B\u001d\u0002b\u0006\r\b\u0002CAY\u00037\u0004\r!a-\t\u0011\u0005\u0015\u00181\u001ca\u0001\u0003O\fq\u0002]3s\u0005J|7.\u001a:D_:4\u0017n\u001a\t\u0004\u001b\u0005%\u0018bAAv\u001d\t9!i\\8mK\u0006t\u0007bBAx\u0013\u0011%\u0011\u0011_\u0001\u000fI\u0016\u001c8M]5cK\u000e{gNZ5h)\u001dI\u00141_A{\u0003oD\u0001\"a$\u0002n\u0002\u0007\u0011\u0011\u0013\u0005\u0007#\u00065\b\u0019\u0001*\t\u0011\u0005\u0005\u0016Q\u001ea\u0001\u0003GC\u0001\"a?\n\t\u0003\u0011\u0011Q`\u0001\u0016a\u0006\u00148/Z\"p]\u001aLwm\u001d+p\u0005\u0016\fE\rZ3e)\u0011\t\u0019,a@\t\rE\u000bI\u00101\u0001S\u0011!\u0011\u0019!\u0003C\u0001\u0005\t\u0015\u0011a\u00069beN,7i\u001c8gS\u001e\u001cHk\u001c\"f\t\u0016dW\r^3e)\u0011\u00119A!\u0004\u0011\t\u001d\u0012I!Q\u0005\u0004\u0005\u0017A#aA*fc\"1\u0011K!\u0001A\u0002ICqA!\u0005\n\t\u0013\u0011\u0019\"A\nqe>\u001cWm]:Ce>\\WM]\"p]\u001aLw\rF\u0002:\u0005+Aa!\u0015B\b\u0001\u0004\u0011\u0006\u0002\u0003B\r\u0013\u0011\u0005!Aa\u0007\u0002#\u0005dG/\u001a:Ce>\\WM]\"p]\u001aLw\rF\u0004:\u0005;\u0011IDa\u000f\t\u0011\t}!q\u0003a\u0001\u0005C\t1\"\u00193nS:\u001cE.[3oiB!!1\u0005B\u001b\u001b\t\u0011)CC\u0002\u0004\u0005OQAA!\u000b\u0003,\u000591\r\\5f]R\u001c(bA\u0003\u0003.)!!q\u0006B\u0019\u0003\u0019\t\u0007/Y2iK*\u0011!1G\u0001\u0004_J<\u0017\u0002\u0002B\u001c\u0005K\u00111\"\u00113nS:\u001cE.[3oi\"1\u0011Ka\u0006A\u0002ICq!a\u0004\u0003\u0018\u0001\u0007\u0011\tC\u0004\u0003@%!IA!\u0011\u0002)\u0011,7o\u0019:jE\u0016\u0014%o\\6fe\u000e{gNZ5h)\u001dI$1\tB#\u0005\u000fB\u0001Ba\b\u0003>\u0001\u0007!\u0011\u0005\u0005\u0007#\nu\u0002\u0019\u0001*\t\u000f\u0005=!Q\ba\u0001\u0003\"9!1J\u0005\u0005\n\t5\u0013\u0001\u00042s_.,'oQ8oM&<G\u0003\u0003B(\u0005/\u0012IFa\u0017\u0011\u000b\u001d\u0012IA!\u0015\u0011\t\t\r\"1K\u0005\u0005\u0005+\u0012)CA\u0006D_:4\u0017nZ#oiJL\b\u0002\u0003B\u0010\u0005\u0013\u0002\rA!\t\t\u000f\u0005=!\u0011\na\u0001\u0003\"A!Q\fB%\u0001\u0004\t9/A\bj]\u000edW\u000fZ3Ts:|g._7t\r\u0019\u0011\t'\u0003!\u0003d\t1QI\u001c;jif\u001crAa\u0018\r\u0005K\u0012Y\u0007E\u0002\u000e\u0005OJ1A!\u001b\u000f\u0005\u001d\u0001&o\u001c3vGR\u00042!\u0004B7\u0013\r\u0011yG\u0004\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\f\u0003\u000f\u0011yF!f\u0001\n\u0003\u0011\u0019(F\u0001B\u0011)\tYAa\u0018\u0003\u0012\u0003\u0006I!\u0011\u0005\f\u0005s\u0012yF!f\u0001\n\u0003\u0011Y(A\u0007tC:LG/\u001b>fI:\u000bW.Z\u000b\u0003\u0005{\u0002B!\u0004B@\u0003&\u0019!\u0011\u0011\b\u0003\r=\u0003H/[8o\u0011-\u0011)Ia\u0018\u0003\u0012\u0003\u0006IA! \u0002\u001dM\fg.\u001b;ju\u0016$g*Y7fA!9\u0011Da\u0018\u0005\u0002\t%EC\u0002BF\u0005\u001b\u0013y\tE\u0002T\u0005?Bq!a\u0002\u0003\b\u0002\u0007\u0011\t\u0003\u0005\u0003z\t\u001d\u0005\u0019\u0001B?\u0011)\u0011\u0019Ja\u0018C\u0002\u0013\u0005\u0011\u0011E\u0001\u000bK:$\u0018\u000e^=QCRD\u0007\u0002\u0003BL\u0005?\u0002\u000b\u0011\u0002\u0017\u0002\u0017\u0015tG/\u001b;z!\u0006$\b\u000e\t\u0005\t\u00057\u0013y\u0006\"\u0011\u0003\u001e\u0006AAo\\*ue&tw\rF\u0001B\u0011)\u0011\tKa\u0018\u0002\u0002\u0013\u0005!1U\u0001\u0005G>\u0004\u0018\u0010\u0006\u0004\u0003\f\n\u0015&q\u0015\u0005\n\u0003\u000f\u0011y\n%AA\u0002\u0005C!B!\u001f\u0003 B\u0005\t\u0019\u0001B?\u0011)\u0011YKa\u0018\u0012\u0002\u0013\u0005!QV\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011yKK\u0002B\u0005c[#Aa-\u0011\t\tU&qX\u0007\u0003\u0005oSAA!/\u0003<\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005{s\u0011AC1o]>$\u0018\r^5p]&!!\u0011\u0019B\\\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\u000b\u0005\u000b\u0014y&%A\u0005\u0002\t\u001d\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005\u0013TCA! \u00032\"Q!Q\u001aB0\u0003\u0003%\t%!\t\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y\u0011%\u0011\tNa\u0018\u0002\u0002\u0013\u0005Q$\u0001\u0007qe>$Wo\u0019;Be&$\u0018\u0010\u0003\u0006\u0003V\n}\u0013\u0011!C\u0001\u0005/\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002|\te\u0007\"\u0003Bn\u0005'\f\t\u00111\u0001\u001f\u0003\rAH%\r\u0005\u000b\u0005?\u0014y&!A\u0005B\t\u0005\u0018a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t\r\b#B\u0014\u0003f\u0006m\u0014b\u0001BtQ\tA\u0011\n^3sCR|'\u000f\u0003\u0006\u0003l\n}\u0013\u0011!C\u0001\u0005[\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003O\u0014y\u000f\u0003\u0006\u0003\\\n%\u0018\u0011!a\u0001\u0003wB!Ba=\u0003`\u0005\u0005I\u0011\tB{\u0003!A\u0017m\u001d5D_\u0012,G#\u0001\u0010\t\u0015\te(qLA\u0001\n\u0003\u0012Y0\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003O\u0014i\u0010\u0003\u0006\u0003\\\n]\u0018\u0011!a\u0001\u0003w:\u0011b!\u0001\n\u0003\u0003E\taa\u0001\u0002\r\u0015sG/\u001b;z!\r\u00196Q\u0001\u0004\n\u0005CJ\u0011\u0011!E\u0001\u0007\u000f\u0019ba!\u0002\u0004\n\t-\u0004#CB\u0006\u0007#\t%Q\u0010BF\u001b\t\u0019iAC\u0002\u0004\u00109\tqA];oi&lW-\u0003\u0003\u0004\u0014\r5!!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oe!9\u0011d!\u0002\u0005\u0002\r]ACAB\u0002\u0011)\u0011Yj!\u0002\u0002\u0002\u0013\u001531\u0004\u000b\u0002Y!Q1qDB\u0003\u0003\u0003%\ti!\t\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\t-51EB\u0013\u0011\u001d\t9a!\bA\u0002\u0005C\u0001B!\u001f\u0004\u001e\u0001\u0007!Q\u0010\u0005\u000b\u0007S\u0019)!!A\u0005\u0002\u000e-\u0012aB;oCB\u0004H.\u001f\u000b\u0005\u0007[\u0019)\u0004E\u0003\u000e\u0005\u007f\u001ay\u0003\u0005\u0004\u000e\u0007c\t%QP\u0005\u0004\u0007gq!A\u0002+va2,'\u0007\u0003\u0006\u00048\r\u001d\u0012\u0011!a\u0001\u0005\u0017\u000b1\u0001\u001f\u00131\u0011)\u0019Yd!\u0002\u0002\u0002\u0013%1QH\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0004@A\u0019Qf!\u0011\n\u0007\r\rcF\u0001\u0004PE*,7\r\u001e\u0004\u0007\u0007\u000fJ\u0001i!\u0013\u0003\u0019\r{gNZ5h\u000b:$\u0018\u000e^=\u0014\u000f\r\u0015CB!\u001a\u0003l!Y1QJB#\u0005+\u0007I\u0011AB(\u0003\u0011\u0011xn\u001c;\u0016\u0005\t-\u0005bCB*\u0007\u000b\u0012\t\u0012)A\u0005\u0005\u0017\u000bQA]8pi\u0002B1ba\u0016\u0004F\tU\r\u0011\"\u0001\u0004Z\u0005)1\r[5mIV\u001111\f\t\u0006\u001b\t}$1\u0012\u0005\f\u0007?\u001a)E!E!\u0002\u0013\u0019Y&\u0001\u0004dQ&dG\r\t\u0005\b3\r\u0015C\u0011AB2)\u0019\u0019)ga\u001a\u0004jA\u00191k!\u0012\t\u0011\r53\u0011\ra\u0001\u0005\u0017C\u0001ba\u0016\u0004b\u0001\u000711\f\u0005\u000b\u0007[\u001a)E1A\u0005\u0002\u0005\u0005\u0012!\u00054vY2\u001c\u0016M\\5uSj,GMT1nK\"A1\u0011OB#A\u0003%A&\u0001\ngk2d7+\u00198ji&TX\r\u001a(b[\u0016\u0004\u0003\u0002CB;\u0007\u000b\"\taa\u001e\u0002\u001d\u001d,G/\u00117m\u000b:$\u0018\u000e^5fgR!1\u0011PB>!\u00159#\u0011BB3\u0011!\tyia\u001dA\u0002\u0005E\u0005\u0002\u0003BN\u0007\u000b\"\tE!(\t\u0015\t\u00056QIA\u0001\n\u0003\u0019\t\t\u0006\u0004\u0004f\r\r5Q\u0011\u0005\u000b\u0007\u001b\u001ay\b%AA\u0002\t-\u0005BCB,\u0007\u007f\u0002\n\u00111\u0001\u0004\\!Q!1VB##\u0003%\ta!#\u0016\u0005\r-%\u0006\u0002BF\u0005cC!B!2\u0004FE\u0005I\u0011ABH+\t\u0019\tJ\u000b\u0003\u0004\\\tE\u0006B\u0003Bg\u0007\u000b\n\t\u0011\"\u0011\u0002\"!I!\u0011[B#\u0003\u0003%\t!\b\u0005\u000b\u0005+\u001c)%!A\u0005\u0002\reE\u0003BA>\u00077C\u0011Ba7\u0004\u0018\u0006\u0005\t\u0019\u0001\u0010\t\u0015\t}7QIA\u0001\n\u0003\u0012\t\u000f\u0003\u0006\u0003l\u000e\u0015\u0013\u0011!C\u0001\u0007C#B!a:\u0004$\"Q!1\\BP\u0003\u0003\u0005\r!a\u001f\t\u0015\tM8QIA\u0001\n\u0003\u0012)\u0010\u0003\u0006\u0003z\u000e\u0015\u0013\u0011!C!\u0007S#B!a:\u0004,\"Q!1\\BT\u0003\u0003\u0005\r!a\u001f\b\u0013\r=\u0016\"!A\t\u0002\rE\u0016\u0001D\"p]\u001aLw-\u00128uSRL\bcA*\u00044\u001aI1qI\u0005\u0002\u0002#\u00051QW\n\u0007\u0007g\u001b9La\u001b\u0011\u0015\r-1\u0011\u0003BF\u00077\u001a)\u0007C\u0004\u001a\u0007g#\taa/\u0015\u0005\rE\u0006B\u0003BN\u0007g\u000b\t\u0011\"\u0012\u0004\u001c!Q1qDBZ\u0003\u0003%\ti!1\u0015\r\r\u001541YBc\u0011!\u0019iea0A\u0002\t-\u0005\u0002CB,\u0007\u007f\u0003\raa\u0017\t\u0015\r%21WA\u0001\n\u0003\u001bI\r\u0006\u0003\u0004L\u000e=\u0007#B\u0007\u0003\u0000\r5\u0007cB\u0007\u00042\t-51\f\u0005\u000b\u0007o\u00199-!AA\u0002\r\u0015\u0004BCB\u001e\u0007g\u000b\t\u0011\"\u0003\u0004>!A1Q[\u0005\u0005\u0002\t\u00199.A\u0006qCJ\u001cX-\u00128uSRLH\u0003BB3\u00073Da!UBj\u0001\u0004\u0011\u0006bBBo\u0013\u0011%1q\\\u0001\fK:$\u0018\u000e^=OC6,7\u000f\u0006\u0003\u0003\b\r\u0005\bBB)\u0004\\\u0002\u0007!\u000bC\u0004\u0004f&!Iaa:\u0002!A\f'o]3Rk>$\u0018-\u00128uSRLH\u0003BB3\u0007SDa!UBr\u0001\u0004\u0011\u0006")
public final class ConfigCommand {
    public static void fatal(Function0<String> function0, Function0<Throwable> function02) {
        ConfigCommand$.MODULE$.fatal(function0, function02);
    }

    public static void fatal(Function0<String> function0) {
        ConfigCommand$.MODULE$.fatal(function0);
    }

    public static void error(Function0<String> function0, Function0<Throwable> function02) {
        ConfigCommand$.MODULE$.error(function0, function02);
    }

    public static void error(Function0<String> function0) {
        ConfigCommand$.MODULE$.error(function0);
    }

    public static void warn(Function0<String> function0, Function0<Throwable> function02) {
        ConfigCommand$.MODULE$.warn(function0, function02);
    }

    public static void warn(Function0<String> function0) {
        ConfigCommand$.MODULE$.warn(function0);
    }

    public static void info(Function0<String> function0, Function0<Throwable> function02) {
        ConfigCommand$.MODULE$.info(function0, function02);
    }

    public static void info(Function0<String> function0) {
        ConfigCommand$.MODULE$.info(function0);
    }

    public static void debug(Function0<String> function0, Function0<Throwable> function02) {
        ConfigCommand$.MODULE$.debug(function0, function02);
    }

    public static void debug(Function0<String> function0) {
        ConfigCommand$.MODULE$.debug(function0);
    }

    public static boolean isTraceEnabled() {
        return ConfigCommand$.MODULE$.isTraceEnabled();
    }

    public static boolean isDebugEnabled() {
        return ConfigCommand$.MODULE$.isDebugEnabled();
    }

    public static void trace(Function0<String> function0, Function0<Throwable> function02) {
        ConfigCommand$.MODULE$.trace(function0, function02);
    }

    public static void trace(Function0<String> function0) {
        ConfigCommand$.MODULE$.trace(function0);
    }

    public static String msgWithLogIdent(String string) {
        return ConfigCommand$.MODULE$.msgWithLogIdent(string);
    }

    public static String loggerName() {
        return ConfigCommand$.MODULE$.loggerName();
    }

    public static void validateChars(String string, String string2) {
        ConfigCommand$.MODULE$.validateChars(string, string2);
    }

    public static void main(String[] stringArray) {
        ConfigCommand$.MODULE$.main(stringArray);
    }

    public static Set<String> BrokerConfigsUpdatableUsingZooKeeperWhileBrokerRunning() {
        return ConfigCommand$.MODULE$.BrokerConfigsUpdatableUsingZooKeeperWhileBrokerRunning();
    }

    public static int DefaultScramIterations() {
        return ConfigCommand$.MODULE$.DefaultScramIterations();
    }

    public static String logIdent() {
        return ConfigCommand$.MODULE$.logIdent();
    }

    public static Logger logger() {
        return ConfigCommand$.MODULE$.logger();
    }

    public static class ConfigCommandOptions {
        private final OptionParser parser = new OptionParser(false);
        private final ArgumentAcceptingOptionSpec<String> zkConnectOpt = this.parser().accepts("zookeeper", "REQUIRED: The connection string for the zookeeper connection in the form host:port. Multiple URLS can be given to allow fail-over.").withRequiredArg().describedAs("urls").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> bootstrapServerOpt = this.parser().accepts("bootstrap-server", "The Kafka server to connect to. This is required for describing and altering broker configs.").withRequiredArg().describedAs("server to connect to").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> commandConfigOpt = this.parser().accepts("command-config", "Property file containing configs to be passed to Admin Client. This is used only with --bootstrap-server option for describing and altering broker configs.").withRequiredArg().describedAs("command config property file").ofType(String.class);
        private final OptionSpecBuilder alterOpt = this.parser().accepts("alter", "Alter the configuration for the entity.");
        private final OptionSpecBuilder describeOpt = this.parser().accepts("describe", "List configs for the given entity.");
        private final ArgumentAcceptingOptionSpec<String> entityType = this.parser().accepts("entity-type", "Type of entity (topics/clients/users/brokers)").withRequiredArg().ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> entityName = this.parser().accepts("entity-name", "Name of entity (topic name/client id/user principal name/broker id)").withRequiredArg().ofType(String.class);
        private final OptionSpecBuilder entityDefault = this.parser().accepts("entity-default", "Default entity name for clients/users/brokers (applies to corresponding entity type in command line)");
        private final String nl = System.getProperty("line.separator");
        private final ArgumentAcceptingOptionSpec<String> addConfig = this.parser().accepts("add-config", new StringBuilder(259).append("Key Value pairs of configs to add. Square brackets can be used to group values which contain commas: 'k1=v1,k2=[v1,v2,v2],k3=v3'. The following is a list of valid configurations: For entity-type '").append(ConfigType$.MODULE$.Topic()).append("': ").append(((TraversableOnce)LogConfig$.MODULE$.configNames().map((Function1 & Serializable & scala.Serializable)x$11 -> new StringBuilder(1).append("\t").append((String)x$11).toString(), Seq$.MODULE$.canBuildFrom())).mkString(this.nl(), this.nl(), this.nl())).append("For entity-type '").append(ConfigType$.MODULE$.Broker()).append("': ").append(((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(DynamicConfig$Broker$.MODULE$.names()).asScala()).map((Function1 & Serializable & scala.Serializable)x$12 -> new StringBuilder(1).append("\t").append((String)x$12).toString(), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).mkString(this.nl(), this.nl(), this.nl())).append("For entity-type '").append(ConfigType$.MODULE$.User()).append("': ").append(((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(DynamicConfig$User$.MODULE$.names()).asScala()).map((Function1 & Serializable & scala.Serializable)x$13 -> new StringBuilder(1).append("\t").append((String)x$13).toString(), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).mkString(this.nl(), this.nl(), this.nl())).append("For entity-type '").append(ConfigType$.MODULE$.Client()).append("': ").append(((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(DynamicConfig$Client$.MODULE$.names()).asScala()).map((Function1 & Serializable & scala.Serializable)x$14 -> new StringBuilder(1).append("\t").append((String)x$14).toString(), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).mkString(this.nl(), this.nl(), this.nl())).append(new StringBuilder(97).append("Entity types '").append(ConfigType$.MODULE$.User()).append("' and '").append(ConfigType$.MODULE$.Client()).append("' may be specified together to update config for clients of a specific user.").toString()).toString()).withRequiredArg().ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> deleteConfig = this.parser().accepts("delete-config", "config keys to remove 'k1,k2'").withRequiredArg().ofType(String.class).withValuesSeparatedBy(',');
        private final OptionSpecBuilder helpOpt = this.parser().accepts("help", "Print usage information.");
        private final OptionSpecBuilder forceOpt = this.parser().accepts("force", "Suppress console prompts");
        private final OptionSet options;
        private final Set<OptionSpec<?>> allOpts;

        public OptionParser parser() {
            return this.parser;
        }

        public ArgumentAcceptingOptionSpec<String> zkConnectOpt() {
            return this.zkConnectOpt;
        }

        public ArgumentAcceptingOptionSpec<String> bootstrapServerOpt() {
            return this.bootstrapServerOpt;
        }

        public ArgumentAcceptingOptionSpec<String> commandConfigOpt() {
            return this.commandConfigOpt;
        }

        public OptionSpecBuilder alterOpt() {
            return this.alterOpt;
        }

        public OptionSpecBuilder describeOpt() {
            return this.describeOpt;
        }

        public ArgumentAcceptingOptionSpec<String> entityType() {
            return this.entityType;
        }

        public ArgumentAcceptingOptionSpec<String> entityName() {
            return this.entityName;
        }

        public OptionSpecBuilder entityDefault() {
            return this.entityDefault;
        }

        public String nl() {
            return this.nl;
        }

        public ArgumentAcceptingOptionSpec<String> addConfig() {
            return this.addConfig;
        }

        public ArgumentAcceptingOptionSpec<String> deleteConfig() {
            return this.deleteConfig;
        }

        public OptionSpecBuilder helpOpt() {
            return this.helpOpt;
        }

        public OptionSpecBuilder forceOpt() {
            return this.forceOpt;
        }

        public OptionSet options() {
            return this.options;
        }

        public Set<OptionSpec<?>> allOpts() {
            return this.allOpts;
        }

        public void checkArgs() {
            int actions = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpecBuilder[]{this.alterOpt(), this.describeOpt()}))).count((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigCommandOptions.$anonfun$checkArgs$1(this, x$1)));
            if (actions != 1) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(this.parser(), "Command must include exactly one action: --describe, --alter");
            }
            CommandLineUtils$.MODULE$.checkInvalidArgs(this.parser(), this.options(), (OptionSpec<?>)this.alterOpt(), (Set<OptionSpec<?>>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.describeOpt()}))));
            CommandLineUtils$.MODULE$.checkInvalidArgs(this.parser(), this.options(), (OptionSpec<?>)this.describeOpt(), (Set<OptionSpec<?>>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.alterOpt(), this.addConfig(), this.deleteConfig()}))));
            Buffer entityTypeVals = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.options().valuesOf(this.entityType())).asScala();
            if (this.options().has(this.bootstrapServerOpt()) == this.options().has(this.zkConnectOpt())) {
                throw new IllegalArgumentException("Only one of --bootstrap-server or --zookeeper must be specified");
            }
            if (entityTypeVals.contains((Object)ConfigType$.MODULE$.Client()) || entityTypeVals.contains((Object)ConfigType$.MODULE$.Topic()) || entityTypeVals.contains((Object)ConfigType$.MODULE$.User())) {
                CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.zkConnectOpt(), this.entityType()}));
            }
            if (this.options().has((OptionSpec)this.alterOpt())) {
                if (entityTypeVals.contains((Object)ConfigType$.MODULE$.User()) || entityTypeVals.contains((Object)ConfigType$.MODULE$.Client()) || entityTypeVals.contains((Object)ConfigType$.MODULE$.Broker())) {
                    if (!this.options().has(this.entityName()) && !this.options().has((OptionSpec)this.entityDefault())) {
                        throw new IllegalArgumentException("--entity-name or --entity-default must be specified with --alter of users, clients or brokers");
                    }
                } else if (!this.options().has(this.entityName())) {
                    throw new IllegalArgumentException(new StringBuilder(48).append("--entity-name must be specified with --alter of ").append(entityTypeVals).toString());
                }
                boolean isAddConfigPresent = this.options().has(this.addConfig());
                boolean isDeleteConfigPresent = this.options().has(this.deleteConfig());
                if (!isAddConfigPresent && !isDeleteConfigPresent) {
                    throw new IllegalArgumentException("At least one of --add-config or --delete-config must be specified with --alter");
                }
            }
            entityTypeVals.foreach((Function1 & Serializable & scala.Serializable)entityTypeVal -> {
                ConfigCommandOptions.$anonfun$checkArgs$2(entityTypeVal);
                return BoxedUnit.UNIT;
            });
            if (entityTypeVals.isEmpty()) {
                throw new IllegalArgumentException("At least one --entity-type must be specified");
            }
            if (entityTypeVals.size() > 1 && !entityTypeVals.toSet().equals((Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ConfigType$.MODULE$.User(), ConfigType$.MODULE$.Client()})))) {
                throw new IllegalArgumentException(new StringBuilder(53).append("Only '").append(ConfigType$.MODULE$.User()).append("' and '").append(ConfigType$.MODULE$.Client()).append("' entity types may be specified together").toString());
            }
        }

        public static final /* synthetic */ boolean $anonfun$checkArgs$1(ConfigCommandOptions $this, OptionSpec x$1) {
            return $this.options().has(x$1);
        }

        public static final /* synthetic */ void $anonfun$checkArgs$2(String entityTypeVal) {
            if (!ConfigType$.MODULE$.all().contains((Object)entityTypeVal)) {
                throw new IllegalArgumentException(new StringBuilder(51).append("Invalid entity-type ").append(entityTypeVal).append(", --entity-type must be one of ").append(ConfigType$.MODULE$.all()).toString());
            }
        }

        public ConfigCommandOptions(String[] args) {
            this.options = this.parser().parse(args);
            this.allOpts = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.alterOpt(), this.describeOpt(), this.entityType(), this.entityName(), this.addConfig(), this.deleteConfig(), this.helpOpt()}));
        }
    }

    public static class ConfigEntity
    implements Product,
    scala.Serializable {
        private final Entity root;
        private final Option<Entity> child;
        private final String fullSanitizedName;

        public Entity root() {
            return this.root;
        }

        public Option<Entity> child() {
            return this.child;
        }

        public String fullSanitizedName() {
            return this.fullSanitizedName;
        }

        public Seq<ConfigEntity> getAllEntities(KafkaZkClient zkClient) {
            Option option;
            Option option2;
            Seq seq;
            Option option3;
            Tuple2 tuple2 = new Tuple2(this.root().sanitizedName(), this.child());
            if (tuple2 != null && None$.MODULE$.equals(option3 = (Option)tuple2._1())) {
                Seq seq2;
                Seq rootEntities = (Seq)zkClient.getAllEntitiesWithConfig(this.root().entityType()).map((Function1 & Serializable & scala.Serializable)name -> new ConfigEntity(new Entity(this.root().entityType(), (Option<String>)new Some(name)), this.child()), Seq$.MODULE$.canBuildFrom());
                Option<Entity> option4 = this.child();
                if (option4 instanceof Some) {
                    Some some = (Some)option4;
                    Entity s = (Entity)some.value();
                    seq2 = (Seq)rootEntities.flatMap((Function1 & Serializable & scala.Serializable)rootEntity -> new ConfigEntity(rootEntity.root(), (Option<Entity>)new Some((Object)new Entity(s.entityType(), (Option<String>)None$.MODULE$))).getAllEntities(zkClient), Seq$.MODULE$.canBuildFrom());
                } else if (None$.MODULE$.equals(option4)) {
                    seq2 = rootEntities;
                } else {
                    throw new MatchError(option4);
                }
                seq = seq2;
            } else if (tuple2 != null && (option2 = (Option)tuple2._2()) instanceof Some) {
                Seq seq3;
                Some some = (Some)option2;
                Entity childEntity = (Entity)some.value();
                Option<String> option5 = childEntity.sanitizedName();
                if (option5 instanceof Some) {
                    seq3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntity[]{this}));
                } else if (None$.MODULE$.equals(option5)) {
                    seq3 = (Seq)zkClient.getAllEntitiesWithConfig(new StringBuilder(1).append(this.root().entityPath()).append("/").append(childEntity.entityType()).toString()).map((Function1 & Serializable & scala.Serializable)name -> new ConfigEntity(this.root(), (Option<Entity>)new Some((Object)new Entity(childEntity.entityType(), (Option<String>)new Some(name)))), Seq$.MODULE$.canBuildFrom());
                } else {
                    throw new MatchError(option5);
                }
                seq = seq3;
            } else if (tuple2 != null && None$.MODULE$.equals(option = (Option)tuple2._2())) {
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntity[]{this}));
            } else {
                throw new MatchError((Object)tuple2);
            }
            return seq;
        }

        public String toString() {
            return new StringBuilder(0).append(this.root().toString()).append(this.child().map((Function1 & Serializable & scala.Serializable)s -> new StringBuilder(2).append(", ").append(s.toString()).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString();
        }

        public ConfigEntity copy(Entity root, Option<Entity> child) {
            return new ConfigEntity(root, child);
        }

        public Entity copy$default$1() {
            return this.root();
        }

        public Option<Entity> copy$default$2() {
            return this.child();
        }

        public String productPrefix() {
            return "ConfigEntity";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Option<Entity> option;
            int n = x$1;
            switch (n) {
                case 0: {
                    option = this.root();
                    break;
                }
                case 1: {
                    option = this.child();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return option;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ConfigEntity;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ConfigEntity)) return false;
            boolean bl = true;
            if (!bl) return false;
            ConfigEntity configEntity = (ConfigEntity)x$1;
            Entity entity = this.root();
            Entity entity2 = configEntity.root();
            if (entity == null) {
                if (entity2 != null) {
                    return false;
                }
            } else if (!((Object)entity).equals(entity2)) return false;
            Option<Entity> option = this.child();
            Option<Entity> option2 = configEntity.child();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!configEntity.canEqual(this)) return false;
            return true;
        }

        public ConfigEntity(Entity root, Option<Entity> child) {
            this.root = root;
            this.child = child;
            Product.$init$((Product)this);
            this.fullSanitizedName = new StringBuilder(0).append((String)root.sanitizedName().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(child.map((Function1 & Serializable & scala.Serializable)s -> new StringBuilder(1).append("/").append(s.entityPath()).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString();
        }
    }

    public static class Entity
    implements Product,
    scala.Serializable {
        private final String entityType;
        private final Option<String> sanitizedName;
        private final String entityPath;

        public String entityType() {
            return this.entityType;
        }

        public Option<String> sanitizedName() {
            return this.sanitizedName;
        }

        public String entityPath() {
            return this.entityPath;
        }

        /*
         * Unable to fully structure code
         */
        public String toString() {
            block9: {
                block10: {
                    block8: {
                        var4_1 = this.entityType();
                        v0 = ConfigType$.MODULE$.User();
                        var5_2 = var4_1;
                        if (!(v0 != null ? v0.equals(var5_2) == false : var5_2 != null)) {
                            var2_3 = "user-principal";
                        } else {
                            v1 = ConfigType$.MODULE$.Client();
                            var6_4 = var4_1;
                            if (!(v1 != null ? v1.equals(var6_4) == false : var6_4 != null)) {
                                var2_3 = "client-id";
                            } else {
                                v2 = ConfigType$.MODULE$.Topic();
                                var7_5 = var4_1;
                                var2_3 = !(v2 != null ? v2.equals(var7_5) == false : var7_5 != null) ? "topic" : var4_1;
                            }
                        }
                        typeName = var2_3;
                        var8_7 = false;
                        var9_8 = null;
                        var10_9 = this.sanitizedName();
                        if (!(var10_9 instanceof Some)) break block8;
                        var8_7 = true;
                        var9_8 = (Some)var10_9;
                        var11_10 = (String)var9_8.value();
                        v3 = ConfigEntityName$.MODULE$.Default();
                        var12_11 = var11_10;
                        if (v3 != null ? v3.equals(var12_11) == false : var12_11 != null) break block8;
                        var1_12 = new StringBuilder(8).append("default ").append(typeName).toString();
                        break block9;
                    }
                    if (!var8_7) break block10;
                    n = (String)var9_8.value();
                    v4 = this.entityType();
                    var15_14 = ConfigType$.MODULE$.User();
                    if (!(v4 == null ? var15_14 != null : v4.equals(var15_14) == false)) ** GOTO lbl-1000
                    v5 = this.entityType();
                    var16_15 = ConfigType$.MODULE$.Client();
                    if (!(v5 != null ? v5.equals(var16_15) == false : var16_15 != null)) lbl-1000:
                    // 2 sources

                    {
                        v6 = Sanitizer.desanitize((String)n);
                    } else {
                        v6 = n;
                    }
                    desanitized = v6;
                    var1_12 = new StringBuilder(3).append(typeName).append(" '").append(desanitized).append("'").toString();
                    break block9;
                }
                if (None$.MODULE$.equals(var10_9)) {
                    var1_12 = this.entityType();
                } else {
                    throw new MatchError(var10_9);
                }
            }
            return var1_12;
        }

        public Entity copy(String entityType, Option<String> sanitizedName) {
            return new Entity(entityType, sanitizedName);
        }

        public String copy$default$1() {
            return this.entityType();
        }

        public Option<String> copy$default$2() {
            return this.sanitizedName();
        }

        public String productPrefix() {
            return "Entity";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Option<String> option;
            int n = x$1;
            switch (n) {
                case 0: {
                    option = this.entityType();
                    break;
                }
                case 1: {
                    option = this.sanitizedName();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return option;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Entity;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Entity)) return false;
            boolean bl = true;
            if (!bl) return false;
            Entity entity = (Entity)x$1;
            String string = this.entityType();
            String string2 = entity.entityType();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Option<String> option = this.sanitizedName();
            Option<String> option2 = entity.sanitizedName();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!entity.canEqual(this)) return false;
            return true;
        }

        public Entity(String entityType, Option<String> sanitizedName) {
            String string;
            this.entityType = entityType;
            this.sanitizedName = sanitizedName;
            Product.$init$((Product)this);
            Option<String> option = sanitizedName;
            if (option instanceof Some) {
                Some some = (Some)option;
                String n = (String)some.value();
                string = new StringBuilder(1).append(entityType).append("/").append(n).toString();
            } else if (None$.MODULE$.equals(option)) {
                string = entityType;
            } else {
                throw new MatchError(option);
            }
            this.entityPath = string;
        }
    }
}

