/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kafka.cluster.EndPoint;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.Acceptor;
import kafka.network.ConnectionQuotas;
import kafka.network.Processor;
import kafka.network.RequestChannel;
import kafka.network.SocketServer$;
import kafka.security.CredentialProvider;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.memory.SimpleMemoryPool;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\rg\u0001B\u0001\u0003\u0001\u001d\u0011AbU8dW\u0016$8+\u001a:wKJT!a\u0001\u0003\u0002\u000f9,Go^8sW*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001Aa\u0002\u0006\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B;uS2\u001c\u0018BA\n\u0011\u0005\u001daunZ4j]\u001e\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0003\u0002\u000f5,GO]5dg&\u0011\u0011D\u0006\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\b\u0002C\u000e\u0001\u0005\u000b\u0007I\u0011\u0001\u000f\u0002\r\r|gNZ5h+\u0005i\u0002C\u0001\u0010\"\u001b\u0005y\"B\u0001\u0011\u0005\u0003\u0019\u0019XM\u001d<fe&\u0011!e\b\u0002\f\u0017\u000647.Y\"p]\u001aLw\r\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003\u001e\u0003\u001d\u0019wN\u001c4jO\u0002B\u0001b\u0006\u0001\u0003\u0006\u0004%\tAJ\u000b\u0002OA\u0011\u0001&M\u0007\u0002S)\u0011qC\u000b\u0006\u0003W1\naaY8n[>t'BA\u0003.\u0015\tqs&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002a\u0005\u0019qN]4\n\u0005IJ#aB'fiJL7m\u001d\u0005\ti\u0001\u0011\t\u0011)A\u0005O\u0005AQ.\u001a;sS\u000e\u001c\b\u0005\u0003\u00057\u0001\t\u0015\r\u0011\"\u00018\u0003\u0011!\u0018.\\3\u0016\u0003a\u0002\"!O\u001e\u000e\u0003iR!!\u0005\u0016\n\u0005qR$\u0001\u0002+j[\u0016D\u0001B\u0010\u0001\u0003\u0002\u0003\u0006I\u0001O\u0001\u0006i&lW\r\t\u0005\t\u0001\u0002\u0011)\u0019!C\u0001\u0003\u0006\u00112M]3eK:$\u0018.\u00197Qe>4\u0018\u000eZ3s+\u0005\u0011\u0005CA\"G\u001b\u0005!%BA#\u0005\u0003!\u0019XmY;sSRL\u0018BA$E\u0005I\u0019%/\u001a3f]RL\u0017\r\u001c)s_ZLG-\u001a:\t\u0011%\u0003!\u0011!Q\u0001\n\t\u000b1c\u0019:fI\u0016tG/[1m!J|g/\u001b3fe\u0002BQa\u0013\u0001\u0005\u00021\u000ba\u0001P5oSRtD#B'P!F\u0013\u0006C\u0001(\u0001\u001b\u0005\u0011\u0001\"B\u000eK\u0001\u0004i\u0002\"B\fK\u0001\u00049\u0003\"\u0002\u001cK\u0001\u0004A\u0004\"\u0002!K\u0001\u0004\u0011\u0005b\u0002+\u0001\u0005\u0004%I!V\u0001\u0012[\u0006D\u0018+^3vK\u0012\u0014V-];fgR\u001cX#\u0001,\u0011\u0005]cV\"\u0001-\u000b\u0005eS\u0016\u0001\u00027b]\u001eT\u0011aW\u0001\u0005U\u00064\u0018-\u0003\u0002^1\n9\u0011J\u001c;fO\u0016\u0014\bBB0\u0001A\u0003%a+\u0001\nnCb\fV/Z;fIJ+\u0017/^3tiN\u0004\u0003bB1\u0001\u0005\u0004%IAY\u0001\u000bY><7i\u001c8uKb$X#A2\u0011\u0005e\"\u0017BA3;\u0005)aunZ\"p]R,\u0007\u0010\u001e\u0005\u0007O\u0002\u0001\u000b\u0011B2\u0002\u00171|wmQ8oi\u0016DH\u000f\t\u0005\bS\u0002\u0011\r\u0011\"\u0003k\u0003AiW-\\8ssB{w\u000e\\*f]N|'/F\u0001l!\tAC.\u0003\u0002nS\t11+\u001a8t_JDaa\u001c\u0001!\u0002\u0013Y\u0017!E7f[>\u0014\u0018\u0010U8pYN+gn]8sA!9\u0011\u000f\u0001b\u0001\n\u0013\u0011\u0018aI7f[>\u0014\u0018\u0010U8pY\u0012+\u0007\u000f\\3uK\u0012\u0004VM]2f]RlU\r\u001e:jG:\u000bW.Z\u000b\u0002gB\u0011A/^\u0007\u0002U%\u0011aO\u000b\u0002\u000b\u001b\u0016$(/[2OC6,\u0007B\u0002=\u0001A\u0003%1/\u0001\u0013nK6|'/\u001f)p_2$U\r\u001d7fi\u0016$\u0007+\u001a:dK:$X*\u001a;sS\u000et\u0015-\\3!\u0011\u001dQ\bA1A\u0005\nI\f\u0001%\\3n_JL\bk\\8m\t\u0016\u0004H.\u001a;fIRKW.Z'fiJL7MT1nK\"1A\u0010\u0001Q\u0001\nM\f\u0011%\\3n_JL\bk\\8m\t\u0016\u0004H.\u001a;fIRKW.Z'fiJL7MT1nK\u0002BqA \u0001C\u0002\u0013%q0\u0001\u0006nK6|'/\u001f)p_2,\"!!\u0001\u0011\t\u0005\r\u0011\u0011B\u0007\u0003\u0003\u000bQ1!a\u0002+\u0003\u0019iW-\\8ss&!\u00111BA\u0003\u0005)iU-\\8ssB{w\u000e\u001c\u0005\t\u0003\u001f\u0001\u0001\u0015!\u0003\u0002\u0002\u0005YQ.Z7pef\u0004vn\u001c7!\u0011%\t\u0019\u0002\u0001b\u0001\n\u0003\t)\"\u0001\bsKF,Xm\u001d;DQ\u0006tg.\u001a7\u0016\u0005\u0005]\u0001c\u0001(\u0002\u001a%\u0019\u00111\u0004\u0002\u0003\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY\"A\u0011q\u0004\u0001!\u0002\u0013\t9\"A\bsKF,Xm\u001d;DQ\u0006tg.\u001a7!\u0011%\t\u0019\u0003\u0001b\u0001\n\u0013\t)#\u0001\u0006qe>\u001cWm]:peN,\"!a\n\u0011\u0011\u0005%\u00121GA\u001c\u0003{i!!a\u000b\u000b\t\u00055\u0012qF\u0001\u000bG>t7-\u001e:sK:$(bAA\u00195\u0006!Q\u000f^5m\u0013\u0011\t)$a\u000b\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000fE\u0002\n\u0003sI1!a\u000f\u000b\u0005\rIe\u000e\u001e\t\u0004\u001d\u0006}\u0012bAA!\u0005\tI\u0001K]8dKN\u001cxN\u001d\u0005\t\u0003\u000b\u0002\u0001\u0015!\u0003\u0002(\u0005Y\u0001O]8dKN\u001cxN]:!\u0011%\tI\u0005\u0001a\u0001\n\u0013\tY%A\boKb$\bK]8dKN\u001cxN]%e+\t\t9\u0004C\u0005\u0002P\u0001\u0001\r\u0011\"\u0003\u0002R\u0005\u0019b.\u001a=u!J|7-Z:t_JLEm\u0018\u0013fcR!\u00111KA-!\rI\u0011QK\u0005\u0004\u0003/R!\u0001B+oSRD!\"a\u0017\u0002N\u0005\u0005\t\u0019AA\u001c\u0003\rAH%\r\u0005\t\u0003?\u0002\u0001\u0015)\u0003\u00028\u0005\u0001b.\u001a=u!J|7-Z:t_JLE\r\t\u0005\u000b\u0003G\u0002!\u0019!C\u0001\u0005\u0005\u0015\u0014!C1dG\u0016\u0004Ho\u001c:t+\t\t9\u0007\u0005\u0005\u0002*\u0005M\u0012\u0011NA;!\u0011\tY'!\u001d\u000e\u0005\u00055$bAA8\t\u000591\r\\;ti\u0016\u0014\u0018\u0002BA:\u0003[\u0012\u0001\"\u00128e!>Lg\u000e\u001e\t\u0004\u001d\u0006]\u0014bAA=\u0005\tA\u0011iY2faR|'\u000f\u0003\u0005\u0002~\u0001\u0001\u000b\u0011BA4\u0003)\t7mY3qi>\u00148\u000f\t\u0005\f\u0003\u0003\u0003\u0001\u0019!a\u0001\n\u0013\t\u0019)\u0001\td_:tWm\u0019;j_:\fVo\u001c;bgV\u0011\u0011Q\u0011\t\u0004\u001d\u0006\u001d\u0015bAAE\u0005\t\u00012i\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018m\u001d\u0005\f\u0003\u001b\u0003\u0001\u0019!a\u0001\n\u0013\ty)\u0001\u000bd_:tWm\u0019;j_:\fVo\u001c;bg~#S-\u001d\u000b\u0005\u0003'\n\t\n\u0003\u0006\u0002\\\u0005-\u0015\u0011!a\u0001\u0003\u000bC1\"!&\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0006\u0006\t2m\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018m\u001d\u0011\t\u0013\u0005e\u0005\u00011A\u0005\n\u0005m\u0015!G:u_B\u0004X\r\u001a)s_\u000e,7o]5oOJ+\u0017/^3tiN,\"!!(\u0011\u0007%\ty*C\u0002\u0002\"*\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0002&\u0002\u0001\r\u0011\"\u0003\u0002(\u0006i2\u000f^8qa\u0016$\u0007K]8dKN\u001c\u0018N\\4SKF,Xm\u001d;t?\u0012*\u0017\u000f\u0006\u0003\u0002T\u0005%\u0006BCA.\u0003G\u000b\t\u00111\u0001\u0002\u001e\"A\u0011Q\u0016\u0001!B\u0013\ti*\u0001\u000eti>\u0004\b/\u001a3Qe>\u001cWm]:j]\u001e\u0014V-];fgR\u001c\b\u0005C\u0004\u00022\u0002!\t!a-\u0002\u000fM$\u0018M\u001d;vaR!\u00111KA[\u0011)\t9,a,\u0011\u0002\u0003\u0007\u0011QT\u0001\u0012gR\f'\u000f^;q!J|7-Z:t_J\u001c\bbBA^\u0001\u0011\u0005\u0011QX\u0001\u0010gR\f'\u000f\u001e)s_\u000e,7o]8sgR\u0011\u00111\u000b\u0005\b\u0003\u0003\u0004A\u0011BAb\u0003%)g\u000e\u001a9pS:$8/\u0006\u0002\u0002FBA\u0011qYAi\u0003+\fI'\u0004\u0002\u0002J*!\u00111ZAg\u0003%IW.\\;uC\ndWMC\u0002\u0002P*\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019.!3\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002X\u0006mWBAAm\u0015\t\u0019!&\u0003\u0003\u0002^\u0006e'\u0001\u0004'jgR,g.\u001a:OC6,\u0007bBAq\u0001\u0011%\u00111]\u0001\u001cGJ,\u0017\r^3BG\u000e,\u0007\u000f^8s\u0003:$\u0007K]8dKN\u001cxN]:\u0015\r\u0005M\u0013Q]Au\u0011!\t9/a8A\u0002\u0005]\u0012!\u00069s_\u000e,7o]8sgB+'\u000fT5ti\u0016tWM\u001d\u0005\t\u0003\u0003\fy\u000e1\u0001\u0002lB1\u0011Q^Ax\u0003Sj!!!4\n\t\u0005E\u0018Q\u001a\u0002\u0004'\u0016\f\bbBA{\u0001\u0011%\u0011q_\u0001\u000eC\u0012$\u0007K]8dKN\u001cxN]:\u0015\u0011\u0005M\u0013\u0011`A\u007f\u0005\u0003A\u0001\"a?\u0002t\u0002\u0007\u0011QO\u0001\tC\u000e\u001cW\r\u001d;pe\"A\u0011q`Az\u0001\u0004\tI'\u0001\u0005f]\u0012\u0004x.\u001b8u\u0011!\u0011\u0019!a=A\u0002\u0005]\u0012\u0001\u00078foB\u0013xnY3tg>\u00148\u000fU3s\u0019&\u001cH/\u001a8fe\"9!q\u0001\u0001\u0005\u0002\u0005u\u0016AF:u_B\u0004&o\\2fgNLgn\u001a*fcV,7\u000f^:\t\u000f\t-\u0001\u0001\"\u0001\u0003\u000e\u0005\u0001\"/Z:ju\u0016$\u0006N]3bIB{w\u000e\u001c\u000b\u0007\u0003'\u0012yAa\u0005\t\u0011\tE!\u0011\u0002a\u0001\u0003o\tAc\u001c7e\u001dVlg*\u001a;x_J\\G\u000b\u001b:fC\u0012\u001c\b\u0002\u0003B\u000b\u0005\u0013\u0001\r!a\u000e\u0002)9,wOT;n\u001d\u0016$xo\u001c:l)\"\u0014X-\u00193t\u0011\u001d\u0011I\u0002\u0001C\u0001\u0003{\u000b\u0001b\u001d5vi\u0012|wO\u001c\u0005\b\u0005;\u0001A\u0011\u0001B\u0010\u0003%\u0011w.\u001e8e!>\u0014H\u000f\u0006\u0003\u00028\t\u0005\u0002\u0002\u0003B\u0012\u00057\u0001\r!!6\u0002\u00191L7\u000f^3oKJt\u0015-\\3\t\u000f\t\u001d\u0002\u0001\"\u0001\u0003*\u0005a\u0011\r\u001a3MSN$XM\\3sgR!\u00111\u000bB\u0016\u0011!\u0011iC!\nA\u0002\u0005-\u0018A\u00047jgR,g.\u001a:t\u0003\u0012$W\r\u001a\u0005\b\u0005c\u0001A\u0011\u0001B\u001a\u0003=\u0011X-\\8wK2K7\u000f^3oKJ\u001cH\u0003BA*\u0005kA\u0001Ba\u000e\u00030\u0001\u0007\u00111^\u0001\u0011Y&\u001cH/\u001a8feN\u0014V-\\8wK\u0012DqAa\u000f\u0001\t\u0003\u0011i$A\rva\u0012\fG/Z'bq\u000e{gN\\3di&|gn\u001d)fe&\u0003H\u0003BA*\u0005\u007fA\u0001B!\u0011\u0003:\u0001\u0007\u0011qG\u0001\u0014[\u0006D8i\u001c8oK\u000e$\u0018n\u001c8t!\u0016\u0014\u0018\n\u001d\u0005\b\u0005\u000b\u0002A\u0011\u0001B$\u0003\u0005*\b\u000fZ1uK6\u000b\u0007pQ8o]\u0016\u001cG/[8ogB+'/\u00139Pm\u0016\u0014(/\u001b3f)\u0011\t\u0019F!\u0013\t\u0011\t-#1\ta\u0001\u0005\u001b\nA$\\1y\u0007>tg.Z2uS>t7\u000fU3s\u0013B|e/\u001a:sS\u0012,7\u000f\u0005\u0005\u0002n\n=#\u0011KA\u001c\u0013\u0011\t\u0019.!4\u0011\t\tM#\u0011\r\b\u0005\u0005+\u0012i\u0006E\u0002\u0003X)i!A!\u0017\u000b\u0007\tmc!\u0001\u0004=e>|GOP\u0005\u0004\u0005?R\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0003d\t\u0015$AB*ue&twMC\u0002\u0003`)A\u0001B!\u001b\u0001\t#\u0011!1N\u0001\r]\u0016<\bK]8dKN\u001cxN\u001d\u000b\r\u0003{\u0011iG!\u001d\u0003t\tU$q\u0011\u0005\t\u0005_\u00129\u00071\u0001\u00028\u0005\u0011\u0011\u000e\u001a\u0005\t\u0003\u0003\u00139\u00071\u0001\u0002\u0006\"A!1\u0005B4\u0001\u0004\t)\u000e\u0003\u0005\u0003x\t\u001d\u0004\u0019\u0001B=\u0003A\u0019XmY;sSRL\bK]8u_\u000e|G\u000e\u0005\u0003\u0003|\t\rUB\u0001B?\u0015\u0011\u0011yH!!\u0002\t\u0005,H\u000f\u001b\u0006\u0003\u000b*JAA!\"\u0003~\t\u00012+Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\u001c\u0005\b}\n\u001d\u0004\u0019AA\u0001\u0011!\u0011Y\t\u0001C\u0001\u0005\t5\u0015aD2p]:,7\r^5p]\u000e{WO\u001c;\u0015\t\u0005]\"q\u0012\u0005\t\u0005#\u0013I\t1\u0001\u0003\u0014\u00069\u0011\r\u001a3sKN\u001c\b\u0003\u0002BK\u00057k!Aa&\u000b\u0007\te%,A\u0002oKRLAA!(\u0003\u0018\nY\u0011J\\3u\u0003\u0012$'/Z:t\u0011!\u0011\t\u000b\u0001C\u0001\u0005\t\r\u0016!\u00039s_\u000e,7o]8s)\u0011\tiD!*\t\u0011\t\u001d&q\u0014a\u0001\u0003o\tQ!\u001b8eKbD\u0011Ba+\u0001#\u0003%\tA!,\u0002#M$\u0018M\u001d;va\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u00030*\"\u0011Q\u0014BYW\t\u0011\u0019\f\u0005\u0003\u00036\n}VB\u0001B\\\u0015\u0011\u0011ILa/\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B_\u0015\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u0005'q\u0017\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class SocketServer
implements KafkaMetricsGroup {
    private final KafkaConfig config;
    private final Metrics metrics;
    private final Time time;
    private final CredentialProvider credentialProvider;
    private final Integer maxQueuedRequests;
    private final LogContext logContext;
    private final Sensor memoryPoolSensor;
    private final MetricName memoryPoolDepletedPercentMetricName;
    private final MetricName memoryPoolDepletedTimeMetricName;
    private final MemoryPool kafka$network$SocketServer$$memoryPool;
    private final RequestChannel requestChannel;
    private final ConcurrentHashMap<Object, Processor> kafka$network$SocketServer$$processors;
    private int nextProcessorId;
    private final ConcurrentHashMap<EndPoint, Acceptor> acceptors;
    private ConnectionQuotas connectionQuotas;
    private boolean stoppedProcessingRequests;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public com.yammer.metrics.core.MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public com.yammer.metrics.core.MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        SocketServer socketServer = this;
        synchronized (socketServer) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public Time time() {
        return this.time;
    }

    public CredentialProvider credentialProvider() {
        return this.credentialProvider;
    }

    private Integer maxQueuedRequests() {
        return this.maxQueuedRequests;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private Sensor memoryPoolSensor() {
        return this.memoryPoolSensor;
    }

    private MetricName memoryPoolDepletedPercentMetricName() {
        return this.memoryPoolDepletedPercentMetricName;
    }

    private MetricName memoryPoolDepletedTimeMetricName() {
        return this.memoryPoolDepletedTimeMetricName;
    }

    public MemoryPool kafka$network$SocketServer$$memoryPool() {
        return this.kafka$network$SocketServer$$memoryPool;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    public ConcurrentHashMap<Object, Processor> kafka$network$SocketServer$$processors() {
        return this.kafka$network$SocketServer$$processors;
    }

    private int nextProcessorId() {
        return this.nextProcessorId;
    }

    private void nextProcessorId_$eq(int x$1) {
        this.nextProcessorId = x$1;
    }

    public ConcurrentHashMap<EndPoint, Acceptor> acceptors() {
        return this.acceptors;
    }

    private ConnectionQuotas connectionQuotas() {
        return this.connectionQuotas;
    }

    private void connectionQuotas_$eq(ConnectionQuotas x$1) {
        this.connectionQuotas = x$1;
    }

    private boolean stoppedProcessingRequests() {
        return this.stoppedProcessingRequests;
    }

    private void stoppedProcessingRequests_$eq(boolean x$1) {
        this.stoppedProcessingRequests = x$1;
    }

    public void startup(boolean startupProcessors) {
        SocketServer socketServer = this;
        synchronized (socketServer) {
            this.connectionQuotas_$eq(new ConnectionQuotas(Predef$.MODULE$.Integer2int(this.config().maxConnectionsPerIp()), this.config().maxConnectionsPerIpOverrides()));
            this.createAcceptorAndProcessors(Predef$.MODULE$.Integer2int(this.config().numNetworkThreads()), this.config().listeners());
            if (startupProcessors) {
                this.startProcessors();
            }
        }
        this.newGauge("NetworkProcessorAvgIdlePercent", new Gauge<Object>(this){
            private final /* synthetic */ SocketServer $outer;

            public double value() {
                double d;
                SocketServer socketServer = this.$outer;
                synchronized (socketServer) {
                    Iterable ioWaitRatioMetricNames = (Iterable)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.$outer.kafka$network$SocketServer$$processors().values()).asScala()).map((Function1 & Serializable & scala.Serializable)p -> $this.$outer.metrics().metricName("io-wait-ratio", "socket-server-metrics", p.metricTags()), Iterable$.MODULE$.canBuildFrom());
                    d = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)ioWaitRatioMetricNames.map((Function1 & Serializable & scala.Serializable)metricName -> BoxesRunTime.boxToDouble((double)$anon$1.$anonfun$value$2(this, metricName)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)this.$outer.kafka$network$SocketServer$$processors().size();
                }
                return d;
            }

            public static final /* synthetic */ double $anonfun$value$4(KafkaMetric m) {
                return Math.min(BoxesRunTime.unboxToDouble((Object)m.metricValue()), 1.0);
            }

            public static final /* synthetic */ double $anonfun$value$2($anon$1 $this, MetricName metricName) {
                return BoxesRunTime.unboxToDouble((Object)Option$.MODULE$.apply((Object)$this.$outer.metrics().metric(metricName)).fold((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, (Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToDouble((double)$anon$1.$anonfun$value$4(m))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$1(kafka.network.SocketServer$$anon$1 kafka.network.Processor ), $anonfun$value$2$adapted(kafka.network.SocketServer$$anon$1 org.apache.kafka.common.MetricName ), $anonfun$value$3(), $anonfun$value$4$adapted(org.apache.kafka.common.metrics.KafkaMetric )}, serializedLambda);
            }
        }, this.newGauge$default$3());
        this.newGauge("MemoryPoolAvailable", new Gauge<Object>(this){
            private final /* synthetic */ SocketServer $outer;

            public long value() {
                return this.$outer.kafka$network$SocketServer$$memoryPool().availableMemory();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("MemoryPoolUsed", new Gauge<Object>(this){
            private final /* synthetic */ SocketServer $outer;

            public long value() {
                return this.$outer.kafka$network$SocketServer$$memoryPool().size() - this.$outer.kafka$network$SocketServer$$memoryPool().availableMemory();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Started ").append(this.acceptors().size()).append(" acceptor threads").toString());
    }

    public boolean startup$default$1() {
        return true;
    }

    public synchronized void startProcessors() {
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.acceptors().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.startProcessors();
            return BoxedUnit.UNIT;
        });
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Started processors for ").append(this.acceptors().size()).append(" acceptors").toString());
    }

    private scala.collection.immutable.Map<ListenerName, EndPoint> endpoints() {
        return ((TraversableOnce)this.config().listeners().map((Function1 & Serializable & scala.Serializable)l -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)l.listenerName()), l), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private synchronized void createAcceptorAndProcessors(int processorsPerListener, Seq<EndPoint> endpoints) {
        Integer sendBufferSize = this.config().socketSendBufferBytes();
        Integer recvBufferSize = this.config().socketReceiveBufferBytes();
        int brokerId = this.config().brokerId();
        endpoints.foreach((Function1 & Serializable & scala.Serializable)endpoint -> {
            ListenerName listenerName = endpoint.listenerName();
            SecurityProtocol securityProtocol = endpoint.securityProtocol();
            Acceptor acceptor = new Acceptor((EndPoint)endpoint, Predef$.MODULE$.Integer2int(sendBufferSize), Predef$.MODULE$.Integer2int(recvBufferSize), brokerId, this.connectionQuotas());
            this.addProcessors(acceptor, (EndPoint)endpoint, processorsPerListener);
            KafkaThread.nonDaemon((String)new StringBuilder(24).append("kafka-socket-acceptor-").append(listenerName).append("-").append(securityProtocol).append("-").append(endpoint.port()).toString(), (Runnable)acceptor).start();
            acceptor.awaitStartup();
            return this.acceptors().put((EndPoint)endpoint, acceptor);
        });
    }

    private synchronized void addProcessors(Acceptor acceptor, EndPoint endpoint, int newProcessorsPerListener) {
        ListenerName listenerName = endpoint.listenerName();
        SecurityProtocol securityProtocol = endpoint.securityProtocol();
        ArrayBuffer listenerProcessors = new ArrayBuffer();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), newProcessorsPerListener).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            Processor processor = this.newProcessor(this.nextProcessorId(), this.connectionQuotas(), listenerName, securityProtocol, this.kafka$network$SocketServer$$memoryPool());
            listenerProcessors.$plus$eq((Object)processor);
            this.requestChannel().addProcessor(processor);
            this.nextProcessorId_$eq(this.nextProcessorId() + 1);
        });
        listenerProcessors.foreach((Function1 & Serializable & scala.Serializable)p -> this.kafka$network$SocketServer$$processors().put(BoxesRunTime.boxToInteger((int)p.id()), (Processor)p));
        acceptor.addProcessors((Buffer<Processor>)listenerProcessors);
    }

    public void stopProcessingRequests() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopping socket server request processors");
        SocketServer socketServer = this;
        synchronized (socketServer) {
            ((MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.acceptors()).asScala()).values().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.shutdown();
                return BoxedUnit.UNIT;
            });
            ((MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.kafka$network$SocketServer$$processors()).asScala()).values().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                x$3.shutdown();
                return BoxedUnit.UNIT;
            });
            this.requestChannel().clear();
            this.stoppedProcessingRequests_$eq(true);
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopped socket server request processors");
    }

    public synchronized void resizeThreadPool(int oldNumNetworkThreads, int newNumNetworkThreads) {
        block1: {
            block0: {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Resizing network thread pool size for each listener from ").append(oldNumNetworkThreads).append(" to ").append(newNumNetworkThreads).toString());
                if (newNumNetworkThreads <= oldNumNetworkThreads) break block0;
                ((IterableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.acceptors()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    SocketServer.$anonfun$resizeThreadPool$2(this, oldNumNetworkThreads, newNumNetworkThreads, x0$1);
                    return BoxedUnit.UNIT;
                });
                break block1;
            }
            if (newNumNetworkThreads >= oldNumNetworkThreads) break block1;
            ((MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.acceptors()).asScala()).values().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.removeProcessors(oldNumNetworkThreads - newNumNetworkThreads, this.requestChannel());
                return BoxedUnit.UNIT;
            });
        }
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down socket server");
        SocketServer socketServer = this;
        synchronized (socketServer) {
            if (!this.stoppedProcessingRequests()) {
                this.stopProcessingRequests();
            }
            this.requestChannel().shutdown();
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutdown completed");
    }

    public int boundPort(ListenerName listenerName) {
        int n;
        try {
            n = this.acceptors().get(this.endpoints().apply((Object)listenerName)).serverChannel().socket().getLocalPort();
        }
        catch (Exception e) {
            throw new KafkaException("Tried to check server's port before server was started or checked for port of non-existing protocol", (Throwable)e);
        }
        return n;
    }

    public synchronized void addListeners(Seq<EndPoint> listenersAdded) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Adding listeners for endpoints ").append(listenersAdded).toString());
        this.createAcceptorAndProcessors(Predef$.MODULE$.Integer2int(this.config().numNetworkThreads()), listenersAdded);
        this.startProcessors();
    }

    public synchronized void removeListeners(Seq<EndPoint> listenersRemoved) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Removing listeners for endpoints ").append(listenersRemoved).toString());
        listenersRemoved.foreach((Function1 & Serializable & scala.Serializable)endpoint -> {
            SocketServer.$anonfun$removeListeners$2(this, endpoint);
            return BoxedUnit.UNIT;
        });
    }

    public void updateMaxConnectionsPerIp(int maxConnectionsPerIp) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Updating maxConnectionsPerIp: ").append(maxConnectionsPerIp).toString());
        this.connectionQuotas().updateMaxConnectionsPerIp(maxConnectionsPerIp);
    }

    public void updateMaxConnectionsPerIpOverride(Map<String, Object> maxConnectionsPerIpOverrides) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Updating maxConnectionsPerIpOverrides: ").append(((TraversableOnce)maxConnectionsPerIpOverrides.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            int v = tuple2._2$mcI$sp();
            String string = new StringBuilder(1).append(k).append("=").append(v).toString();
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).mkString(",")).toString());
        this.connectionQuotas().updateMaxConnectionsPerIpOverride(maxConnectionsPerIpOverrides);
    }

    public Processor newProcessor(int id, ConnectionQuotas connectionQuotas, ListenerName listenerName, SecurityProtocol securityProtocol, MemoryPool memoryPool) {
        return new Processor(id, this.time(), Predef$.MODULE$.Integer2int(this.config().socketRequestMaxBytes()), this.requestChannel(), connectionQuotas, Predef$.MODULE$.Long2long(this.config().connectionsMaxIdleMs()), Predef$.MODULE$.Integer2int(this.config().failedAuthenticationDelayMs()), listenerName, securityProtocol, this.config(), this.metrics(), this.credentialProvider(), memoryPool, this.logContext());
    }

    public int connectionCount(InetAddress address) {
        return BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)this.connectionQuotas()).fold((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0, (Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.get(address))));
    }

    public Processor processor(int index) {
        return this.kafka$network$SocketServer$$processors().get(BoxesRunTime.boxToInteger((int)index));
    }

    public static final /* synthetic */ void $anonfun$resizeThreadPool$2(SocketServer $this, int oldNumNetworkThreads$1, int newNumNetworkThreads$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        EndPoint endpoint = (EndPoint)tuple2._1();
        Acceptor acceptor = (Acceptor)tuple2._2();
        $this.addProcessors(acceptor, endpoint, newNumNetworkThreads$1 - oldNumNetworkThreads$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$removeListeners$2(SocketServer $this, EndPoint endpoint) {
        ((scala.collection.mutable.MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter($this.acceptors()).asScala()).remove((Object)endpoint).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
    }

    public SocketServer(KafkaConfig config, Metrics metrics, Time time, CredentialProvider credentialProvider) {
        this.config = config;
        this.metrics = metrics;
        this.time = time;
        this.credentialProvider = credentialProvider;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.maxQueuedRequests = config.queuedMaxRequests();
        this.logContext = new LogContext(new StringBuilder(25).append("[SocketServer brokerId=").append(config.brokerId()).append("] ").toString());
        this.logIdent_$eq(this.logContext().logPrefix());
        this.memoryPoolSensor = metrics.sensor("MemoryPoolUtilization");
        this.memoryPoolDepletedPercentMetricName = metrics.metricName("MemoryPoolAvgDepletedPercent", "socket-server-metrics");
        this.memoryPoolDepletedTimeMetricName = metrics.metricName("MemoryPoolDepletedTimeTotal", "socket-server-metrics");
        this.memoryPoolSensor().add((CompoundStat)new org.apache.kafka.common.metrics.stats.Meter(TimeUnit.MILLISECONDS, this.memoryPoolDepletedPercentMetricName(), this.memoryPoolDepletedTimeMetricName()));
        this.kafka$network$SocketServer$$memoryPool = Predef$.MODULE$.Long2long(config.queuedMaxBytes()) > 0L ? new SimpleMemoryPool(Predef$.MODULE$.Long2long(config.queuedMaxBytes()), Predef$.MODULE$.Integer2int(config.socketRequestMaxBytes()), false, this.memoryPoolSensor()) : MemoryPool.NONE;
        this.requestChannel = new RequestChannel(Predef$.MODULE$.Integer2int(this.maxQueuedRequests()));
        this.kafka$network$SocketServer$$processors = new ConcurrentHashMap();
        this.nextProcessorId = 0;
        this.acceptors = new ConcurrentHashMap();
        this.stoppedProcessingRequests = false;
    }
}

