/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.TimeUnit;
import kafka.cluster.BrokerEndPoint;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.AbstractFetcherManager$;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerAndFetcherId;
import kafka.server.BrokerIdAndFetcherId;
import kafka.server.FetcherLagMetrics;
import kafka.server.InitialFetchState;
import kafka.server.OffsetAndEpoch;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichDouble$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005ed!B\u0001\u0003\u0003\u00039!AF!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:NC:\fw-\u001a:\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001)\"\u0001C\u001d\u0014\t\u0001Iq\"\u0006\t\u0003\u00155i\u0011a\u0003\u0006\u0002\u0019\u0005)1oY1mC&\u0011ab\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u0005A\u0019R\"A\t\u000b\u0005I!\u0011!B;uS2\u001c\u0018B\u0001\u000b\u0012\u0005\u001daunZ4j]\u001e\u0004\"AF\r\u000e\u0003]Q!\u0001\u0007\u0003\u0002\u000f5,GO]5dg&\u0011!d\u0006\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\b\u0002\u0003\u000f\u0001\u0005\u000b\u0007I\u0011A\u000f\u0002\t9\fW.Z\u000b\u0002=A\u0011qD\n\b\u0003A\u0011\u0002\"!I\u0006\u000e\u0003\tR!a\t\u0004\u0002\rq\u0012xn\u001c;?\u0013\t)3\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003O!\u0012aa\u0015;sS:<'BA\u0013\f\u0011!Q\u0003A!A!\u0002\u0013q\u0012!\u00028b[\u0016\u0004\u0003\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012D\u0001B\f\u0001\u0003\u0002\u0003\u0006IaL\u0001\f]Vlg)\u001a;dQ\u0016\u00148\u000f\u0005\u0002\u000ba%\u0011\u0011g\u0003\u0002\u0004\u0013:$\b\"B\u001a\u0001\t\u0003!\u0014A\u0002\u001fj]&$h\b\u0006\u00036\u0005\u000e#\u0005c\u0001\u001c\u0001o5\t!\u0001\u0005\u00029s1\u0001A!\u0002\u001e\u0001\u0005\u0004Y$!\u0001+\u0012\u0005qz\u0004C\u0001\u0006>\u0013\tq4BA\u0004O_RD\u0017N\\4\u0011\u0005Y\u0002\u0015BA!\u0003\u0005U\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012DQ\u0001\b\u001aA\u0002yAQ\u0001\f\u001aA\u0002yAQA\f\u001aA\u0002=B\u0001B\u0012\u0001C\u0002\u0013\u0005!aR\u0001\u0011M\u0016$8\r[3s)\"\u0014X-\u00193NCB,\u0012\u0001\u0013\t\u0005\u0013:\u0003v'D\u0001K\u0015\tYE*A\u0004nkR\f'\r\\3\u000b\u00055[\u0011AC2pY2,7\r^5p]&\u0011qJ\u0013\u0002\b\u0011\u0006\u001c\b.T1q!\t1\u0014+\u0003\u0002S\u0005\t!\"I]8lKJLE-\u00118e\r\u0016$8\r[3s\u0013\u0012Da\u0001\u0016\u0001!\u0002\u0013A\u0015!\u00054fi\u000eDWM\u001d+ie\u0016\fG-T1qA!9a\u000b\u0001b\u0001\n\u00139\u0016\u0001\u00027pG.,\u0012\u0001\u0017\t\u00033zk\u0011A\u0017\u0006\u00037r\u000bA\u0001\\1oO*\tQ,\u0001\u0003kCZ\f\u0017BA0[\u0005\u0019y%M[3di\"1\u0011\r\u0001Q\u0001\na\u000bQ\u0001\\8dW\u0002Bqa\u0019\u0001A\u0002\u0013%A-\u0001\u000bok64U\r^2iKJ\u001c\b+\u001a:Ce>\\WM]\u000b\u0002_!9a\r\u0001a\u0001\n\u00139\u0017\u0001\u00078v[\u001a+Go\u00195feN\u0004VM\u001d\"s_.,'o\u0018\u0013fcR\u0011\u0001n\u001b\t\u0003\u0015%L!A[\u0006\u0003\tUs\u0017\u000e\u001e\u0005\bY\u0016\f\t\u00111\u00010\u0003\rAH%\r\u0005\u0007]\u0002\u0001\u000b\u0015B\u0018\u0002+9,XNR3uG\",'o\u001d)fe\n\u0013xn[3sA!)\u0001\u000f\u0001C\u0001c\u0006\u0001\"/Z:ju\u0016$\u0006N]3bIB{w\u000e\u001c\u000b\u0003QJDQa]8A\u0002=\nqA\\3x'&TX\r\u0003\u0004v\u0001\u0011\u0005!A^\u0001\u000bO\u0016$h)\u001a;dQ\u0016\u0014HCA<{!\rQ\u0001pN\u0005\u0003s.\u0011aa\u00149uS>t\u0007\"B>u\u0001\u0004a\u0018A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0004{\u0006-Q\"\u0001@\u000b\u0007}\f\t!\u0001\u0004d_6lwN\u001c\u0006\u0004\u000b\u0005\r!\u0002BA\u0003\u0003\u000f\ta!\u00199bG\",'BAA\u0005\u0003\ry'oZ\u0005\u0004\u0003\u001bq(A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\t\u0003#\u0001A\u0011\u0001\u0002\u0002\u0014\u0005aq-\u001a;GKR\u001c\u0007.\u001a:JIR\u0019q&!\u0006\t\rm\fy\u00011\u0001}\u0011\u001d\tI\u0002\u0001C\u0001\u00037\t1$\\1sWB\u000b'\u000f^5uS>t7OR8s)J,hnY1uS>tGc\u00025\u0002\u001e\u0005\u0005\u00121\u0005\u0005\b\u0003?\t9\u00021\u00010\u0003!\u0011'o\\6fe&#\u0007BB>\u0002\u0018\u0001\u0007A\u0010\u0003\u0005\u0002&\u0005]\u0001\u0019AA\u0014\u0003A!(/\u001e8dCRLwN\\(gMN,G\u000fE\u0002\u000b\u0003SI1!a\u000b\f\u0005\u0011auN\\4\t\u000f\u0005=\u0002A\"\u0001\u00022\u0005\u00192M]3bi\u00164U\r^2iKJ$\u0006N]3bIR)q'a\r\u00028!9\u0011QGA\u0017\u0001\u0004y\u0013!\u00034fi\u000eDWM]%e\u0011!\tI$!\fA\u0002\u0005m\u0012\u0001D:pkJ\u001cWM\u0011:pW\u0016\u0014\b\u0003BA\u001f\u0003\u0007j!!a\u0010\u000b\u0007\u0005\u0005C!A\u0004dYV\u001cH/\u001a:\n\t\u0005\u0015\u0013q\b\u0002\u000f\u0005J|7.\u001a:F]\u0012\u0004v.\u001b8u\u0011\u001d\tI\u0005\u0001C\u0001\u0003\u0017\nq#\u00193e\r\u0016$8\r[3s\r>\u0014\b+\u0019:uSRLwN\\:\u0015\u0007!\fi\u0005\u0003\u0005\u0002P\u0005\u001d\u0003\u0019AA)\u0003M\u0001\u0018M\u001d;ji&|g.\u00118e\u001f\u001a47/\u001a;t!\u001d\t\u0019&!\u0016}\u00033j\u0011\u0001T\u0005\u0004\u0003/b%aA'baB\u0019a'a\u0017\n\u0007\u0005u#AA\tJ]&$\u0018.\u00197GKR\u001c\u0007n\u0015;bi\u0016Dq!!\u0019\u0001\t\u0003\t\u0019'\u0001\u000esK6|g/\u001a$fi\u000eDWM\u001d$peB\u000b'\u000f^5uS>t7\u000fF\u0002i\u0003KB\u0001\"a\u001a\u0002`\u0001\u0007\u0011\u0011N\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\b#BA*\u0003Wb\u0018bAA7\u0019\n\u00191+\u001a;\t\u000f\u0005E\u0004\u0001\"\u0001\u0002t\u0005Q2\u000f[;uI><h.\u00133mK\u001a+Go\u00195feRC'/Z1egR\t\u0001\u000eC\u0004\u0002x\u0001!\t!a\u001d\u0002!\rdwn]3BY24U\r^2iKJ\u001c\b")
public abstract class AbstractFetcherManager<T extends AbstractFetcherThread>
implements KafkaMetricsGroup {
    private final String name;
    private final HashMap<BrokerIdAndFetcherId, T> fetcherThreadMap;
    private final Object lock;
    private int numFetchersPerBroker;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        AbstractFetcherManager abstractFetcherManager = this;
        synchronized (abstractFetcherManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String name() {
        return this.name;
    }

    public HashMap<BrokerIdAndFetcherId, T> fetcherThreadMap() {
        return this.fetcherThreadMap;
    }

    private Object lock() {
        return this.lock;
    }

    private int numFetchersPerBroker() {
        return this.numFetchersPerBroker;
    }

    private void numFetchersPerBroker_$eq(int x$1) {
        this.numFetchersPerBroker = x$1;
    }

    public void resizeThreadPool(int newSize) {
        Object object = this.lock();
        synchronized (object) {
            int currentSize = this.numFetchersPerBroker();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Resizing fetcher thread pool size from ").append(currentSize).append(" to ").append(newSize).toString());
            this.numFetchersPerBroker_$eq(newSize);
            if (newSize != currentSize) {
                this.migratePartitions$1(newSize);
            }
            this.shutdownIdleFetcherThreads();
        }
    }

    public Option<T> getFetcher(TopicPartition topicPartition) {
        Option option;
        Object object = this.lock();
        synchronized (object) {
            int fetcherId = this.getFetcherId(topicPartition);
            option = this.fetcherThreadMap().values().find((Function1 & Serializable & scala.Serializable)fetcherThread -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$getFetcher$1(topicPartition, fetcherThread)));
        }
        return option;
    }

    public int getFetcherId(TopicPartition topicPartition) {
        int n;
        Object object = this.lock();
        synchronized (object) {
            n = Utils.abs((int)(31 * topicPartition.topic().hashCode() + topicPartition.partition())) % this.numFetchersPerBroker();
        }
        return n;
    }

    public void markPartitionsForTruncation(int brokerId, TopicPartition topicPartition, long truncationOffset) {
        Object object = this.lock();
        synchronized (object) {
            int fetcherId = this.getFetcherId(topicPartition);
            BrokerIdAndFetcherId brokerIdAndFetcherId = new BrokerIdAndFetcherId(brokerId, fetcherId);
            this.fetcherThreadMap().get((Object)brokerIdAndFetcherId).foreach((Function1 & Serializable & scala.Serializable)thread -> {
                thread.markPartitionsForTruncation(topicPartition, truncationOffset);
                return BoxedUnit.UNIT;
            });
        }
    }

    public abstract T createFetcherThread(int var1, BrokerEndPoint var2);

    public void addFetcherForPartitions(Map<TopicPartition, InitialFetchState> partitionAndOffsets) {
        Object object = this.lock();
        synchronized (object) {
            scala.collection.immutable.Map partitionsPerFetcher = partitionAndOffsets.groupBy((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                InitialFetchState brokerAndInitialFetchOffset = (InitialFetchState)tuple2._2();
                BrokerAndFetcherId brokerAndFetcherId = new BrokerAndFetcherId(brokerAndInitialFetchOffset.leader(), this.getFetcherId(topicPartition));
                return brokerAndFetcherId;
            });
            partitionsPerFetcher.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$addFetcherForPartitions$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                AbstractFetcherManager.$anonfun$addFetcherForPartitions$3(this, x$2);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void removeFetcherForPartitions(Set<TopicPartition> partitions) {
        Object object = this.lock();
        synchronized (object) {
            this.fetcherThreadMap().values().foreach((Function1 & Serializable & scala.Serializable)fetcher -> {
                fetcher.removePartitions((Set<TopicPartition>)partitions);
                return BoxedUnit.UNIT;
            });
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Removed fetcher for partitions ").append(partitions).toString());
    }

    public void shutdownIdleFetcherThreads() {
        Object object = this.lock();
        synchronized (object) {
            HashSet keysToBeRemoved = new HashSet();
            this.fetcherThreadMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$shutdownIdleFetcherThreads$1(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                BoxedUnit boxedUnit;
                Tuple2 tuple2 = x$3;
                if (tuple2 != null) {
                    BrokerIdAndFetcherId key = (BrokerIdAndFetcherId)tuple2._1();
                    AbstractFetcherThread fetcher = (AbstractFetcherThread)tuple2._2();
                    if (fetcher.partitionCount() <= 0) {
                        fetcher.shutdown();
                        boxedUnit = keysToBeRemoved.$plus$eq((Object)key);
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                BoxedUnit boxedUnit2 = boxedUnit;
                return boxedUnit2;
            });
            HashMap cfr_ignored_0 = (HashMap)this.fetcherThreadMap().$minus$minus$eq((TraversableOnce)keysToBeRemoved);
        }
    }

    public void closeAllFetchers() {
        Object object = this.lock();
        synchronized (object) {
            this.fetcherThreadMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$closeAllFetchers$1(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$closeAllFetchers$2(x$4)));
            this.fetcherThreadMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$closeAllFetchers$3(check$ifrefutable$4))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                AbstractFetcherManager.$anonfun$closeAllFetchers$4(x$5);
                return BoxedUnit.UNIT;
            });
            this.fetcherThreadMap().clear();
        }
    }

    public static final /* synthetic */ void $anonfun$resizeThreadPool$1(AbstractFetcherManager $this, int newSize$2, Tuple2 x0$1) {
        Map<TopicPartition, InitialFetchState> removedPartitions;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            BrokerIdAndFetcherId id = (BrokerIdAndFetcherId)tuple2._1();
            AbstractFetcherThread thread = (AbstractFetcherThread)tuple2._2();
            removedPartitions = thread.partitionsAndOffsets();
            $this.removeFetcherForPartitions((Set<TopicPartition>)removedPartitions.keySet());
            if (id.fetcherId() >= newSize$2) {
                thread.shutdown();
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        $this.addFetcherForPartitions(removedPartitions);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void migratePartitions$1(int newSize) {
        this.fetcherThreadMap().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AbstractFetcherManager.$anonfun$resizeThreadPool$1(this, newSize, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getFetcher$1(TopicPartition topicPartition$1, AbstractFetcherThread fetcherThread) {
        return fetcherThread.fetchState(topicPartition$1).isDefined();
    }

    /*
     * WARNING - void declaration
     */
    private final AbstractFetcherThread addAndStartFetcherThread$1(BrokerAndFetcherId brokerAndFetcherId, BrokerIdAndFetcherId brokerIdAndFetcherId) {
        void var3_3;
        T fetcherThread = this.createFetcherThread(brokerAndFetcherId.fetcherId(), brokerAndFetcherId.broker());
        this.fetcherThreadMap().put((Object)brokerIdAndFetcherId, fetcherThread);
        ((Thread)fetcherThread).start();
        return var3_3;
    }

    public static final /* synthetic */ boolean $anonfun$addFetcherForPartitions$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ Tuple2 $anonfun$addFetcherForPartitions$4(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        InitialFetchState brokerAndInitOffset = (InitialFetchState)tuple2._2();
        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new OffsetAndEpoch(brokerAndInitOffset.initOffset(), brokerAndInitOffset.currentLeaderEpoch()));
        return tuple22;
    }

    public static final /* synthetic */ String $anonfun$addFetcherForPartitions$5(BrokerAndFetcherId brokerAndFetcherId$1, Map initialOffsetAndEpochs$1) {
        return new StringBuilder(40).append("Added fetcher to broker ").append(brokerAndFetcherId$1.broker()).append(" for partitions ").append(initialOffsetAndEpochs$1).toString();
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$addFetcherForPartitions$3(AbstractFetcherManager $this, Tuple2 x$2) {
        var4_2 = x$2;
        if (var4_2 == null) ** GOTO lbl27
        brokerAndFetcherId = (BrokerAndFetcherId)var4_2._1();
        initialFetchOffsets = (Map)var4_2._2();
        brokerIdAndFetcherId = new BrokerIdAndFetcherId(brokerAndFetcherId.broker().id(), brokerAndFetcherId.fetcherId());
        var9_6 = false;
        var10_7 = null;
        var11_8 = $this.fetcherThreadMap().get((Object)brokerIdAndFetcherId);
        if (!(var11_8 instanceof Some)) ** GOTO lbl-1000
        var9_6 = true;
        var10_7 = (Some)var11_8;
        currentFetcherThread = (AbstractFetcherThread)var10_7.value();
        v0 = currentFetcherThread.sourceBroker();
        var13_10 = brokerAndFetcherId.broker();
        if (!(v0 != null ? v0.equals(var13_10) == false : var13_10 != null)) {
            var3_11 = currentFetcherThread;
        } else if (var9_6) {
            f = (AbstractFetcherThread)var10_7.value();
            f.shutdown();
            var3_11 = $this.addAndStartFetcherThread$1(brokerAndFetcherId, brokerIdAndFetcherId);
        } else if (None$.MODULE$.equals(var11_8)) {
            var3_11 = $this.addAndStartFetcherThread$1(brokerAndFetcherId, brokerIdAndFetcherId);
        } else {
            throw new MatchError((Object)var11_8);
lbl27:
            // 1 sources

            throw new MatchError((Object)var4_2);
        }
        fetcherThread = var3_11;
        initialOffsetAndEpochs = (Map)initialFetchOffsets.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$addFetcherForPartitions$4(scala.Tuple2 ), (Lscala/Tuple2;)Lscala/Tuple2;)(), Map$.MODULE$.canBuildFrom());
        fetcherThread.addPartitions((Map<TopicPartition, OffsetAndEpoch>)initialOffsetAndEpochs);
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$addFetcherForPartitions$5(kafka.server.BrokerAndFetcherId scala.collection.Map ), ()Ljava/lang/String;)((BrokerAndFetcherId)brokerAndFetcherId, (Map)initialOffsetAndEpochs));
        var2_15 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$shutdownIdleFetcherThreads$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$1(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$2(Tuple2 x$4) {
        Tuple2 tuple2 = x$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        AbstractFetcherThread fetcher = (AbstractFetcherThread)tuple2._2();
        boolean bl = fetcher.initiateShutdown();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$3(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$closeAllFetchers$4(Tuple2 x$5) {
        Tuple2 tuple2 = x$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        AbstractFetcherThread fetcher = (AbstractFetcherThread)tuple2._2();
        fetcher.shutdown();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public AbstractFetcherManager(String name, String clientId, int numFetchers) {
        this.name = name;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.fetcherThreadMap = new HashMap();
        this.lock = new Object();
        this.numFetchersPerBroker = numFetchers;
        this.logIdent_$eq(new StringBuilder(3).append("[").append(name).append("] ").toString());
        this.newGauge("MaxLag", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public long value() {
                return BoxesRunTime.unboxToLong((Object)this.$outer.fetcherThreadMap().foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(curMaxAll, fetcherThreadMapEntry) -> BoxesRunTime.boxToLong((long)$anon$1.$anonfun$value$1(BoxesRunTime.unboxToLong((Object)curMaxAll), fetcherThreadMapEntry))));
            }

            public static final /* synthetic */ long $anonfun$value$2(long curMaxThread, Tuple2 fetcherLagStatsEntry) {
                return RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(curMaxThread), ((FetcherLagMetrics)fetcherLagStatsEntry._2()).lag());
            }

            public static final /* synthetic */ long $anonfun$value$1(long curMaxAll, Tuple2 fetcherThreadMapEntry) {
                return RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong((Object)((AbstractFetcherThread)fetcherThreadMapEntry._2()).fetcherLagStats().stats().foldLeft(BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(curMaxThread, fetcherLagStatsEntry) -> BoxesRunTime.boxToLong((long)$anon$1.$anonfun$value$2(BoxesRunTime.unboxToLong((Object)curMaxThread), fetcherLagStatsEntry))))), curMaxAll);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$1$adapted(java.lang.Object scala.Tuple2 ), $anonfun$value$2$adapted(java.lang.Object scala.Tuple2 )}, serializedLambda);
            }
        }, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clientId"), (Object)clientId)}))));
        this.newGauge("MinFetchRate", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public double value() {
                double headRate = BoxesRunTime.unboxToDouble((Object)this.$outer.fetcherThreadMap().headOption().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)$anon$2.$anonfun$value$3(x$1))).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0));
                return BoxesRunTime.unboxToDouble((Object)this.$outer.fetcherThreadMap().foldLeft((Object)BoxesRunTime.boxToDouble((double)headRate), (Function2 & Serializable & scala.Serializable)(curMinAll, fetcherThreadMapEntry) -> BoxesRunTime.boxToDouble((double)$anon$2.$anonfun$value$5(BoxesRunTime.unboxToDouble((Object)curMinAll), fetcherThreadMapEntry))));
            }

            public static final /* synthetic */ double $anonfun$value$3(Tuple2 x$1) {
                return ((AbstractFetcherThread)x$1._2()).fetcherStats().requestRate().oneMinuteRate();
            }

            public static final /* synthetic */ double $anonfun$value$5(double curMinAll, Tuple2 fetcherThreadMapEntry) {
                return RichDouble$.MODULE$.min$extension(Predef$.MODULE$.doubleWrapper(((AbstractFetcherThread)fetcherThreadMapEntry._2()).fetcherStats().requestRate().oneMinuteRate()), curMinAll);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$3$adapted(scala.Tuple2 ), $anonfun$value$4(), $anonfun$value$5$adapted(java.lang.Object scala.Tuple2 )}, serializedLambda);
            }
        }, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clientId"), (Object)clientId)}))));
    }
}

