/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import kafka.admin.ConfigCommand;
import kafka.admin.ConfigCommand$;
import kafka.admin.ConfigCommandTest;
import kafka.admin.ConfigCommandTest$CredentialChange$2$;
import kafka.api.ApiVersion$;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig$;
import kafka.utils.Exit$;
import kafka.utils.PasswordEncoder;
import kafka.zk.AdminZkClient;
import kafka.zk.BrokerInfo;
import kafka.zk.BrokerInfo$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramCredentialUtils;
import org.apache.kafka.common.utils.Sanitizer;
import org.easymock.EasyMock;
import org.easymock.IExpectationSetters;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t]c\u0001B\u00181\u0001UBQA\u0011\u0001\u0005\u0002\rCQA\u0012\u0001\u0005\u0002\u001dCQa\u0016\u0001\u0005\u0002\u001dCQ!\u0017\u0001\u0005\u0002\u001dCQa\u0017\u0001\u0005\nqCQ!\u001c\u0001\u0005\u0002\u001dCQa\u001c\u0001\u0005\u0002\u001dCQ!\u001d\u0001\u0005\u0002\u001dCQa\u001d\u0001\u0005\u0002\u001dCQ!\u001e\u0001\u0005\u0002YDqA \u0001\u0012\u0002\u0013\u0005q\u0010\u0003\u0004\u0002\u0016\u0001!\ta\u0012\u0005\u0007\u0003_\u0001A\u0011A$\t\r\u0005M\u0002\u0001\"\u0001H\u0011\u0019\t9\u0004\u0001C\u0001\u000f\"1\u00111\b\u0001\u0005\u0002\u001dCa!a\u0010\u0001\t\u00039\u0005BBA\"\u0001\u0011\u0005q\t\u0003\u0004\u0002H\u0001!\ta\u0012\u0005\u0007\u0003\u0017\u0002A\u0011A$\t\r\u0005=\u0003\u0001\"\u0001H\u0011\u0019\t\u0019\u0006\u0001C\u0001\u000f\"1\u0011q\u000b\u0001\u0005\u0002\u001dCa!a\u001d\u0001\t\u00039\u0005bBA<\u0001\u0011\u0005\u0011\u0011\u0010\u0005\b\u0003+\u0003A\u0011AAL\u0011\u0019\t)\f\u0001C\u0001\u000f\"1\u0011\u0011\u0018\u0001\u0005\u0002\u001dCa!!0\u0001\t\u00039\u0005BBAa\u0001\u0011\u0005q\t\u0003\u0004\u0002F\u0002!\ta\u0012\u0005\u0007\u0003\u0013\u0004A\u0011A$\t\r\u00055\u0007\u0001\"\u0001H\u0011\u0019\t\t\u000e\u0001C\u0001\u000f\"1\u0011Q\u001b\u0001\u0005\u0002\u001dCa!!7\u0001\t\u00039\u0005BBAo\u0001\u0011\u0005q\tC\u0004\u0002b\u0002!I!a9\u0007\r\u0005=\b\u0001AAy\u0011)\tIp\nB\u0001B\u0003%\u00111 \u0005\u0007\u0005\u001e\"\tA!\u0001\t\u000f\t%q\u0005\"\u0011\u0003\f!9!\u0011G\u0014\u0005B\tM\u0002b\u0002B\u001dO\u0011\u0005#1\b\u0005\b\u0005\u0007:C\u0011\tB#\u0011\u001d\u0011ie\nC!\u0005\u001f\u0012\u0011cQ8oM&<7i\\7nC:$G+Z:u\u0015\t\t$'A\u0003bI6LgNC\u00014\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u001c=!\t9$(D\u00019\u0015\tI$'\u0001\u0002{W&\u00111\b\u000f\u0002\u00155>|7*Z3qKJ$Vm\u001d;ICJtWm]:\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}\u0012\u0014!B;uS2\u001c\u0018BA!?\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#\u0001#\u0011\u0005\u0015\u0003Q\"\u0001\u0019\u0002KMDw.\u001e7e\u000bbLGoV5uQ:{gNW3s_N#\u0018\r^;t\u001f:\f%oZ#se>\u0014H#\u0001%\u0011\u0005%cU\"\u0001&\u000b\u0003-\u000bQa]2bY\u0006L!!\u0014&\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005=\u0003\"\u0001U+\u000e\u0003ES!AU*\u0002\u000b),h.\u001b;\u000b\u0003Q\u000b1a\u001c:h\u0013\t1\u0016K\u0001\u0003UKN$\u0018aK:i_VdG-\u0012=ji^KG\u000f\u001b(p]j+'o\\*uCR,8o\u00148[W\u000e{W.\\1oI\u0016\u0013(o\u001c:)\u0005\ry\u0015aL:i_VdG-\u0012=ji^KG\u000f\u001b(p]j+'o\\*uCR,8o\u00148Ce>\\WM]\"p[6\fg\u000eZ#se>\u0014\bF\u0001\u0003P\u0003]\t7o]3si:{gNW3s_N#\u0018\r^;t\u000bbLG\u000f\u0006\u0002I;\")a,\u0002a\u0001?\u0006!\u0011M]4t!\rI\u0005MY\u0005\u0003C*\u0013Q!\u0011:sCf\u0004\"a\u00196\u000f\u0005\u0011D\u0007CA3K\u001b\u00051'BA45\u0003\u0019a$o\\8u}%\u0011\u0011NS\u0001\u0007!J,G-\u001a4\n\u0005-d'AB*ue&twM\u0003\u0002j\u0015\u0006A3\u000f[8vY\u0012\u0004\u0016M]:f\u0003J<W/\\3oiN4uN]\"mS\u0016tGo]#oi&$\u0018\u0010V=qK\"\u0012aaT\u0001(g\"|W\u000f\u001c3QCJ\u001cX-\u0011:hk6,g\u000e^:G_J$v\u000e]5dg\u0016sG/\u001b;z)f\u0004X\r\u000b\u0002\b\u001f\u0006A3\u000f[8vY\u0012\u0004\u0016M]:f\u0003J<W/\\3oiN4uN\u001d\"s_.,'o]#oi&$\u0018\u0010V=qK\"\u0012\u0001bT\u0001/g\"|W\u000f\u001c3QCJ\u001cX-\u0011:hk6,g\u000e^:G_J\u0014%o\\6fe2{wmZ3sg\u0016sG/\u001b;z)f\u0004X\r\u000b\u0002\n\u001f\u0006\tB/Z:u\u0003J<W/\\3oiB\u000b'o]3\u0015\u0007!;\u0018\u0010C\u0003y\u0015\u0001\u0007!-\u0001\u0006f]RLG/\u001f+za\u0016DqA\u001f\u0006\u0011\u0002\u0003\u000710\u0001\u0005{W\u000e{gNZ5h!\tIE0\u0003\u0002~\u0015\n9!i\\8mK\u0006t\u0017a\u0007;fgR\f%oZ;nK:$\b+\u0019:tK\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\u0002)\u001a10a\u0001,\u0005\u0005\u0015\u0001\u0003BA\u0004\u0003#i!!!\u0003\u000b\t\u0005-\u0011QB\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0004K\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003'\tIAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f!e\u001d5pk2$g)Y5m\u0013\u001a,fN]3d_\u001et\u0017n]3e\u000b:$\u0018\u000e^=UsB,\u0007F\u0002\u0007P\u00033\tY\"\u0001\u0005fqB,7\r^3eG\t\ti\u0002\u0005\u0003\u0002 \u0005%b\u0002BA\u0011\u0003Kq1!ZA\u0012\u0013\u0005Y\u0015bAA\u0014\u0015\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u0016\u0003[\u0011\u0001$\u00137mK\u001e\fG.\u0011:hk6,g\u000e^#yG\u0016\u0004H/[8o\u0015\r\t9CS\u0001+g\"|W\u000f\u001c3GC&d\u0017J\u001a\"s_.,'/\u00128uSRLH+\u001f9f\u0013Ntu\u000e^!o\u0013:$XmZ3sQ\u0019iq*!\u0007\u0002\u001c\u0005)2\u000f[8vY\u0012\fE\rZ\"mS\u0016tGoQ8oM&<\u0007F\u0001\bP\u0003Q\u0019\bn\\;mI\u0006#G\rV8qS\u000e\u001cuN\u001c4jO\"\u0012qbT\u0001\u001bg\"|W\u000f\u001c3BI\u0012\u0014%o\\6feF+x\u000e^1D_:4\u0017n\u001a\u0015\u0003!=\u000bAd\u001d5pk2$\u0017\t\u001a3Ce>\\WM\u001d#z]\u0006l\u0017nY\"p]\u001aLw\r\u000b\u0002\u0012\u001f\u0006Y2\u000f[8vY\u0012\fE\r\u001a\"s_.,'\u000fT8hO\u0016\u00148i\u001c8gS\u001eD#AE(\u0002wQ,7\u000f\u001e(p'B,7-\u001b4jK\u0012,e\u000e^5us>\u0003H/[8o/&$\b\u000eR3tGJL'-\u001a\"s_.,'o]%o5.K5/\u00117m_^,G\r\u000b\u0002\u0014\u001f\u0006YE/Z:u\u001d>\u001c\u0006/Z2jM&,G-\u00128uSRLx\n\u001d;j_:<\u0016\u000e\u001e5EKN\u001c'/\u001b2f\u0005J|7.\u001a:t\u0013:\u0014un\u001c;tiJ\f\u0007oU3sm\u0016\u0014\u0018j\u001d(pi\u0006cGn\\<fI\"2AcTA\r\u00037\t1\b^3ti\u0016sG/\u001b;z\t\u00164\u0017-\u001e7u\u001fB$\u0018n\u001c8XSRDG)Z:de&\u0014WM\u0011:pW\u0016\u0014Hj\\4hKJL5OT8u\u00032dwn^3eQ\u0019)r*!\u0007\u0002\u001c\u0005AD/Z:u\u000b:$\u0018\u000e^=EK\u001a\fW\u000f\u001c;PaRLwN\\,ji\"\fE\u000e^3s\u0005J|7.\u001a:M_\u001e<WM]%t\u001d>$\u0018\t\u001c7po\u0016$\u0007F\u0002\fP\u00033\tY\"A&tQ>,H\u000e\u001a*bSN,\u0017J\u001c<bY&$7i\u001c8gS\u001e,(/\u0019;j_:,\u0005pY3qi&|gn\u00165f]\u0006#G-\u001b8h\u0013:4\u0018\r\\5e\u0005J|7.\u001a:M_\u001e<WM]\"p]\u001aLw\r\u000b\u0004\u0018\u001f\u0006e\u00111L\u0012\u0003\u0003;\u0002B!a\u0018\u0002p5\u0011\u0011\u0011\r\u0006\u0005\u0003G\n)'\u0001\u0004feJ|'o\u001d\u0006\u0005\u0003O\nI'\u0001\u0004d_6lwN\u001c\u0006\u0004g\u0005-$bAA7'\u00061\u0011\r]1dQ\u0016LA!!\u001d\u0002b\ti\u0012J\u001c<bY&$7i\u001c8gS\u001e,(/\u0019;j_:,\u0005pY3qi&|g.A\u0012tQ>,H\u000eZ!eI\u0012+g-Y;mi\n\u0013xn[3s\tft\u0017-\\5d\u0007>tg-[4)\u0005ay\u0015a\u0006<fe&4\u00170\u00117uKJ\u0014%o\\6fe\u000e{gNZ5h)\u001dA\u00151PAD\u0003\u0017Cq!! \u001a\u0001\u0004\ty(\u0001\u0003o_\u0012,\u0007\u0003BAA\u0003\u0007k!!!\u001a\n\t\u0005\u0015\u0015Q\r\u0002\u0005\u001d>$W\r\u0003\u0004\u0002\nf\u0001\rAY\u0001\re\u0016\u001cx.\u001e:dK:\u000bW.\u001a\u0005\b\u0003\u001bK\u0002\u0019AAH\u00031\u0011Xm]8ve\u000e,w\n\u001d;t!\u0015\ty\"!%c\u0013\u0011\t\u0019*!\f\u0003\t1K7\u000f^\u0001\u001em\u0016\u0014\u0018NZ=BYR,'O\u0011:pW\u0016\u0014Hj\\4hKJ\u001cuN\u001c4jORI\u0001*!'\u0002\u001c\u0006u\u0015\u0011\u0015\u0005\b\u0003{R\u0002\u0019AA@\u0011\u0019\tII\u0007a\u0001E\"1\u0011q\u0014\u000eA\u0002\t\f!\"\u001a8uSRLh*Y7f\u0011\u001d\t\u0019K\u0007a\u0001\u0003K\u000bQ\u0003Z3tGJL'-Z\"p]\u001aLw-\u00128ue&,7\u000f\u0005\u0004\u0002 \u0005E\u0015q\u0015\t\u0005\u0003S\u000b\t,\u0004\u0002\u0002,*\u0019\u0011'!,\u000b\t\u0005=\u0016\u0011N\u0001\bG2LWM\u001c;t\u0013\u0011\t\u0019,a+\u0003\u0017\r{gNZ5h\u000b:$(/_\u0001\"g\"|W\u000f\u001c3TkB\u0004xN\u001d;D_6l\u0017mU3qCJ\fG/\u001a3WC2,Xm\u001d\u0015\u00037=\u000b\u0001g\u001d5pk2$gj\u001c;Va\u0012\fG/\u001a\"s_.,'oQ8oM&<\u0017JZ'bY\u001a|'/\\3e\u000b:$\u0018\u000e^=OC6,\u0007F\u0002\u000fP\u00033\tY\"A\u0016uKN$H)\u001f8b[&\u001c'I]8lKJ\u001cuN\u001c4jOV\u0003H-\u0019;f+NLgn\u001a.p_.+W\r]3sQ\tir*\u0001\u0017tQ>,H\u000e\u001a(piV\u0003H-\u0019;f\u0005J|7.\u001a:D_:4\u0017nZ%g\u001b\u0006dgm\u001c:nK\u0012\u001cuN\u001c4jO\"2adTA\r\u00037\t1g\u001d5pk2$gj\u001c;Va\u0012\fG/\u001a\"s_.,'oQ8oM&<\u0017JZ'bY\u001a|'/\\3e\u0005J\f7m[3u\u0007>tg-[4)\r}y\u0015\u0011DA\u000e\u0003]\u001a\bn\\;mI:{G/\u00169eCR,'I]8lKJ\u001cuN\u001c4jO&3gj\u001c8Fq&\u001cH/\u001b8h\u0007>tg-[4Jg\u0012+G.\u001a;fI\"2\u0001eTA\r\u00037\n\u0001d\u001d5pk2$G)\u001a7fi\u0016\u0014%o\\6fe\u000e{gNZ5hQ\t\ts*\u0001\u000buKN$8k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d\u0015\u0003E=\u000bQ\u0003^3tiF+x\u000e^1D_:4\u0017nZ#oi&$\u0018\u0010\u000b\u0002$\u001f\u00069B/Z:u+N,'o\u00117jK:$\u0018+^8uC>\u0003Ho\u001d\u0015\u0003I=\u000b\u0011\u0004^3tiF+x\u000e^1EKN\u001c'/\u001b2f\u000b:$\u0018\u000e^5fg\"\u0012QeT\u0001\u0013e\u0016<\u0017n\u001d;fe\n\u0013xn[3s\u0013:T6\u000eF\u0002I\u0003KDq!a:'\u0001\u0004\tI/\u0001\u0002jIB\u0019\u0011*a;\n\u0007\u00055(JA\u0002J]R\u0014!\u0003R;n[f\fE-\\5o5.\u001cE.[3oiN\u0019q%a=\u0011\u0007]\n)0C\u0002\u0002xb\u0012Q\"\u00113nS:T6n\u00117jK:$\u0018\u0001\u0003>l\u00072LWM\u001c;\u0011\u0007]\ni0C\u0002\u0002\u0000b\u0012QbS1gW\u0006T6n\u00117jK:$H\u0003\u0002B\u0002\u0005\u000f\u00012A!\u0002(\u001b\u0005\u0001\u0001bBA}S\u0001\u0007\u00111`\u0001\u0013G\"\fgnZ3Ce>\\WM]\"p]\u001aLw\rF\u0003I\u0005\u001b\u0011i\u0002C\u0004\u0003\u0010)\u0002\rA!\u0005\u0002\u0013\t\u0014xn[3s\u0013\u0012\u001c\bC\u0002B\n\u00053\tI/\u0004\u0002\u0003\u0016)\u0019!q\u0003&\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003\u001c\tU!aA*fc\"9!q\u0004\u0016A\u0002\t\u0005\u0012aB2p]\u001aLwm\u001d\t\u0005\u0005G\u0011i#\u0004\u0002\u0003&)!!q\u0005B\u0015\u0003\u0011)H/\u001b7\u000b\u0005\t-\u0012\u0001\u00026bm\u0006LAAa\f\u0003&\tQ\u0001K]8qKJ$\u0018.Z:\u0002#\u0019,Go\u00195F]RLG/_\"p]\u001aLw\r\u0006\u0004\u0003\"\tU\"q\u0007\u0005\u0006q.\u0002\rA\u0019\u0005\u0007\u0003?[\u0003\u0019\u00012\u0002)\rD\u0017M\\4f\u00072LWM\u001c;JI\u000e{gNZ5h)\u0015A%Q\bB!\u0011\u0019\u0011y\u0004\fa\u0001E\u0006A1\r\\5f]RLE\rC\u0004\u0003 1\u0002\rA!\t\u0002=\rD\u0017M\\4f+N,'o\u0014:Vg\u0016\u00148\t\\5f]RLEmQ8oM&<G#\u0002%\u0003H\t-\u0003B\u0002B%[\u0001\u0007!-A\ntC:LG/\u001b>fI\u0016sG/\u001b;z\u001d\u0006lW\rC\u0004\u0003 5\u0002\rA!\t\u0002#\rD\u0017M\\4f)>\u0004\u0018nY\"p]\u001aLw\rF\u0003I\u0005#\u0012)\u0006\u0003\u0004\u0003T9\u0002\rAY\u0001\u0006i>\u0004\u0018n\u0019\u0005\b\u0005?q\u0003\u0019\u0001B\u0011\u0001")
public class ConfigCommandTest
extends ZooKeeperTestHarness {
    @Test
    public void shouldExitWithNonZeroStatusOnArgError() {
        this.assertNonZeroStatusExit((String[])((Object[])new String[]{"--blah"}));
    }

    @Test
    public void shouldExitWithNonZeroStatusOnZkCommandError() {
        this.assertNonZeroStatusExit((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "security.inter.broker.protocol=PLAINTEXT"}));
    }

    @Test
    public void shouldExitWithNonZeroStatusOnBrokerCommandError() {
        this.assertNonZeroStatusExit((String[])((Object[])new String[]{"--bootstrap-server", "invalid host", "--entity-type", "brokers", "--entity-name", "1", "--describe"}));
    }

    private void assertNonZeroStatusExit(String[] args) {
        ObjectRef exitStatus = ObjectRef.create((Object)None$.MODULE$);
        Exit$.MODULE$.setExitProcedure((Function2 & Serializable & scala.Serializable)(status, x$1) -> ConfigCommandTest.$anonfun$assertNonZeroStatusExit$1(exitStatus, BoxesRunTime.unboxToInt((Object)status), x$1));
        try {
            try {
                ConfigCommand$.MODULE$.main(args);
            }
            catch (RuntimeException runtimeException) {}
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)((Option)exitStatus.elem));
    }

    @Test
    public void shouldParseArgumentsForClientsEntityType() {
        this.testArgumentParse("clients", this.testArgumentParse$default$2());
    }

    @Test
    public void shouldParseArgumentsForTopicsEntityType() {
        this.testArgumentParse("topics", this.testArgumentParse$default$2());
    }

    @Test
    public void shouldParseArgumentsForBrokersEntityType() {
        this.testArgumentParse("brokers", this.testArgumentParse$default$2());
    }

    @Test
    public void shouldParseArgumentsForBrokerLoggersEntityType() {
        this.testArgumentParse("broker-loggers", false);
    }

    public void testArgumentParse(String entityType, boolean zkConfig) {
        Tuple2 connectOpts = zkConfig ? new Tuple2((Object)"--zookeeper", (Object)this.zkConnect()) : new Tuple2((Object)"--bootstrap-server", (Object)"localhost:9092");
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{(String)connectOpts._1(), (String)connectOpts._2(), "--entity-name", "1", "--entity-type", entityType, "--describe"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{(String)connectOpts._1(), (String)connectOpts._2(), "--entity-name", "1", "--entity-type", entityType, "--alter", "--add-config", "a=b,c=d"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{(String)connectOpts._1(), (String)connectOpts._2(), "--entity-name", "1", "--entity-type", entityType, "--alter", "--delete-config", "a,b,c"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{(String)connectOpts._1(), (String)connectOpts._2(), "--entity-name", "1", "--entity-type", entityType, "--alter", "--add-config", "a=b,c=d", "--delete-config", "a"}));
        createOpts.checkArgs();
        Properties addedProps = ConfigCommand$.MODULE$.parseConfigsToBeAdded(createOpts);
        Assert.assertEquals((long)2L, (long)addedProps.size());
        Assert.assertEquals((Object)"b", (Object)addedProps.getProperty("a"));
        Assert.assertEquals((Object)"d", (Object)addedProps.getProperty("c"));
        Seq deletedProps = ConfigCommand$.MODULE$.parseConfigsToBeDeleted(createOpts);
        Assert.assertEquals((long)1L, (long)deletedProps.size());
        Assert.assertEquals((Object)"a", (Object)deletedProps.head());
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{(String)connectOpts._1(), (String)connectOpts._2(), "--entity-name", "1", "--entity-type", entityType, "--alter", "--add-config", "a=b,c=,d=e,f="}));
        createOpts.checkArgs();
        Properties addedProps2 = ConfigCommand$.MODULE$.parseConfigsToBeAdded(createOpts);
        Assert.assertEquals((long)4L, (long)addedProps2.size());
        Assert.assertEquals((Object)"b", (Object)addedProps2.getProperty("a"));
        Assert.assertEquals((Object)"e", (Object)addedProps2.getProperty("d"));
        Assert.assertTrue((boolean)addedProps2.getProperty("c").isEmpty());
        Assert.assertTrue((boolean)addedProps2.getProperty("f").isEmpty());
    }

    public boolean testArgumentParse$default$2() {
        return true;
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfUnrecognisedEntityType() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "client", "--entity-type", "not-recognised", "--alter", "--add-config", "a=b,c=d"}));
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfBrokerEntityTypeIsNotAnInteger() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "A", "--entity-type", "brokers", "--alter", "--add-config", "a=b,c=d"}));
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test
    public void shouldAddClientConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-client-id", "--entity-type", "clients", "--alter", "--add-config", "a=b,c=d"}));
        public class Kafka_admin_ConfigCommandTest$TestAdminZkClient$1
        extends AdminZkClient {
            public void changeClientIdConfig(String clientId, Properties configChange) {
                Assert.assertEquals((Object)"my-client-id", (Object)clientId);
                Assert.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assert.assertEquals((Object)"d", (Object)configChange.get("c"));
            }

            public Kafka_admin_ConfigCommandTest$TestAdminZkClient$1(ConfigCommandTest $outer, KafkaZkClient zkClient) {
                super(zkClient);
            }
        }
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminZkClient)new Kafka_admin_ConfigCommandTest$TestAdminZkClient$1(null, this.zkClient()));
    }

    @Test
    public void shouldAddTopicConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-topic", "--entity-type", "topics", "--alter", "--add-config", "a=b,c=d"}));
        public class Kafka_admin_ConfigCommandTest$TestAdminZkClient$2
        extends AdminZkClient {
            public void changeTopicConfig(String topic, Properties configChange) {
                Assert.assertEquals((Object)"my-topic", (Object)topic);
                Assert.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assert.assertEquals((Object)"d", (Object)configChange.get("c"));
            }

            public Kafka_admin_ConfigCommandTest$TestAdminZkClient$2(ConfigCommandTest $outer, KafkaZkClient zkClient) {
                super(zkClient);
            }
        }
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminZkClient)new Kafka_admin_ConfigCommandTest$TestAdminZkClient$2(null, this.zkClient()));
    }

    @Test
    public void shouldAddBrokerQuotaConfig() {
        ConfigCommand.ConfigCommandOptions alterOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "leader.replication.throttled.rate=10,follower.replication.throttled.rate=20"}));
        public class Kafka_admin_ConfigCommandTest$TestAdminZkClient$3
        extends AdminZkClient {
            public void changeBrokerConfig(Seq<Object> brokerIds, Properties configChange) {
                Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), brokerIds);
                Assert.assertEquals((Object)"10", (Object)configChange.get("leader.replication.throttled.rate"));
                Assert.assertEquals((Object)"20", (Object)configChange.get("follower.replication.throttled.rate"));
            }

            public Kafka_admin_ConfigCommandTest$TestAdminZkClient$3(ConfigCommandTest $outer, KafkaZkClient zkClient) {
                super(zkClient);
            }
        }
        ConfigCommand$.MODULE$.alterConfig(null, alterOpts, (AdminZkClient)new Kafka_admin_ConfigCommandTest$TestAdminZkClient$3(null, this.zkClient()));
    }

    @Test
    public void shouldAddBrokerDynamicConfig() {
        Node node = new Node(1, "localhost", 9092);
        this.verifyAlterBrokerConfig(node, "1", (List<String>)new .colon.colon((Object)"--entity-name", (List)new .colon.colon((Object)"1", (List)Nil$.MODULE$)));
    }

    @Test
    public void shouldAddBrokerLoggerConfig() {
        Node node = new Node(1, "localhost", 9092);
        this.verifyAlterBrokerLoggerConfig(node, "1", "1", (List<ConfigEntry>)new .colon.colon((Object)new ConfigEntry("kafka.log.LogCleaner", "INFO"), (List)new .colon.colon((Object)new ConfigEntry("kafka.server.ReplicaManager", "INFO"), (List)new .colon.colon((Object)new ConfigEntry("kafka.server.KafkaApi", "INFO"), (List)Nil$.MODULE$))));
    }

    @Test
    public void testNoSpecifiedEntityOptionWithDescribeBrokersInZKIsAllowed() {
        .colon.colon optsList = new .colon.colon((Object)"--zookeeper", (List)new .colon.colon((Object)"localhost:9092", (List)new .colon.colon((Object)"--entity-type", (List)new .colon.colon((Object)ConfigType$.MODULE$.Broker(), (List)new .colon.colon((Object)"--describe", (List)Nil$.MODULE$)))));
        new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class))).checkArgs();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoSpecifiedEntityOptionWithDescribeBrokersInBootstrapServerIsNotAllowed() {
        .colon.colon optsList = new .colon.colon((Object)"--bootstrap-server", (List)new .colon.colon((Object)"localhost:9092", (List)new .colon.colon((Object)"--entity-type", (List)new .colon.colon((Object)ConfigType$.MODULE$.Broker(), (List)new .colon.colon((Object)"--describe", (List)Nil$.MODULE$)))));
        new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class))).checkArgs();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEntityDefaultOptionWithDescribeBrokerLoggerIsNotAllowed() {
        .colon.colon optsList = new .colon.colon((Object)"--bootstrap-server", (List)new .colon.colon((Object)"localhost:9092", (List)new .colon.colon((Object)"--entity-type", (List)new .colon.colon((Object)ConfigCommand$.MODULE$.BrokerLoggerConfigType(), (List)new .colon.colon((Object)"--entity-default", (List)new .colon.colon((Object)"--describe", (List)Nil$.MODULE$))))));
        new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class))).checkArgs();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEntityDefaultOptionWithAlterBrokerLoggerIsNotAllowed() {
        List optsList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-type", ConfigCommand$.MODULE$.BrokerLoggerConfigType(), "--entity-default", "--alter", "--add-config", "kafka.log.LogCleaner=DEBUG"}));
        new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class))).checkArgs();
    }

    @Test(expected=InvalidConfigurationException.class)
    public void shouldRaiseInvalidConfigurationExceptionWhenAddingInvalidBrokerLoggerConfig() {
        Node node = new Node(1, "localhost", 9092);
        this.verifyAlterBrokerLoggerConfig(node, "1", "1", (List<ConfigEntry>)new .colon.colon((Object)new ConfigEntry("kafka.server.KafkaApi", "INFO"), (List)Nil$.MODULE$));
    }

    @Test
    public void shouldAddDefaultBrokerDynamicConfig() {
        Node node = new Node(1, "localhost", 9092);
        this.verifyAlterBrokerConfig(node, "", (List<String>)new .colon.colon((Object)"--entity-default", (List)Nil$.MODULE$));
    }

    public void verifyAlterBrokerConfig(Node node, String resourceName, List<String> resourceOpts) {
        List optsList = (List)new .colon.colon((Object)"--bootstrap-server", (List)new .colon.colon((Object)"localhost:9092", (List)new .colon.colon((Object)"--entity-type", (List)new .colon.colon((Object)"brokers", (List)new .colon.colon((Object)"--alter", (List)new .colon.colon((Object)"--add-config", (List)new .colon.colon((Object)"message.max.bytes=10", (List)Nil$.MODULE$))))))).$plus$plus(resourceOpts, List$.MODULE$.canBuildFrom());
        ConfigCommand.ConfigCommandOptions alterOpts = new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class)));
        scala.collection.mutable.Map brokerConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"num.io.threads"), (Object)"5")}));
        ConfigResource resource = new ConfigResource(ConfigResource.Type.BROKER, resourceName);
        java.util.List<ConfigEntry> configEntries = Collections.singletonList(new ConfigEntry("num.io.threads", "5"));
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(Collections.singletonMap(resource, new Config(configEntries)));
        DescribeConfigsResult describeResult = (DescribeConfigsResult)EasyMock.createNiceMock(DescribeConfigsResult.class);
        EasyMock.expect((Object)describeResult.all()).andReturn((Object)future).once();
        KafkaFutureImpl alterFuture = new KafkaFutureImpl();
        alterFuture.complete(null);
        AlterConfigsResult alterResult = (AlterConfigsResult)EasyMock.createNiceMock(AlterConfigsResult.class);
        EasyMock.expect((Object)alterResult.all()).andReturn((Object)alterFuture);
        MockAdminClient mockAdminClient = new MockAdminClient(null, node, resourceName, describeResult, brokerConfigs, alterResult){
            private final String resourceName$1;
            private final DescribeConfigsResult describeResult$1;
            private final scala.collection.mutable.Map brokerConfigs$1;
            private final AlterConfigsResult alterResult$1;

            public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
                Assert.assertEquals((long)1L, (long)resources.size());
                ConfigResource resource = resources.iterator().next();
                Assert.assertEquals((Object)ConfigResource.Type.BROKER, (Object)resource.type());
                Assert.assertEquals((Object)this.resourceName$1, (Object)resource.name());
                return this.describeResult$1;
            }

            public AlterConfigsResult alterConfigs(java.util.Map<ConfigResource, Config> configs, AlterConfigsOptions options) {
                Assert.assertEquals((long)1L, (long)configs.size());
                Map.Entry<ConfigResource, Config> entry = configs.entrySet().iterator().next();
                ConfigResource resource = entry.getKey();
                Config config = entry.getValue();
                Assert.assertEquals((Object)ConfigResource.Type.BROKER, (Object)resource.type());
                ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(config.entries()).asScala()).foreach((Function1 & Serializable & scala.Serializable)e -> $this.brokerConfigs$1.put((Object)e.name(), (Object)e.value()));
                return this.alterResult$1;
            }
            {
                this.resourceName$1 = resourceName$1;
                this.describeResult$1 = describeResult$1;
                this.brokerConfigs$1 = brokerConfigs$1;
                this.alterResult$1 = alterResult$1;
                super(Collections.singletonList(node$1), node$1);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$alterConfigs$1(kafka.admin.ConfigCommandTest$$anon$1 org.apache.kafka.clients.admin.ConfigEntry )}, serializedLambda);
            }
        };
        EasyMock.replay((Object[])new Object[]{alterResult, describeResult});
        ConfigCommand$.MODULE$.alterBrokerConfig((Admin)mockAdminClient, alterOpts, ConfigType$.MODULE$.Broker(), resourceName);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.max.bytes"), (Object)"10"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"num.io.threads"), (Object)"5")})), (Object)brokerConfigs.toMap(Predef$.MODULE$.$conforms()));
        EasyMock.reset((Object[])new Object[]{alterResult, describeResult});
    }

    public void verifyAlterBrokerLoggerConfig(Node node, String resourceName, String entityName, List<ConfigEntry> describeConfigEntries) {
        List optsList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-type", ConfigCommand$.MODULE$.BrokerLoggerConfigType(), "--alter", "--entity-name", entityName, "--add-config", "kafka.log.LogCleaner=DEBUG", "--delete-config", "kafka.server.ReplicaManager,kafka.server.KafkaApi"}));
        ConfigCommand.ConfigCommandOptions alterOpts = new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class)));
        BooleanRef alteredConfigs = BooleanRef.create((boolean)false);
        ConfigResource resource = new ConfigResource(ConfigResource.Type.BROKER_LOGGER, resourceName);
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(Collections.singletonMap(resource, new Config((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(describeConfigEntries).asJava())));
        DescribeConfigsResult describeResult = (DescribeConfigsResult)EasyMock.createNiceMock(DescribeConfigsResult.class);
        EasyMock.expect((Object)describeResult.all()).andReturn((Object)future).once();
        KafkaFutureImpl alterFuture = new KafkaFutureImpl();
        alterFuture.complete(null);
        AlterConfigsResult alterResult = (AlterConfigsResult)EasyMock.createNiceMock(AlterConfigsResult.class);
        EasyMock.expect((Object)alterResult.all()).andReturn((Object)alterFuture);
        MockAdminClient mockAdminClient = new MockAdminClient(null, node, resourceName, describeResult, alteredConfigs, alterResult){
            private final String resourceName$2;
            private final DescribeConfigsResult describeResult$2;
            private final BooleanRef alteredConfigs$1;
            private final AlterConfigsResult alterResult$2;

            public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources) {
                Assert.assertEquals((long)1L, (long)resources.size());
                ConfigResource resource = resources.iterator().next();
                Assert.assertEquals((Object)ConfigResource.Type.BROKER_LOGGER, (Object)resource.type());
                Assert.assertEquals((Object)this.resourceName$2, (Object)resource.name());
                return this.describeResult$2;
            }

            public AlterConfigsResult incrementalAlterConfigs(java.util.Map<ConfigResource, Collection<AlterConfigOp>> configs, AlterConfigsOptions options) {
                Assert.assertEquals((long)1L, (long)configs.size());
                Map.Entry<ConfigResource, Collection<AlterConfigOp>> entry = configs.entrySet().iterator().next();
                ConfigResource resource = entry.getKey();
                Collection<AlterConfigOp> alterConfigOps = entry.getValue();
                Assert.assertEquals((Object)ConfigResource.Type.BROKER_LOGGER, (Object)resource.type());
                Assert.assertEquals((long)3L, (long)alterConfigOps.size());
                .colon.colon expectedConfigOps = new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.log.LogCleaner", "DEBUG"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.server.ReplicaManager", ""), AlterConfigOp.OpType.DELETE), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.server.KafkaApi", ""), AlterConfigOp.OpType.DELETE), (List)Nil$.MODULE$)));
                Assert.assertEquals((Object)expectedConfigOps, (Object)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(alterConfigOps).asScala()).toList());
                this.alteredConfigs$1.elem = true;
                return this.alterResult$2;
            }
            {
                this.resourceName$2 = resourceName$2;
                this.describeResult$2 = describeResult$2;
                this.alteredConfigs$1 = alteredConfigs$1;
                this.alterResult$2 = alterResult$2;
                super(Collections.singletonList(node$2), node$2);
            }
        };
        EasyMock.replay((Object[])new Object[]{alterResult, describeResult});
        ConfigCommand$.MODULE$.alterBrokerConfig((Admin)mockAdminClient, alterOpts, ConfigCommand$.MODULE$.BrokerLoggerConfigType(), resourceName);
        Assert.assertTrue((boolean)alteredConfigs.elem);
        EasyMock.reset((Object[])new Object[]{alterResult, describeResult});
    }

    @Test
    public void shouldSupportCommaSeparatedValues() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-topic", "--entity-type", "topics", "--alter", "--add-config", "a=b,c=[d,e ,f],g=[h,i]"}));
        public class Kafka_admin_ConfigCommandTest$TestAdminZkClient$4
        extends AdminZkClient {
            public void changeBrokerConfig(Seq<Object> brokerIds, Properties configChange) {
                Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), brokerIds);
                Assert.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assert.assertEquals((Object)"d,e ,f", (Object)configChange.get("c"));
                Assert.assertEquals((Object)"h,i", (Object)configChange.get("g"));
            }

            public void changeTopicConfig(String topic, Properties configs) {
            }

            public Kafka_admin_ConfigCommandTest$TestAdminZkClient$4(ConfigCommandTest $outer, KafkaZkClient zkClient) {
                super(zkClient);
            }
        }
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminZkClient)new Kafka_admin_ConfigCommandTest$TestAdminZkClient$4(null, this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedEntityName() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1,2,3", "--entity-type", "brokers", "--alter", "--add-config", "leader.replication.throttled.rate=10"}));
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test
    public void testDynamicBrokerConfigUpdateUsingZooKeeper() {
        String brokerId = "1";
        AdminZkClient adminZkClient = new AdminZkClient(this.zkClient());
        String[] alterOpts = (String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-type", "brokers", "--alter"});
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.max.size"), (Object)"110000")})), (Option)new Some((Object)brokerId), alterOpts, adminZkClient);
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.max.size"), (Object)"120000")})), (Option)None$.MODULE$, alterOpts, adminZkClient);
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.max.size"), (Object)"130000")})), (Option)new Some((Object)brokerId), alterOpts, adminZkClient);
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.max.size"), (Object)"140000")})), (Option)None$.MODULE$, alterOpts, adminZkClient);
        this.deleteAndVerifyConfig$1((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message.max.size"})), (Option)new Some((Object)brokerId), alterOpts, adminZkClient);
        this.deleteAndVerifyConfig$1((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message.max.size"})), (Option)None$.MODULE$, alterOpts, adminZkClient);
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"listener.name.external.ssl.keystore.location"), (Object)"/tmp/test.jks")})), (Option)new Some((Object)brokerId), alterOpts, adminZkClient);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.alterConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/tmp/test.jks")})), (Option)new Some((Object)brokerId), ConfigCommandTest.alterConfig$default$3$1(), alterOpts, adminZkClient), ClassTag$.MODULE$.apply(ConfigException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 498));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.alterConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"listener.name.external.ssl.keystore.location"), (Object)"/tmp/test.jks")})), (Option)None$.MODULE$, ConfigCommandTest.alterConfig$default$3$1(), alterOpts, adminZkClient), ClassTag$.MODULE$.apply(ConfigException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 501));
        this.deleteAndVerifyConfig$1((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"listener.name.external.ssl.keystore.location"})), (Option)new Some((Object)brokerId), alterOpts, adminZkClient);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.alterConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"listener.name.external.ssl.keystore.password"), (Object)"secret")})), (Option)new Some((Object)brokerId), ConfigCommandTest.alterConfig$default$3$1(), alterOpts, adminZkClient), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 505));
        scala.collection.immutable.Map configs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"listener.name.external.ssl.keystore.password"), (Object)"secret"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"log.cleaner.threads"), (Object)"2")}));
        scala.collection.immutable.Map encoderConfigs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.PasswordEncoderSecretProp()), (Object)"encoder-secret")}));
        this.alterConfig$1(configs, (Option)new Some((Object)brokerId), encoderConfigs, alterOpts, adminZkClient);
        Properties brokerConfigs = this.zkClient().getEntityConfigs("brokers", brokerId);
        Assert.assertFalse((String)"Encoder secret stored in ZooKeeper", (boolean)brokerConfigs.contains(KafkaConfig$.MODULE$.PasswordEncoderSecretProp()));
        Assert.assertEquals((Object)"2", (Object)brokerConfigs.getProperty("log.cleaner.threads"));
        String encodedPassword = brokerConfigs.getProperty("listener.name.external.ssl.keystore.password");
        PasswordEncoder passwordEncoder = ConfigCommand$.MODULE$.createPasswordEncoder((Map)encoderConfigs);
        Assert.assertEquals((Object)"secret", (Object)passwordEncoder.decode(encodedPassword).value());
        Assert.assertEquals((long)configs.size(), (long)brokerConfigs.size());
        scala.collection.immutable.Map configs2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"listener.name.internal.ssl.keystore.password"), (Object)"secret2")}));
        scala.collection.immutable.Map encoderConfigs2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.PasswordEncoderSecretProp()), (Object)"encoder-secret"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.PasswordEncoderCipherAlgorithmProp()), (Object)"DES/CBC/PKCS5Padding"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.PasswordEncoderIterationsProp()), (Object)"1024"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.PasswordEncoderKeyFactoryAlgorithmProp()), (Object)"PBKDF2WithHmacSHA1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.PasswordEncoderKeyLengthProp()), (Object)"64")}));
        this.alterConfig$1(configs2, (Option)new Some((Object)brokerId), encoderConfigs2, alterOpts, adminZkClient);
        Properties brokerConfigs2 = this.zkClient().getEntityConfigs("brokers", brokerId);
        String encodedPassword2 = brokerConfigs2.getProperty("listener.name.internal.ssl.keystore.password");
        Assert.assertEquals((Object)"secret2", (Object)ConfigCommand$.MODULE$.createPasswordEncoder((Map)encoderConfigs).decode(encodedPassword2).value());
        Assert.assertEquals((Object)"secret2", (Object)ConfigCommand$.MODULE$.createPasswordEncoder((Map)encoderConfigs2).decode(encodedPassword2).value());
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.alterConfig$1(configs, (Option)None$.MODULE$, encoderConfigs, alterOpts, adminZkClient), ClassTag$.MODULE$.apply(ConfigException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 534));
        this.registerBrokerInZk(new StringOps(Predef$.MODULE$.augmentString(brokerId)).toInt());
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.alterConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.max.size"), (Object)"210000")})), (Option)new Some((Object)brokerId), ConfigCommandTest.alterConfig$default$3$1(), alterOpts, adminZkClient), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 538));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.alterConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.max.size"), (Object)"220000")})), (Option)None$.MODULE$, ConfigCommandTest.alterConfig$default$3$1(), alterOpts, adminZkClient), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 539));
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.max.size"), (Object)"230000")})), (Option)new Some((Object)"2"), alterOpts, adminZkClient);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a=="}));
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedBracketConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a=[b,c,d=e"}));
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=InvalidConfigurationException.class)
    public void shouldNotUpdateBrokerConfigIfNonExistingConfigIsDeleted() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-topic", "--entity-type", "topics", "--alter", "--delete-config", "missing_config1, missing_config2"}));
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test
    public void shouldDeleteBrokerConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--delete-config", "a,c"}));
        public class Kafka_admin_ConfigCommandTest$TestAdminZkClient$5
        extends AdminZkClient {
            /*
             * WARNING - void declaration
             */
            public Properties fetchEntityConfig(String entityType, String entityName) {
                void var3_3;
                Properties properties = new Properties();
                properties.put("a", "b");
                properties.put("c", "d");
                properties.put("e", "f");
                return var3_3;
            }

            public void changeBrokerConfig(Seq<Object> brokerIds, Properties configChange) {
                Assert.assertEquals((Object)"f", (Object)configChange.get("e"));
                Assert.assertEquals((long)1L, (long)configChange.size());
            }

            public Kafka_admin_ConfigCommandTest$TestAdminZkClient$5(ConfigCommandTest $outer, KafkaZkClient zkClient) {
                super(zkClient);
            }
        }
        ConfigCommand$.MODULE$.alterConfig(null, createOpts, (AdminZkClient)new Kafka_admin_ConfigCommandTest$TestAdminZkClient$5(null, this.zkClient()));
    }

    @Test
    public void testScramCredentials() {
        LazyRef CredentialChange$module = new LazyRef();
        scala.collection.mutable.Map credentials = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        ConfigCommand.ConfigCommandOptions optsA = this.createOpts$1("userA", "SCRAM-SHA-256=[iterations=8192,password=abc, def]");
        public class Kafka_admin_ConfigCommandTest$CredentialChange$1
        extends AdminZkClient
        implements Product,
        scala.Serializable {
            private final String user;
            private final Set<String> mechanisms;
            private final int iterations;
            private final /* synthetic */ ConfigCommandTest $outer;
            private final scala.collection.mutable.Map credentials$1;

            public String user() {
                return this.user;
            }

            public Set<String> mechanisms() {
                return this.mechanisms;
            }

            public int iterations() {
                return this.iterations;
            }

            public Properties fetchEntityConfig(String entityType, String entityName) {
                return (Properties)this.credentials$1.getOrElse((Object)entityName, (Function0 & Serializable & scala.Serializable)() -> new Properties());
            }

            public void changeUserOrUserClientIdConfig(String sanitizedEntityName, Properties configChange) {
                Assert.assertEquals((Object)this.user(), (Object)sanitizedEntityName);
                Assert.assertEquals(this.mechanisms(), (Object)JavaConverters$.MODULE$.asScalaSetConverter(configChange.keySet()).asScala());
                this.mechanisms().foreach((Function1 & Serializable & scala.Serializable)mechanism -> {
                    String value = configChange.getProperty((String)mechanism);
                    Assert.assertEquals((long)-1L, (long)value.indexOf("password="));
                    ScramCredential scramCredential = ScramCredentialUtils.credentialFromString((String)value);
                    Assert.assertEquals((long)this.iterations(), (long)scramCredential.iterations());
                    return configChange != null ? $this.credentials$1.put((Object)this.user(), (Object)configChange) : BoxedUnit.UNIT;
                });
            }

            public Kafka_admin_ConfigCommandTest$CredentialChange$1 copy(String user, Set<String> mechanisms, int iterations) {
                return new Kafka_admin_ConfigCommandTest$CredentialChange$1(this.$outer, user, mechanisms, iterations, this.credentials$1);
            }

            public String copy$default$1() {
                return this.user();
            }

            public Set<String> copy$default$2() {
                return this.mechanisms();
            }

            public int copy$default$3() {
                return this.iterations();
            }

            public String productPrefix() {
                return "CredentialChange";
            }

            public int productArity() {
                return 3;
            }

            public Object productElement(int x$1) {
                Object object;
                int n = x$1;
                switch (n) {
                    case 0: {
                        object = this.user();
                        break;
                    }
                    case 1: {
                        object = this.mechanisms();
                        break;
                    }
                    case 2: {
                        object = BoxesRunTime.boxToInteger((int)this.iterations());
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                }
                return object;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Kafka_admin_ConfigCommandTest$CredentialChange$1;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.user()));
                n = Statics.mix((int)n, (int)Statics.anyHash(this.mechanisms()));
                n = Statics.mix((int)n, (int)this.iterations());
                return Statics.finalizeHash((int)n, (int)3);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Kafka_admin_ConfigCommandTest$CredentialChange$1)) return false;
                boolean bl = true;
                if (!bl) return false;
                Kafka_admin_ConfigCommandTest$CredentialChange$1 var4_4 = (Kafka_admin_ConfigCommandTest$CredentialChange$1)((Object)x$1);
                String string = this.user();
                String string2 = var4_4.user();
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                Set<String> set = this.mechanisms();
                Set<String> set2 = var4_4.mechanisms();
                if (set == null) {
                    if (set2 != null) {
                        return false;
                    }
                } else if (!set.equals(set2)) return false;
                if (this.iterations() != var4_4.iterations()) return false;
                if (!var4_4.canEqual((Object)((Object)this))) return false;
                return true;
            }

            /*
             * WARNING - void declaration
             */
            public Kafka_admin_ConfigCommandTest$CredentialChange$1(String user, Set<String> mechanisms, int iterations) {
                void var5_5;
                this.user = user;
                this.mechanisms = mechanisms;
                this.iterations = iterations;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.credentials$1 = var5_5;
                super($outer.zkClient());
                Product.$init$((Product)this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$fetchEntityConfig$1(), $anonfun$changeUserOrUserClientIdConfig$1(kafka.admin.ConfigCommandTest$CredentialChange$1 java.util.Properties java.lang.String )}, serializedLambda);
            }
        }
        ConfigCommand$.MODULE$.alterConfig(null, optsA, (AdminZkClient)this.CredentialChange$3(CredentialChange$module, credentials).apply("userA", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SCRAM-SHA-256"}))), 8192));
        ConfigCommand.ConfigCommandOptions optsB = this.createOpts$1("userB", "SCRAM-SHA-256=[iterations=4096,password=abc, def],SCRAM-SHA-512=[password=1234=abc]");
        ConfigCommand$.MODULE$.alterConfig(null, optsB, (AdminZkClient)this.CredentialChange$3(CredentialChange$module, credentials).apply("userB", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SCRAM-SHA-256", "SCRAM-SHA-512"}))), 4096));
        ConfigCommand.ConfigCommandOptions del256 = this.deleteOpts$1("userB", "SCRAM-SHA-256");
        ConfigCommand$.MODULE$.alterConfig(null, del256, (AdminZkClient)this.CredentialChange$3(CredentialChange$module, credentials).apply("userB", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SCRAM-SHA-512"}))), 4096));
        ConfigCommand.ConfigCommandOptions del512 = this.deleteOpts$1("userB", "SCRAM-SHA-512");
        ConfigCommand$.MODULE$.alterConfig(null, del512, (AdminZkClient)this.CredentialChange$3(CredentialChange$module, credentials).apply("userB", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)), 4096));
    }

    @Test
    public void testQuotaConfigEntity() {
        String[] describeOpts = (String[])((Object[])new String[]{"--describe"});
        String[] alterOpts = (String[])((Object[])new String[]{"--alter", "--add-config", "a=b,c=d"});
        String clientId = "client-1";
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{describeOpts, alterOpts}))).foreach((Function1 & Serializable & scala.Serializable)opts -> {
            ConfigCommandTest.$anonfun$testQuotaConfigEntity$1(this, clientId, opts);
            return BoxedUnit.UNIT;
        });
        this.checkEntity$1("clients", (Option)None$.MODULE$, "", describeOpts);
        this.checkInvalidEntity$1("clients", (Option)None$.MODULE$, alterOpts);
        String principal = "CN=ConfigCommandTest,O=Apache,L=<default>";
        String sanitizedPrincipal = Sanitizer.sanitize((String)principal);
        Assert.assertEquals((long)-1L, (long)sanitizedPrincipal.indexOf(61));
        Assert.assertEquals((Object)principal, (Object)Sanitizer.desanitize((String)sanitizedPrincipal));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{describeOpts, alterOpts}))).foreach((Function1 & Serializable & scala.Serializable)opts -> {
            ConfigCommandTest.$anonfun$testQuotaConfigEntity$2(this, principal, sanitizedPrincipal, opts);
            return BoxedUnit.UNIT;
        });
        this.checkEntity$1("users", (Option)None$.MODULE$, "", describeOpts);
        this.checkInvalidEntity$1("users", (Option)None$.MODULE$, alterOpts);
        String userClient = new StringBuilder(9).append(sanitizedPrincipal).append("/clients/").append(clientId).toString();
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{describeOpts, alterOpts}))).foreach((Function1 & Serializable & scala.Serializable)opts -> {
            ConfigCommandTest.$anonfun$testQuotaConfigEntity$3(this, principal, userClient, clientId, sanitizedPrincipal, describeOpts, opts);
            return BoxedUnit.UNIT;
        });
        this.checkEntity$1("users", (Option)new Some((Object)principal), new StringBuilder(8).append(sanitizedPrincipal).append("/clients").toString(), (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeOpts)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--entity-type", "clients"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        this.checkInvalidEntity$1("users", (Option)new Some((Object)principal), (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])alterOpts)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--entity-type", "clients"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        this.checkInvalidEntity$1("users", (Option)None$.MODULE$, (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])alterOpts)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ConfigCommandTest.clientIdOpts$1(clientId))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        this.checkInvalidEntity$1("users", (Option)None$.MODULE$, (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])alterOpts)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--entity-type", "clients"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
    }

    @Test
    public void testUserClientQuotaOpts() {
        this.checkEntity$2("users", Sanitizer.sanitize((String)"<default>"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "users", "--entity-name", "<default>", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("clients", Sanitizer.sanitize((String)"<default>"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-name", "<default>", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("users", new StringBuilder(16).append(Sanitizer.sanitize((String)"CN=user1")).append("/clients/client1").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "users", "--entity-name", "CN=user1", "--entity-type", "clients", "--entity-name", "client1", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("users", new StringBuilder(16).append(Sanitizer.sanitize((String)"CN=user1")).append("/clients/client1").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name", "CN=user1", "--entity-type", "users", "--entity-name", "client1", "--entity-type", "clients", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("users", new StringBuilder(16).append(Sanitizer.sanitize((String)"CN=user1")).append("/clients/client1").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-name", "client1", "--entity-type", "users", "--entity-name", "CN=user1", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("users", new StringBuilder(16).append(Sanitizer.sanitize((String)"CN=user1")).append("/clients/client1").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name", "client1", "--entity-type", "clients", "--entity-name", "CN=user1", "--entity-type", "users", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("users", new StringBuilder(8).append(Sanitizer.sanitize((String)"CN=user1")).append("/clients").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-name", "CN=user1", "--entity-type", "users", "--describe"}));
        this.checkEntity$2("users", "/clients", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-type", "users", "--describe"}));
        this.checkEntity$2("users", new StringBuilder(9).append(Sanitizer.sanitize((String)"CN=user1")).append("/clients/").append(Sanitizer.sanitize((String)"client1?@%")).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name", "client1?@%", "--entity-type", "clients", "--entity-name", "CN=user1", "--entity-type", "users", "--alter", "--add-config", "a=b,c=d"}));
    }

    @Test
    public void testQuotaDescribeEntities() {
        KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createNiceMock(KafkaZkClient.class);
        String clientId = "a-client";
        String principal = "CN=ConfigCommandTest.testQuotaDescribeEntities , O=Apache, L=<default>";
        String sanitizedPrincipal = Sanitizer.sanitize((String)principal);
        String userClient = new StringBuilder(9).append(sanitizedPrincipal).append("/clients/").append(clientId).toString();
        String[] opts = (String[])((Object[])new String[]{"--entity-type", "clients", "--entity-name", clientId});
        ConfigCommandTest.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{clientId})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "clients", "--entity-default"});
        ConfigCommandTest.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>"})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "clients"});
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clients"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{clientId})))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{clientId})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-name", principal});
        ConfigCommandTest.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sanitizedPrincipal})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-default"});
        ConfigCommandTest.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>"})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users"});
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"users"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>", sanitizedPrincipal})))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>", sanitizedPrincipal})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-name", principal, "--entity-type", "clients", "--entity-name", clientId});
        ConfigCommandTest.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{userClient})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-name", principal, "--entity-type", "clients", "--entity-default"});
        ConfigCommandTest.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(18).append(sanitizedPrincipal).append("/clients/<default>").toString()})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-name", principal, "--entity-type", "clients"});
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(14).append("users/").append(sanitizedPrincipal).append("/clients").toString()), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client-4"})))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(17).append(sanitizedPrincipal).append("/clients/client-4").toString()})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-default", "--entity-type", "clients"});
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"users/<default>/clients"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client-5"})))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>/clients/client-5"})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-type", "clients"});
        scala.collection.immutable.Map userMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(14).append("users/").append(sanitizedPrincipal).append("/clients").toString()), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client-2"})))}));
        scala.collection.immutable.Map defaultUserMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"users/<default>/clients"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client-3"})))}));
        ConfigCommandTest.checkEntities$1(opts, ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"users"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>", sanitizedPrincipal})))}))).$plus$plus((GenTraversableOnce)defaultUserMap).$plus$plus((GenTraversableOnce)userMap), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>/clients/client-3", new StringBuilder(17).append(sanitizedPrincipal).append("/clients/client-2").toString()})), zkClient);
    }

    private void registerBrokerInZk(int id) {
        this.zkClient().createTopLevelPaths();
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        EndPoint endpoint = new EndPoint("localhost", 9092, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol);
        BrokerInfo brokerInfo = BrokerInfo$.MODULE$.apply(new Broker(id, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{endpoint})), (Option)None$.MODULE$), ApiVersion$.MODULE$.latestVersion(), 9192);
        this.zkClient().registerBroker(brokerInfo);
    }

    public static final /* synthetic */ Nothing$ $anonfun$assertNonZeroStatusExit$1(ObjectRef exitStatus$1, int status, Option x$1) {
        exitStatus$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)status));
        throw new RuntimeException();
    }

    private static final String[] entityOpt$1(Option brokerId) {
        return (String[])brokerId.map((Function1 & Serializable & scala.Serializable)id -> (String[])((Object[])new String[]{"--entity-name", id})).getOrElse((Function0 & Serializable & scala.Serializable)() -> (String[])((Object[])new String[]{"--entity-default"}));
    }

    private final void alterConfig$1(scala.collection.immutable.Map configs, Option brokerId, scala.collection.immutable.Map encoderConfigs, String[] alterOpts$1, AdminZkClient adminZkClient$1) {
        String configStr = ((TraversableOnce)configs.$plus$plus((GenTraversableOnce)encoderConfigs).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            String string = new StringBuilder(1).append(k).append("=").append(v).toString();
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).mkString(",");
        ConfigCommand.ConfigCommandOptions addOpts = new ConfigCommand.ConfigCommandOptions((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])alterOpts$1)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ConfigCommandTest.entityOpt$1(brokerId))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--add-config", configStr})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        ConfigCommand$.MODULE$.alterConfig(this.zkClient(), addOpts, adminZkClient$1);
    }

    private static final scala.collection.immutable.Map alterConfig$default$3$1() {
        return Predef$.MODULE$.Map().empty();
    }

    private final void verifyConfig$1(scala.collection.immutable.Map configs, Option brokerId) {
        Properties entityConfigs = this.zkClient().getEntityConfigs("brokers", (String)brokerId.getOrElse((Function0 & Serializable & scala.Serializable)() -> ConfigEntityName$.MODULE$.Default()));
        Assert.assertEquals((Object)configs, (Object)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(entityConfigs).asScala());
    }

    private final void alterAndVerifyConfig$1(scala.collection.immutable.Map configs, Option brokerId, String[] alterOpts$1, AdminZkClient adminZkClient$1) {
        this.alterConfig$1(configs, brokerId, ConfigCommandTest.alterConfig$default$3$1(), alterOpts$1, adminZkClient$1);
        this.verifyConfig$1(configs, brokerId);
    }

    private final void deleteAndVerifyConfig$1(Set configNames, Option brokerId, String[] alterOpts$1, AdminZkClient adminZkClient$1) {
        ConfigCommand.ConfigCommandOptions deleteOpts = new ConfigCommand.ConfigCommandOptions((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])alterOpts$1)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ConfigCommandTest.entityOpt$1(brokerId))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--delete-config", configNames.mkString(",")})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        ConfigCommand$.MODULE$.alterConfig(this.zkClient(), deleteOpts, adminZkClient$1);
        this.verifyConfig$1(Predef$.MODULE$.Map().empty(), brokerId);
    }

    private final ConfigCommand.ConfigCommandOptions createOpts$1(String user, String config) {
        return new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", user, "--entity-type", "users", "--alter", "--add-config", config}));
    }

    private final ConfigCommand.ConfigCommandOptions deleteOpts$1(String user, String mechanism) {
        return new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", user, "--entity-type", "users", "--alter", "--delete-config", mechanism}));
    }

    private final /* synthetic */ ConfigCommandTest$CredentialChange$2$ CredentialChange$lzycompute$1(LazyRef CredentialChange$module$1, scala.collection.mutable.Map credentials$1) {
        ConfigCommandTest$CredentialChange$2$ configCommandTest$CredentialChange$2$;
        LazyRef lazyRef = CredentialChange$module$1;
        synchronized (lazyRef) {
            configCommandTest$CredentialChange$2$ = CredentialChange$module$1.initialized() ? (ConfigCommandTest$CredentialChange$2$)((Object)CredentialChange$module$1.value()) : (ConfigCommandTest$CredentialChange$2$)((Object)CredentialChange$module$1.initialize((Object)new ConfigCommandTest$CredentialChange$2$(this, credentials$1)));
        }
        return configCommandTest$CredentialChange$2$;
    }

    private final ConfigCommandTest$CredentialChange$2$ CredentialChange$3(LazyRef CredentialChange$module$1, scala.collection.mutable.Map credentials$1) {
        return CredentialChange$module$1.initialized() ? (ConfigCommandTest$CredentialChange$2$)((Object)CredentialChange$module$1.value()) : this.CredentialChange$lzycompute$1(CredentialChange$module$1, credentials$1);
    }

    private final ConfigCommand.ConfigCommandOptions createOpts$2(String entityType, Option entityName, String[] otherArgs) {
        String[] stringArray;
        String[] optArray = (String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-type", entityType});
        Option option = entityName;
        if (option instanceof Some) {
            Some some = (Some)option;
            String name = (String)some.value();
            stringArray = (String[])((Object[])new String[]{"--entity-name", name});
        } else if (None$.MODULE$.equals(option)) {
            stringArray = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        } else {
            throw new MatchError((Object)option);
        }
        String[] nameArray = stringArray;
        return new ConfigCommand.ConfigCommandOptions((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])optArray)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nameArray)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])otherArgs)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
    }

    private final void checkEntity$1(String entityType, Option entityName, String expectedEntityName, String[] otherArgs) {
        ConfigCommand.ConfigCommandOptions opts = this.createOpts$2(entityType, entityName, otherArgs);
        opts.checkArgs();
        ConfigCommand.ConfigEntity entity = ConfigCommand$.MODULE$.parseEntity(opts);
        Assert.assertEquals((Object)entityType, (Object)entity.root().entityType());
        Assert.assertEquals((Object)expectedEntityName, (Object)entity.fullSanitizedName());
    }

    private final void checkInvalidEntity$1(String entityType, Option entityName, String[] otherArgs) {
        ConfigCommand.ConfigCommandOptions opts = this.createOpts$2(entityType, entityName, otherArgs);
        try {
            opts.checkArgs();
            ConfigCommand$.MODULE$.parseEntity(opts);
            Assert.fail((String)"Did not fail with invalid argument list");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public static final /* synthetic */ void $anonfun$testQuotaConfigEntity$1(ConfigCommandTest $this, String clientId$1, String[] opts) {
        $this.checkEntity$1("clients", (Option)new Some((Object)clientId$1), clientId$1, opts);
        $this.checkEntity$1("clients", (Option)new Some((Object)""), ConfigEntityName$.MODULE$.Default(), opts);
    }

    public static final /* synthetic */ void $anonfun$testQuotaConfigEntity$2(ConfigCommandTest $this, String principal$1, String sanitizedPrincipal$1, String[] opts) {
        $this.checkEntity$1("users", (Option)new Some((Object)principal$1), sanitizedPrincipal$1, opts);
        $this.checkEntity$1("users", (Option)new Some((Object)""), ConfigEntityName$.MODULE$.Default(), opts);
    }

    private static final String[] clientIdOpts$1(String name) {
        return (String[])((Object[])new String[]{"--entity-type", "clients", "--entity-name", name});
    }

    public static final /* synthetic */ void $anonfun$testQuotaConfigEntity$3(ConfigCommandTest $this, String principal$1, String userClient$1, String clientId$1, String sanitizedPrincipal$1, String[] describeOpts$1, String[] opts) {
        $this.checkEntity$1("users", (Option)new Some((Object)principal$1), userClient$1, (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])opts)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ConfigCommandTest.clientIdOpts$1(clientId$1))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        $this.checkEntity$1("users", (Option)new Some((Object)principal$1), new StringBuilder(9).append(sanitizedPrincipal$1).append("/clients/").append(ConfigEntityName$.MODULE$.Default()).toString(), (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])opts)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ConfigCommandTest.clientIdOpts$1(""))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        $this.checkEntity$1("users", (Option)new Some((Object)""), new StringBuilder(9).append(ConfigEntityName$.MODULE$.Default()).append("/clients/").append(clientId$1).toString(), (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeOpts$1)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ConfigCommandTest.clientIdOpts$1(clientId$1))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        $this.checkEntity$1("users", (Option)new Some((Object)""), new StringBuilder(9).append(ConfigEntityName$.MODULE$.Default()).append("/clients/").append(ConfigEntityName$.MODULE$.Default()).toString(), (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])opts)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ConfigCommandTest.clientIdOpts$1(""))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
    }

    private final void checkEntity$2(String expectedEntityType, String expectedEntityName, Seq args) {
        ConfigCommand.ConfigCommandOptions opts = new ConfigCommand.ConfigCommandOptions((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--zookeeper", this.zkConnect()})).$plus$plus((GenTraversableOnce)args, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        opts.checkArgs();
        ConfigCommand.ConfigEntity entity = ConfigCommand$.MODULE$.parseEntity(opts);
        Assert.assertEquals((Object)expectedEntityType, (Object)entity.root().entityType());
        Assert.assertEquals((Object)expectedEntityName, (Object)entity.fullSanitizedName());
    }

    private static final void checkEntities$1(String[] opts, scala.collection.immutable.Map expectedFetches, Seq expectedEntityNames, KafkaZkClient zkClient$1) {
        ConfigCommand.ConfigEntity entity = ConfigCommand$.MODULE$.parseEntity(new ConfigCommand.ConfigCommandOptions((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])opts)).$colon$plus((Object)"--describe", ClassTag$.MODULE$.apply(String.class))));
        expectedFetches.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            Seq values = (Seq)tuple2._2();
            IExpectationSetters iExpectationSetters = EasyMock.expect((Object)zkClient$1.getAllEntitiesWithConfig(name)).andReturn((Object)values);
            return iExpectationSetters;
        });
        EasyMock.replay((Object[])new Object[]{zkClient$1});
        Seq entities = entity.getAllEntities(zkClient$1);
        Assert.assertEquals((Object)expectedEntityNames, (Object)entities.map((Function1 & Serializable & scala.Serializable)e -> e.fullSanitizedName(), Seq$.MODULE$.canBuildFrom()));
        EasyMock.reset((Object[])new Object[]{zkClient$1});
    }

    public class DummyAdminZkClient
    extends AdminZkClient {
        public void changeBrokerConfig(Seq<Object> brokerIds, Properties configs) {
        }

        public Properties fetchEntityConfig(String entityType, String entityName) {
            return new Properties();
        }

        public void changeClientIdConfig(String clientId, Properties configs) {
        }

        public void changeUserOrUserClientIdConfig(String sanitizedEntityName, Properties configs) {
        }

        public void changeTopicConfig(String topic, Properties configs) {
        }

        public /* synthetic */ ConfigCommandTest kafka$admin$ConfigCommandTest$DummyAdminZkClient$$$outer() {
            return ConfigCommandTest.this;
        }

        public DummyAdminZkClient(KafkaZkClient zkClient) {
            if (ConfigCommandTest.this == null) {
                throw null;
            }
            super(zkClient);
        }
    }
}

